/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.workflow;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.TaskURLGenerator;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.KernelHelper;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.messaging.Message;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.FilterFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.util.Assert;
import com.arsdigita.web.URL;
import com.arsdigita.workflow.simple.TaskComment;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.UserTask;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class CMSTask
extends UserTask {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/workflow/CMSTask.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.workflow.CMSTask";
    private static final String TASK_TYPE = "taskType";
    private static Map s_taskURLGeneratorCache = new HashMap();
    public static final BigDecimal AUTHOR = new BigDecimal(1.0);
    public static final BigDecimal EDIT = new BigDecimal(2.0);
    public static final BigDecimal DEPLOY = new BigDecimal(3.0);
    public static final String UNFINISHED_OP = "unfinished";
    private static final Map s_alerts = new HashMap(5);
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$workflow$CMSTask == null ? (class$com$arsdigita$cms$workflow$CMSTask = CMSTask.class$("com.arsdigita.cms.workflow.CMSTask")) : class$com$arsdigita$cms$workflow$CMSTask));
    static /* synthetic */ Class class$com$arsdigita$cms$workflow$CMSTask;

    public CMSTask() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected CMSTask(ObjectType type) {
        super(type);
    }

    protected CMSTask(String typeName) {
        super(typeName);
    }

    public CMSTask(DataObject CMSTaskObject) {
        super(CMSTaskObject);
    }

    public CMSTask(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public CMSTask(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.setTaskType(AUTHOR);
        }
    }

    public void setTaskType(BigDecimal taskType) {
        this.set(TASK_TYPE, taskType);
    }

    public BigDecimal getTaskType() {
        return (BigDecimal)this.get(TASK_TYPE);
    }

    public String getFinishURL(BigDecimal itemId) {
        if (itemId == null) {
            return "";
        }
        TaskURLGenerator generator = this.getURLGenerator(this.getTaskType());
        return generator.generateURL(itemId, this.getID());
    }

    protected String getAuthoringURL(ContentItem item) {
        return ContentItemPage.getItemURL(item, ContentItemPage.AUTHORING_TAB);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentItem getItem() {
        DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.workflow.getItemFromTask");
        query.setParameter("taskID", (Object)this.getID());
        try {
            if (query.next()) {
                DataObject obj = (DataObject)query.get("obj");
                ContentItem contentItem = (ContentItem)DomainObjectFactory.newInstance((DataObject)obj);
                return contentItem;
            }
            ContentItem contentItem = null;
            return contentItem;
        }
        finally {
            query.close();
        }
    }

    public void enableEvt() {
        super.enableEvt();
        DataOperation oper = SessionManager.getSession().retrieveDataOperation("com.arsdigita.cms.workflow.clearNotifications");
        oper.setParameter("taskID", (Object)this.getID());
        oper.execute();
    }

    private TaskURLGenerator getURLGenerator(BigDecimal taskTypeID) {
        TaskURLGenerator t = (TaskURLGenerator)s_taskURLGeneratorCache.get(taskTypeID);
        if (t == null) {
            Session s = SessionManager.getSession();
            DataQuery query = s.retrieveQuery("com.arsdigita.cms.workflow.getTaskTypes");
            query.addEqualsFilter("Id", (Object)taskTypeID);
            if (query.next()) {
                String className = (String)query.get("className");
                query.close();
                try {
                    Class<?> URLGenerator = Class.forName(className);
                    t = (TaskURLGenerator)URLGenerator.newInstance();
                    s_taskURLGeneratorCache.put(taskTypeID, t);
                }
                catch (ClassNotFoundException c) {
                    s_log.error((Object)"Couldn't find class", (Throwable)c);
                }
                catch (IllegalAccessException i) {
                    s_log.error((Object)"Couldn't access constructor or newInstance", (Throwable)i);
                }
                catch (InstantiationException n) {
                    s_log.error((Object)"Couldn't instantiate", (Throwable)n);
                }
            }
        }
        return t;
    }

    protected Message generateMessage(String operation, Party sender) {
        ContentItem item = this.getItem();
        Assert.assertNotNull((Object)item, (String)"item associated with this CMSTask");
        String emailURL = null;
        emailURL = "enable".equals(operation) ? this.getFinishURL(item.getID()) : this.getAuthoringURL(item);
        String fullURL = URL.there((String)emailURL, null).getURL();
        Object[] g11nArgs = new Object[9];
        g11nArgs[0] = item.getDisplayName();
        g11nArgs[1] = new Double(this.getTaskType().doubleValue());
        g11nArgs[2] = fullURL;
        g11nArgs[3] = KernelHelper.getSiteName();
        g11nArgs[4] = KernelHelper.getSystemAdministratorEmailAddress();
        g11nArgs[5] = new Date();
        TaskComment comment = this.getLastCommentInWorkflow();
        User commenter = null;
        if (comment != null) {
            commenter = comment.getUser();
            g11nArgs[6] = comment.getComment();
        } else {
            g11nArgs[6] = "";
        }
        g11nArgs[7] = commenter != null ? commenter.getName() : (String)GlobalizationUtil.globalize("cms.ui.unknown").localize();
        g11nArgs[8] = this.getStartDate();
        String subject = (String)GlobalizationUtil.globalize("cms.ui.workflow.email.subject." + operation, g11nArgs).localize();
        String body = (String)GlobalizationUtil.globalize("cms.ui.workflow.email.body." + operation, g11nArgs).localize();
        Message msg = new Message(sender, subject, body);
        msg.save();
        return msg;
    }

    public Object clone() {
        CMSTask taskClone = new CMSTask();
        this.copyAttributes(taskClone);
        return taskClone;
    }

    protected void copyAttributes(CMSTask task) {
        super.copyAttributes((UserTask)task);
        task.setTaskType(this.getTaskType());
    }

    public ContentSection getContentSection() {
        ContentItem item = this.getItem();
        if (item != null) {
            return item.getContentSection();
        }
        return null;
    }

    protected void sendUnfinishedNotification() {
        Party sender = this.getNotificationSender();
        if (sender != null) {
            Message msg = this.generateMessage(UNFINISHED_OP, sender);
            this.sendMessageToAssignees(msg);
        }
    }

    public static void addAlert(ContentSection section, String typeLabel, String operation) {
        HashSet<String> operationSet;
        if (section == null || typeLabel == null || operation == null) {
            return;
        }
        typeLabel = typeLabel.trim();
        operation = operation.trim();
        HashMap<String, HashSet<String>> typeMap = (HashMap<String, HashSet<String>>)s_alerts.get(section.getID());
        if (typeMap == null) {
            typeMap = new HashMap<String, HashSet<String>>(5);
            s_alerts.put(section.getID(), typeMap);
        }
        if ((operationSet = (HashSet<String>)typeMap.get(typeLabel)) == null) {
            operationSet = new HashSet<String>(5);
            typeMap.put(typeLabel, operationSet);
        }
        operationSet.add(operation);
        s_log.info((Object)("Added alert for \"" + operation + "\" of " + typeLabel + " task in section \"" + section.getName() + "\""));
    }

    protected static boolean shouldSendAlert(ContentSection section, String typeLabel, String operation) {
        if (section == null || typeLabel == null || operation == null) {
            return false;
        }
        typeLabel = typeLabel.trim();
        operation = operation.trim();
        boolean send = false;
        Map typeMap = (Map)s_alerts.get(section.getID());
        Set operationSet = null;
        if (typeMap != null) {
            operationSet = (Set)typeMap.get(typeLabel);
        }
        if (operationSet != null) {
            send = operationSet.contains(operation);
        }
        s_log.debug((Object)("Send email for operation " + operation + " of task " + typeLabel + "?: " + send));
        return send;
    }

    protected boolean sendAlerts(String operation) {
        return super.sendAlerts(operation) && CMSTask.shouldSendAlert(this.getContentSection(), this.getLabel(), operation);
    }

    protected void sendMessageToAssignees(Message msg) {
        UserCollection uc = null;
        uc = new UserCollection((DataCollection)this.getAssignedUserAssociation().cursor());
        s_log.debug((Object)"spamming users...");
        this.filterUsersAndSendMessage(uc, msg);
        Iterator itr = this.getAssignedGroups();
        s_log.debug((Object)"spamming groups...");
        Group tmpGroup = null;
        while (itr.hasNext()) {
            tmpGroup = (Group)itr.next();
            uc = tmpGroup.getAllMemberUsers();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("group " + tmpGroup + " has " + uc.size() + " user members"));
            }
            this.filterUsersAndSendMessage(uc, msg);
        }
    }

    protected void filterUsersAndSendMessage(UserCollection uc, Message msg) {
        BigDecimal type = this.getTaskType();
        PrivilegeDescriptor pd = type.equals(DEPLOY) ? PrivilegeDescriptor.get((String)"cms_publish") : PrivilegeDescriptor.get((String)"cms_edit_item");
        Filter pFilter = PermissionService.getObjectFilterQuery((FilterFactory)uc.getFilterFactory(), (String)"id", (PrivilegeDescriptor)pd, (OID)this.getItem().getOID());
        uc.addFilter(pFilter);
        Notification notification = null;
        while (uc.next()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("spamming user " + uc.getUser()));
            }
            notification = new Notification((Party)uc.getUser(), msg);
            notification.save();
        }
    }

    public void finish() throws TaskException {
        super.finish();
        BigDecimal type = this.getTaskType();
        ContentItem item = this.getItem();
        if (type.equals(AUTHOR)) {
            item.applyTag("Authored");
        } else if (type.equals(EDIT)) {
            item.applyTag("Edited");
        } else if (type.equals(DEPLOY)) {
            item.applyTag("Deployed");
        } else {
            throw new IllegalStateException("unknown task type: " + type);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

