/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.util;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.util.Assert;
import com.arsdigita.util.Pair;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class LanguageUtil {
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$util$LanguageUtil == null ? (class$com$arsdigita$cms$util$LanguageUtil = LanguageUtil.class$("com.arsdigita.cms.util.LanguageUtil")) : class$com$arsdigita$cms$util$LanguageUtil));
    private static String s_languages = null;
    private static String[] s_languagesArray = null;
    private static final String ISO639_2LA_3LA = "com.arsdigita.cms.util.iso639rev";
    private static ResourceBundle s_lang3LA = ResourceBundle.getBundle("com.arsdigita.cms.util.iso639rev");
    private static final String ISO639_2LA_FULL = "com.arsdigita.cms.util.iso639full";
    private static ResourceBundle s_langFull = ResourceBundle.getBundle("com.arsdigita.cms.util.iso639full");
    static /* synthetic */ Class class$com$arsdigita$cms$util$LanguageUtil;

    public static GlobalizedMessage globalize(String key) {
        return new GlobalizedMessage(key, ISO639_2LA_FULL);
    }

    public static void setSupportedLanguages(String languages) {
        s_languages = languages;
    }

    public static String getSupportedLanguages() {
        Assert.assertNotNull((Object)s_languages, (String)"supported languages not set");
        return s_languages;
    }

    public static Collection getSupportedLanguages2LA() {
        String allLanguages = LanguageUtil.getSupportedLanguages();
        StringTokenizer tokenizer = new StringTokenizer(allLanguages, ",");
        LinkedList<String> langList = new LinkedList<String>();
        while (tokenizer.hasMoreElements()) {
            String language = tokenizer.nextToken();
            langList.add(language);
        }
        return langList;
    }

    public static Collection getSupportedLanguages3LA() {
        String allLanguages = LanguageUtil.getSupportedLanguages();
        StringTokenizer tokenizer = new StringTokenizer(allLanguages, ",");
        LinkedList<Pair> langList = new LinkedList<Pair>();
        while (tokenizer.hasMoreElements()) {
            String language = tokenizer.nextToken();
            langList.add(new Pair((Object)language, (Object)LanguageUtil.getLang3LA(language)));
        }
        return langList;
    }

    public static Collection getSupportedLanguagesFull() {
        String allLanguages = LanguageUtil.getSupportedLanguages();
        StringTokenizer tokenizer = new StringTokenizer(allLanguages, ",");
        LinkedList<Pair> langList = new LinkedList<Pair>();
        while (tokenizer.hasMoreElements()) {
            String language = tokenizer.nextToken();
            langList.add(new Pair((Object)language, (Object)LanguageUtil.getLangFull(language)));
        }
        return langList;
    }

    public static Collection getCreatableLanguages(ContentPage item) {
        ContentBundle bundle = item.getContentBundle();
        Collection allList = LanguageUtil.getSupportedLanguages2LA();
        allList.removeAll(bundle.getLanguages());
        return allList;
    }

    public static String getLang3LA(String lang) {
        String threeLA;
        try {
            threeLA = s_lang3LA.getString(lang);
        }
        catch (MissingResourceException mexc) {
            s_log.warn((Object)("Three letter language code for key '" + lang + "' not found: " + mexc));
            threeLA = lang.trim();
        }
        return threeLA;
    }

    public static String getLangFull(String lang) {
        String fullName;
        try {
            fullName = s_langFull.getString(lang);
        }
        catch (MissingResourceException mexc) {
            s_log.warn((Object)("Full  language name for key '" + lang + "' not found " + mexc));
            fullName = lang;
        }
        return fullName;
    }

    public static Collection convertTo3LA(Collection list) {
        LinkedList<Pair> conList = new LinkedList<Pair>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String lang2Code = (String)iter.next();
            conList.add(new Pair((Object)lang2Code, (Object)LanguageUtil.getLang3LA(lang2Code)));
        }
        return conList;
    }

    public static Collection convertToFull(Collection list) {
        LinkedList<Pair> conList = new LinkedList<Pair>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String lang2Code = (String)iter.next();
            conList.add(new Pair((Object)lang2Code, (Object)LanguageUtil.getLangFull(lang2Code)));
        }
        return conList;
    }

    public static Collection convertToG11N(Collection list) {
        LinkedList<Pair> conList = new LinkedList<Pair>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String lang2Code = (String)iter.next();
            conList.add(new Pair((Object)lang2Code, (Object)LanguageUtil.globalize(lang2Code)));
        }
        return conList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

