/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.workflow;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ui.UserAddForm;
import com.arsdigita.cms.ui.UserSearchForm;
import com.arsdigita.cms.ui.workflow.TaskRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class TaskAddUser
extends SimpleContainer {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/workflow/TaskAddUser.java#7 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$workflow$TaskAddUser == null ? (class$com$arsdigita$cms$ui$workflow$TaskAddUser = TaskAddUser.class$("com.arsdigita.cms.ui.workflow.TaskAddUser")) : class$com$arsdigita$cms$ui$workflow$TaskAddUser));
    private final TaskRequestLocal m_task;
    private SearchForm m_search;
    private AddForm m_add;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$workflow$TaskAddUser;

    public TaskAddUser(TaskRequestLocal task) {
        this.m_task = task;
        this.m_search = new SearchForm();
        this.add((Component)this.m_search);
        this.m_add = new AddForm();
        this.add((Component)this.m_add);
    }

    UserSearchForm getSearchForm() {
        return this.m_search;
    }

    UserAddForm getAddForm() {
        return this.m_add;
    }

    public final void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            FormData one = this.m_search.getFormData(state);
            FormData two = this.m_add.getForm().getFormData(state);
            if (one != null && (one.isSubmission() || two.isSubmission())) {
                this.m_search.generateXML(state, parent);
                this.m_add.generateXML(state, parent);
            } else {
                this.m_search.generateXML(state, parent);
            }
        }
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)TaskAddUser.gz(key).localize();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ GlobalizedMessage access$000(String x0) {
        return TaskAddUser.gz(x0);
    }

    private class AddForm
    extends UserAddForm {
        public AddForm() {
            super((Widget)TaskAddUser.this.m_search.getSearchWidget());
        }

        protected final DataQuery makeQuery(PageState state) {
            Session session = SessionManager.getSession();
            DataQuery query = session.retrieveQuery("com.arsdigita.cms.workflow.searchToAddMembers");
            String search = (String)this.getSearchWidget().getValue(state);
            this.makeFilter(query, search);
            query.addOrder("lastName, firstName, email");
            OID oid = CMS.getContext().getContentSection().getOID();
            PermissionService.objectFilterQuery((DataQuery)query, (String)"userId", (PrivilegeDescriptor)PrivilegeDescriptor.READ, (OID)oid);
            return query;
        }

        private void makeFilter(DataQuery query, String search) {
            query.clearFilter();
            Filter filter = query.addFilter("upper(firstName || lastName || email) like '%' || upper(:search) || '%'");
            filter.set("search", (Object)search);
        }

        public final void process(FormSectionEvent e) throws FormProcessException {
            FormData data = e.getFormData();
            PageState state = e.getPageState();
            String[] users = (String[])data.get((Object)"users");
            if (users == null) {
                throw new FormProcessException(TaskAddUser.lz("cms.ui.workflow.no_users_were_selected"));
            }
            CMSTask task = TaskAddUser.this.m_task.getTask(state);
            for (int i = 0; i < users.length; ++i) {
                User user = User.retrieve((BigDecimal)new BigDecimal(users[i]));
                task.assignUser(user);
            }
            task.save();
        }
    }

    private static class SearchForm
    extends UserSearchForm {
        private final Submit m_cancel = new Submit("cancel", TaskAddUser.access$000("cms.ui.cancel"));

        public SearchForm() {
            super("user-search");
            this.add((Component)this.m_cancel);
        }
    }
}

