/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.type;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeLifecycleDefinition;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.lifecycle.LifecycleDefinition;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.toolbox.ui.PropertyList;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.util.List;

class ContentTypePropertyList
extends PropertyList {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/type/ContentTypePropertyList.java#8 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private final ContentTypeRequestLocal m_type;

    public ContentTypePropertyList(ContentTypeRequestLocal type) {
        this.m_type = type;
    }

    protected final List properties(PageState state) {
        List props = super.properties(state);
        ContentType type = this.m_type.getContentType(state);
        ContentSection section = CMS.getContext().getContentSection();
        props.add(new PropertyList.Property(ContentTypePropertyList.gz("cms.ui.name"), type.getLabel()));
        props.add(new PropertyList.Property(ContentTypePropertyList.gz("cms.ui.description"), type.getDescription()));
        props.add(new PropertyList.Property(ContentTypePropertyList.gz("cms.ui.type.parent"), this.getParent(type)));
        props.add(new PropertyList.Property(ContentTypePropertyList.gz("cms.ui.type.lifecycle"), this.getLifecycle(section, type)));
        props.add(new PropertyList.Property(ContentTypePropertyList.gz("cms.ui.type.workflow"), this.getWorkflow(section, type)));
        return props;
    }

    private String getParent(ContentType type) {
        ObjectType ot = MetadataRoot.getMetadataRoot().getObjectType(type.getAssociatedObjectType());
        ObjectType parent = ot.getSupertype();
        if (parent == null) {
            return ContentTypePropertyList.lz("cms.ui.type.parent.none");
        }
        try {
            return ContentType.findByAssociatedObjectType(parent.getQualifiedName()).getLabel();
        }
        catch (DataObjectNotFoundException donfe) {
            return parent.getName();
        }
    }

    private String getLifecycle(ContentSection section, ContentType type) {
        LifecycleDefinition cycle = ContentTypeLifecycleDefinition.getLifecycleDefinition(section, type);
        if (cycle == null) {
            return ContentTypePropertyList.lz("cms.ui.type.lifecycle.none");
        }
        return cycle.getLabel();
    }

    private String getWorkflow(ContentSection section, ContentType type) {
        WorkflowTemplate template = ContentTypeWorkflowTemplate.getWorkflowTemplate(section, type);
        if (template == null) {
            return ContentTypePropertyList.lz("cms.ui.type.workflow.none");
        }
        return template.getLabel();
    }

    private static GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    private static String lz(String key) {
        return (String)ContentTypePropertyList.gz(key).localize();
    }
}

