/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.templates;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.SectionTemplateMapping;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateManagerFactory;
import com.arsdigita.cms.ui.SecurityPropertyEditor;
import com.arsdigita.cms.ui.templates.ItemTemplatesListing;
import com.arsdigita.cms.ui.templates.TemplatesListing;
import com.arsdigita.cms.ui.workflow.WorkflowLockedComponentAccess;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.util.Assert;

public class ItemTemplates
extends SecurityPropertyEditor {
    private ItemSelectionModel m_itemModel;
    public static final String ASSIGN_TEMPLATE = "assignTemplate";

    public ItemTemplates(ItemSelectionModel model) {
        this.m_itemModel = model;
        ItemTemplatesListingImpl l = new ItemTemplatesListingImpl(model);
        LayoutPanel layout = new LayoutPanel();
        this.setDisplayComponent((Component)layout);
        SegmentedPanel st = new SegmentedPanel();
        layout.setBody((Component)st);
        st.addSegment((Component)new Label(GlobalizationUtil.globalize("cms.ui.templates.assigned_templates")), (Component)l);
        SegmentedPanel sa = new SegmentedPanel();
        Label assignLabel = new Label(GlobalizationUtil.globalize("cms.ui.templates.dummy"));
        assignLabel.addPrintListener(new PrintListener(){

            public void prepare(PrintEvent e) {
                PageState s = e.getPageState();
                Label targetLabel = (Label)e.getTarget();
                ContentPage item = (ContentPage)ItemTemplates.this.m_itemModel.getSelectedItem(s);
                Assert.assertNotNull((Object)item, (String)"item");
                targetLabel.setLabel((String)GlobalizationUtil.globalize("cms.ui.templates.assign_a_template_to").localize() + item.getTitle());
            }
        });
        sa.addSegment((Component)assignLabel, (Component)new AvailableTemplatesListing(l.getRowSelectionModel()));
        this.addComponent(ASSIGN_TEMPLATE, (Component)sa);
    }

    protected class AvailableTemplatesListing
    extends TemplatesListing {
        TableColumn m_assignCol;
        SingleSelectionModel m_contextModel;

        public AvailableTemplatesListing(SingleSelectionModel contextModel) {
            this.m_contextModel = contextModel;
            this.m_assignCol = this.addColumn("Assign", "template", false, new AssignCellRenderer());
            this.addTableActionListener((TableActionListener)new TableActionAdapter(this){
                private final /* synthetic */ AvailableTemplatesListing this$1;
                {
                    this.this$1 = this$1;
                }

                public void cellSelected(TableActionEvent e) {
                    PageState s = e.getPageState();
                    TemplatesListing l = (TemplatesListing)((Object)e.getSource());
                    int i = e.getColumn();
                    TableColumn c = l.getColumnModel().get(i);
                    if (c == this.this$1.m_assignCol) {
                        SectionTemplateMapping m = (SectionTemplateMapping)this.this$1.getMappingModel().getSelectedObject(s);
                        this.this$1.assignTemplate(s, m.getTemplate());
                    }
                }
            });
        }

        protected TemplateCollection getTemplateCollection(PageState s) {
            ContentSection sec = CMS.getContext().getContentSection();
            ContentItem item = ItemTemplates.this.m_itemModel.getSelectedItem(s);
            Assert.assertNotNull((Object)item, (String)"item");
            ContentType type = item.getContentType();
            Assert.assertNotNull((Object)((Object)type), (String)"content type");
            MimeType mimeType = this.getMimeType(s);
            TemplateCollection c = TemplateManagerFactory.getInstance().getTemplates(sec, type);
            if (mimeType != null) {
                c.addEqualsFilter("template.mimeType.mimeType", mimeType.getMimeType());
            }
            c.addEqualsFilter("useContext", this.getUseContext(s));
            return c;
        }

        protected String getUseContext(PageState s) {
            String c = (String)this.m_contextModel.getSelectedKey(s);
            Assert.assertNotNull((Object)c, (String)"use context");
            return ItemTemplatesListing.getUseContextFromKey(c);
        }

        protected MimeType getMimeType(PageState s) {
            String key = (String)this.m_contextModel.getSelectedKey(s);
            return ItemTemplatesListing.getMimeTypeFromKey(key);
        }

        public void assignTemplate(PageState s, Template t) {
            ContentItem item = ItemTemplates.this.m_itemModel.getSelectedItem(s);
            Assert.assertNotNull((Object)item, (String)"item");
            TemplateManagerFactory.getInstance().addTemplate(item, t, this.getUseContext(s));
            ItemTemplates.this.showDisplayPane(s);
        }

        protected class AssignCellRenderer
        implements TableCellRenderer {
            private ControlLink m_link = new ControlLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.templates.assign_this_template")));

            public AssignCellRenderer() {
                this.m_link.setClassAttr("assignTemplateLink");
            }

            public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
                return this.m_link;
            }
        }
    }

    protected class ItemTemplatesListingImpl
    extends ItemTemplatesListing {
        private WorkflowLockedComponentAccess m_access;

        public ItemTemplatesListingImpl(ItemSelectionModel model) {
            super(model);
            this.m_access = new WorkflowLockedComponentAccess(null, model);
        }

        public void assignLinkClicked(PageState s, ContentItem item, String useContext) {
            ItemTemplates.this.showComponent(s, ItemTemplates.ASSIGN_TEMPLATE);
        }

        public void register(Page p) {
            super.register(p);
            p.addActionListener(new ActionListener(this){
                private final /* synthetic */ ItemTemplatesListingImpl this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    PageState state = e.getPageState();
                    if (state.isVisibleOnPage((Component)ItemTemplatesListingImpl.access$100(this.this$1))) {
                        if (ItemTemplatesListingImpl.access$200(this.this$1).canAccess(state, CMS.getContext().getSecurityManager())) {
                            this.this$1.getRemoveColumn().setVisible(state, true);
                            this.this$1.getAssignColumn().setVisible(state, true);
                        } else {
                            this.this$1.getRemoveColumn().setVisible(state, false);
                            this.this$1.getAssignColumn().setVisible(state, false);
                        }
                    }
                }
            });
        }

        static /* synthetic */ ItemTemplates access$100(ItemTemplatesListingImpl x0) {
            return x0.ItemTemplates.this;
        }

        static /* synthetic */ WorkflowLockedComponentAccess access$200(ItemTemplatesListingImpl x0) {
            return x0.m_access;
        }
    }
}

