/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.role;

import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.form.Widget;
import com.arsdigita.cms.ui.FormSecurityListener;
import com.arsdigita.cms.ui.UserAddForm;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.Role;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;

class RoleAdminAddForm
extends UserAddForm {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/role/RoleAdminAddForm.java#7 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private final SingleSelectionModel m_roles;
    private static final String NAME_FILTER = "(upper(lastName) like ('%' || upper(:search) || '%')) or (upper(firstName) like ('%' || upper(:search) || '%')) or (upper(email) like ('%' || upper(:search) || '%'))";

    public RoleAdminAddForm(SingleSelectionModel roles, TextField search) {
        super((Widget)search, "RoleAddAdmin");
        this.m_roles = roles;
        this.getForm().addSubmissionListener((FormSubmissionListener)new FormSecurityListener("staff_admin"));
    }

    protected DataQuery makeQuery(PageState s) {
        Assert.truth((boolean)this.m_roles.isSelected(s));
        Session session = SessionManager.getSession();
        DataQuery dq = session.retrieveQuery("com.arsdigita.cms.roleAdminUserSearch");
        BigDecimal roleId = new BigDecimal((String)this.m_roles.getSelectedKey(s));
        String searchQuery = (String)this.getSearchWidget().getValue(s);
        this.makeFilter(dq, roleId, searchQuery);
        dq.addOrder("upper(lastName), upper(firstName), upper(email)");
        return dq;
    }

    private void makeFilter(DataQuery dq, BigDecimal roleId, String search) {
        dq.setParameter("excludedRoleId", (Object)roleId);
        if (search != null) {
            dq.clearFilter();
            Filter filter = dq.addFilter(NAME_FILTER);
            filter.set("search", (Object)search);
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        Assert.truth((boolean)this.m_roles.isSelected(state));
        String[] users = (String[])data.get((Object)"users");
        if (users != null) {
            BigDecimal roleId = new BigDecimal((String)this.m_roles.getSelectedKey(state));
            Role role = null;
            try {
                role = new Role(roleId);
            }
            catch (DataObjectNotFoundException e) {
                e.printStackTrace();
                throw new FormProcessException(e.getMessage());
            }
            Group group = role.getGroup();
            try {
                for (int i = 0; i < users.length; ++i) {
                    User user = User.retrieve((BigDecimal)new BigDecimal(users[i]));
                    PermissionDescriptor perm = new PermissionDescriptor(PrivilegeDescriptor.ADMIN, (ACSObject)group, (Party)user);
                    if (PermissionService.checkPermission((PermissionDescriptor)perm)) continue;
                    PermissionService.grantPermission((PermissionDescriptor)perm);
                }
                role.save();
            }
            catch (DataObjectNotFoundException e) {
                throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.staff.cannot_add_user").localize(), (Throwable)e);
            }
        }
        throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.staff.no_users_were_selected").localize());
        this.fireCompletionEvent(state);
    }
}

