/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.item;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.ControlLink;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.bebop.event.TableActionAdapter;
import com.arsdigita.bebop.event.TableActionEvent;
import com.arsdigita.bebop.event.TableActionListener;
import com.arsdigita.bebop.table.TableCellRenderer;
import com.arsdigita.bebop.table.TableColumn;
import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ui.ContentItemPage;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.util.LanguageUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.toolbox.ui.DataQueryBuilder;
import com.arsdigita.toolbox.ui.DataTable;
import com.arsdigita.util.LockableImpl;
import java.math.BigDecimal;

public class ItemLanguagesTable
extends DataTable {
    private ItemSelectionModel m_model;
    private TableColumn m_deleteColumn;

    public ItemLanguagesTable(ItemSelectionModel model) {
        super((DataQueryBuilder)new LanguagesBuilder(model));
        this.m_model = model;
        this.addColumn("cms.ui.language.header", "language", false, new LanguageRenderer());
        this.addColumn("cms.title", "title");
        this.m_deleteColumn = this.addColumn("cms.ui.action", new ActionCellRenderer(this.m_model));
        this.setResourceBundle("com.arsdigita.cms.ui.CMSResources");
        this.addTableActionListener((TableActionListener)new InstanceDeleter());
    }

    private class InstanceDeleter
    extends TableActionAdapter {
        private InstanceDeleter() {
        }

        public void cellSelected(TableActionEvent e) {
            int col = e.getColumn();
            if (ItemLanguagesTable.this.m_deleteColumn != ItemLanguagesTable.this.getColumn(col)) {
                return;
            }
            PageState s = e.getPageState();
            BigDecimal id = new BigDecimal(e.getRowKey().toString());
            OID oid = new OID("com.arsdigita.cms.ContentPage", (Object)id);
            try {
                ContentPage item = (ContentPage)DomainObjectFactory.newInstance((OID)oid);
                ContentBundle bundle = item.getContentBundle();
                bundle.removeInstance(item);
                item.delete();
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
            ((Table)e.getSource()).clearSelection(s);
        }
    }

    private static class ActionCellRenderer
    implements TableCellRenderer {
        private static Label s_noAction = new Label("&nbsp;", false);
        private static Label s_primary;
        private static ControlLink s_link;
        private ItemSelectionModel m_model;

        public ActionCellRenderer(ItemSelectionModel model) {
            this.m_model = model;
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            if (this.m_model.getSelectedKey(state).equals(key)) {
                return s_noAction;
            }
            BigDecimal id = new BigDecimal(key.toString());
            OID oid = new OID("com.arsdigita.cms.ContentPage", (Object)id);
            try {
                ContentPage item = (ContentPage)DomainObjectFactory.newInstance((OID)oid);
                if (item.getLanguage().equals(item.getContentBundle().getDefaultLanguage())) {
                    return s_primary;
                }
            }
            catch (DataObjectNotFoundException ex) {
                return s_noAction;
            }
            return s_link;
        }

        static {
            s_noAction.lock();
            s_primary = new Label(GlobalizationUtil.globalize("cms.ui.primary_instance"), false);
            s_primary.lock();
            s_link = new ControlLink((Component)new Label(GlobalizationUtil.globalize("cms.ui.delete")));
            s_link.setConfirmation("Permanently delete this item?");
        }
    }

    private static class LanguageRenderer
    implements TableCellRenderer {
        private LanguageRenderer() {
        }

        public Component getComponent(Table table, PageState state, Object value, boolean isSelected, Object key, int row, int column) {
            BigDecimal id = (BigDecimal)key;
            String target = ContentItemPage.getRelativeItemURL(id, ContentItemPage.AUTHORING_TAB);
            GlobalizedMessage fullName = LanguageUtil.globalize((String)value);
            return new Link((Component)new Label(fullName), target);
        }
    }

    private static class LanguagesBuilder
    extends LockableImpl
    implements DataQueryBuilder {
        ItemSelectionModel m_model;

        public LanguagesBuilder(ItemSelectionModel model) {
            this.m_model = model;
        }

        public DataQuery makeDataQuery(DataTable t, PageState s) {
            ContentPage multiLingual = (ContentPage)this.m_model.getSelectedObject(s);
            DataQuery q = SessionManager.getSession().retrieveQuery("com.arsdigita.cms.getBundledItems");
            q.setParameter("bundleID", (Object)multiLingual.getContentBundle().getID());
            return q;
        }

        public String getKeyColumn() {
            return "id";
        }
    }
}

