/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoringkit;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SaveCancelSection;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.form.Hidden;
import com.arsdigita.bebop.form.TextField;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.cms.ui.type.ContentTypeRequestLocal;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;

public class EditKit
extends Form
implements FormProcessListener,
FormInitListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoringkit/EditKit.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    protected final ContentTypeRequestLocal m_type;
    protected Hidden m_id;
    protected TextField m_createComponent;
    protected SaveCancelSection m_saveCancelSection;

    public EditKit(ContentTypeRequestLocal type) {
        super("AuthoringKit");
        this.m_type = type;
        this.m_id = new Hidden((ParameterModel)new BigDecimalParameter("id"));
        this.add((Component)this.m_id);
        this.m_id.addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoringkit.createcomponent")));
        this.m_createComponent = new TextField((ParameterModel)new StringParameter("createComponent"));
        this.m_createComponent.setSize(40);
        this.m_createComponent.setMaxLength(200);
        this.add((Component)this.m_createComponent);
        this.m_saveCancelSection = new SaveCancelSection();
        this.add((Component)this.m_saveCancelSection, 66);
        this.addProcessListener(this);
        this.addInitListener(this);
        this.addSubmissionListener(new FormSubmissionListener(){

            public void submitted(FormSectionEvent event) throws FormProcessException {
                PageState state = event.getPageState();
                if (EditKit.this.isCancelled(state)) {
                    throw new FormProcessException((String)GlobalizationUtil.globalize("cms.ui.cancel_hit").localize());
                }
            }
        });
    }

    public boolean isCancelled(PageState state) {
        return this.m_saveCancelSection.getCancelButton().isSelected(state);
    }

    public void process(FormSectionEvent e) throws FormProcessException {
        AuthoringKit kit;
        PageState state = e.getPageState();
        FormData data = e.getFormData();
        BigDecimal key = (BigDecimal)data.get((Object)this.m_id.getName());
        String createComponent = (String)data.get((Object)this.m_createComponent.getName());
        try {
            kit = new AuthoringKit(key);
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException((String)GlobalizationUtil.globalize("cms.ui.authoringkit.content_type_id").localize() + key.toString() + " not found", (Throwable)ex);
        }
        kit.setCreateComponent(createComponent);
        kit.save();
        Utilities.refreshItemUI(state);
    }

    public void init(FormSectionEvent e) {
        FormData data = e.getFormData();
        PageState state = e.getPageState();
        AuthoringKit kit = this.getKit(state);
        BigDecimal id = kit.getID();
        String createComponent = kit.getCreateComponent();
        data.put((Object)this.m_id.getName(), (Object)id);
        data.put((Object)this.m_createComponent.getName(), (Object)createComponent);
    }

    protected AuthoringKit getKit(PageState state) {
        ContentType type = this.m_type.getContentType(state);
        try {
            return type.getAuthoringKit();
        }
        catch (DataObjectNotFoundException ex) {
            throw new UncheckedWrapperException("Authoring kit not found", (Throwable)ex);
        }
    }
}

