/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.ReusableImageAsset;
import com.arsdigita.cms.ui.FileUploadSection;
import com.arsdigita.cms.ui.authoring.ArticleImage;
import com.arsdigita.cms.ui.authoring.BasicImageForm;
import java.io.File;
import org.apache.log4j.Logger;

public class ImageUploadForm
extends BasicImageForm
implements FormSubmissionListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/authoring/ImageUploadForm.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$ImageUploadForm == null ? (class$com$arsdigita$cms$ui$authoring$ImageUploadForm = ImageUploadForm.class$("com.arsdigita.cms.ui.authoring.ImageUploadForm")) : class$com$arsdigita$cms$ui$authoring$ImageUploadForm));
    private FileUploadSection m_fileUploadSection;
    private ArticleImage m_step;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$ImageUploadForm;

    public ImageUploadForm(ItemSelectionModel itemModel, ItemSelectionModel assetModel) {
        this(itemModel, assetModel, null);
    }

    public ImageUploadForm(ItemSelectionModel itemModel, ItemSelectionModel assetModel, ArticleImage articleImage) {
        super("ImageUploadForm", itemModel, assetModel);
        this.setMethod("post");
        this.setEncType("multipart/form-data");
        this.m_step = articleImage;
    }

    public void addWidgets() {
        this.m_fileUploadSection = new FileUploadSection("Image&nbsp;Type:", "image", "image/jpeg");
        this.m_fileUploadSection.getFileUploadWidget().addValidationListener((ParameterListener)new NotNullValidationListener());
        this.add((Component)this.m_fileUploadSection, 128);
        super.addWidgets();
    }

    public void init(FormSectionEvent event) throws FormProcessException {
    }

    public void submitted(FormSectionEvent fse) {
        if (this.m_step != null && this.getSaveCancelSection().getCancelButton().isSelected(fse.getPageState())) {
            this.m_step.cancelStreamlinedCreation(fse.getPageState());
        }
    }

    public void process(FormSectionEvent event) throws FormProcessException {
        s_log.debug((Object)"Uploading Image");
        FormData data = event.getFormData();
        PageState state = event.getPageState();
        Article item = this.getArticle(state);
        ReusableImageAsset a = null;
        try {
            String fileName = this.m_fileUploadSection.getFileName(event);
            String caption = (String)data.get((Object)"caption");
            File file = this.m_fileUploadSection.getFile(event);
            item.clearImages();
            item.save();
            a = new ReusableImageAsset();
            ((ImageAsset)a).loadFromFile(fileName, file, "image/jpeg");
            a.save();
            item.addImage(a, caption);
            item.save();
            this.setImageAsset(state, a);
            s_log.debug((Object)"Image Uploaded");
        }
        catch (Exception e) {
            s_log.error((Object)"Uploading error", (Throwable)e);
            throw new FormProcessException((Throwable)e);
        }
        if (this.m_step != null) {
            this.m_step.maybeForwardToNextStep(event.getPageState());
        }
    }

    public FileUploadSection getFileUploadSection() {
        return this.m_fileUploadSection;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

