/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui.authoring;

import com.arsdigita.bebop.ColumnPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.event.FormInitListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.RadioGroup;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.CMSContext;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ContentTypeWorkflowTemplate;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.ui.authoring.CreationSelector;
import com.arsdigita.cms.ui.workflow.WorkflowsOptionPrintListener;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.cms.workflow.CMSTask;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.Filter;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Web;
import com.arsdigita.workflow.simple.Engine;
import com.arsdigita.workflow.simple.TaskCollection;
import com.arsdigita.workflow.simple.Workflow;
import com.arsdigita.workflow.simple.WorkflowTemplate;
import java.math.BigDecimal;
import java.util.Iterator;
import java.util.TooManyListenersException;
import org.apache.log4j.Logger;

public class ApplyWorkflowFormSection
extends FormSection
implements FormInitListener {
    private RadioGroup m_radio = new RadioGroup((ParameterModel)new BigDecimalParameter("workflowSelect"));
    private CreationSelector m_creationSelector;
    private ContentType m_type;
    private ApplyWorkflowPrintListener m_listener;
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$authoring$ApplyWorkflowFormSection == null ? (class$com$arsdigita$cms$ui$authoring$ApplyWorkflowFormSection = ApplyWorkflowFormSection.class$("com.arsdigita.cms.ui.authoring.ApplyWorkflowFormSection")) : class$com$arsdigita$cms$ui$authoring$ApplyWorkflowFormSection));
    static /* synthetic */ Class class$com$arsdigita$cms$ui$authoring$ApplyWorkflowFormSection;
    static /* synthetic */ Class class$com$arsdigita$workflow$simple$Engine;

    public ApplyWorkflowFormSection() {
        this(null);
    }

    public ApplyWorkflowFormSection(ContentType type) {
        this(type, (Container)new ColumnPanel(2, true));
    }

    public ApplyWorkflowFormSection(ContentType type, Container panel) {
        super(panel);
        this.m_radio.setClassAttr("vertical");
        this.m_type = type;
        this.m_listener = new ApplyWorkflowPrintListener();
        try {
            this.m_radio.addPrintListener((PrintListener)this.m_listener);
        }
        catch (TooManyListenersException t) {
            s_log.error((Object)"Too many listeners", (Throwable)t);
        }
        this.add((Component)new Label(GlobalizationUtil.globalize("cms.ui.authoring.workflow")));
        this.m_radio.addValidationListener((ParameterListener)new NotNullValidationListener(){

            public void validate(ParameterEvent e) {
                PageState state = e.getPageState();
                if (!ApplyWorkflowFormSection.this.isVisible(state)) {
                    return;
                }
                super.validate(e);
            }
        });
        this.add((Component)this.m_radio);
        this.addInitListener(this);
    }

    public void init(FormSectionEvent e) throws FormProcessException {
        PageState state = e.getPageState();
        ContentSection section = this.m_creationSelector.getContentSection(state);
        WorkflowTemplate template = ContentTypeWorkflowTemplate.getWorkflowTemplate(section, this.m_type);
        if (template != null) {
            this.m_radio.setValue(state, (Object)template.getID());
        }
    }

    public void setCreationSelector(CreationSelector creationSelector) {
        this.m_creationSelector = creationSelector;
    }

    public void setContentType(ContentType contentType) {
        this.m_type = contentType;
    }

    public boolean isVisible(PageState state) {
        TaskCollection t;
        boolean result = false;
        if (super.isVisible(state) && this.getSecurityManager(state).canAccess(Web.getContext().getUser(), "apply_alternate_workflows", (ContentItem)this.m_creationSelector.getFolder(state)) && (t = this.m_listener.getCollection(state)).next()) {
            t.close();
            result = true;
        }
        return result;
    }

    public void applyWorkflow(PageState state, ContentItem item) {
        BigDecimal flowID = (BigDecimal)this.m_radio.getValue(state);
        User user = Web.getContext().getUser();
        ContentSection section = this.m_creationSelector.getContentSection(state);
        Folder f = this.m_creationSelector.getFolder(state);
        WorkflowTemplate template = flowID != null && this.getSecurityManager(state).canAccess(user, "apply_alternate_workflows", (ContentItem)f) ? new WorkflowTemplate(flowID) : ContentTypeWorkflowTemplate.getWorkflowTemplate(section, item.getContentType());
        if (template != null) {
            Workflow workflow = template.instantiateNewWorkflow();
            workflow.setObjectID(item.getID());
            workflow.start(user);
            Engine engine = Engine.getInstance();
            Assert.exists((Object)engine, (Class)(class$com$arsdigita$workflow$simple$Engine == null ? (class$com$arsdigita$workflow$simple$Engine = ApplyWorkflowFormSection.class$("com.arsdigita.workflow.simple.Engine")) : class$com$arsdigita$workflow$simple$Engine));
            Iterator iter = engine.getEnabledTasks(user, workflow.getID()).iterator();
            while (iter.hasNext()) {
                CMSTask task = (CMSTask)((Object)iter.next());
                if (task.isLocked()) continue;
                task.lock(user);
            }
        }
    }

    private SecurityManager getSecurityManager(PageState state) {
        CMSContext context = CMS.getContext();
        SecurityManager sm = context.hasSecurityManager() ? CMS.getContext().getSecurityManager() : new SecurityManager(this.m_creationSelector.getContentSection(state));
        return sm;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ApplyWorkflowPrintListener
    extends WorkflowsOptionPrintListener {
        private ApplyWorkflowPrintListener() {
        }

        protected ContentSection getContentSection(PageState state) {
            return ApplyWorkflowFormSection.this.m_creationSelector.getContentSection(state);
        }

        protected TaskCollection getCollection(PageState state) {
            TaskCollection templates = super.getCollection(state);
            Filter f = templates.addInSubqueryFilter("id", "com.arsdigita.cms.getWorkflowTemplateUserFilter");
            f.set("userId", (Object)Web.getContext().getUser().getID());
            return templates;
        }
    }
}

