/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleComponent;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.dispatcher.Utilities;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.util.Assert;
import com.arsdigita.web.URL;
import com.arsdigita.xml.Element;
import java.math.BigDecimal;

public class ImageDisplay
extends SimpleComponent {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ImageDisplay.java#12 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private final ItemSelectionModel m_item;

    public ImageDisplay(ItemSelectionModel m) {
        this.m_item = m;
    }

    public final ItemSelectionModel getImageSelectionModel() {
        return this.m_item;
    }

    public void generateXML(PageState state, Element parent) {
        if (this.isVisible(state)) {
            ImageAsset image = this.getImageAsset(state);
            if (image == null) {
                return;
            }
            Element element = new Element("cms:imageDisplay", "http://www.arsdigita.com/cms/1.0");
            if (image != null) {
                this.generateImagePropertiesXML(image, state, element);
            }
            this.exportAttributes(element);
            parent.addContent(element);
        }
    }

    protected void generateImagePropertiesXML(ImageAsset image, PageState state, Element element) {
        MimeType mimeType;
        BigDecimal height;
        element.addAttribute("name", image.getName());
        element.addAttribute("src", URL.getDispatcherPath() + Utilities.getImageURL(image));
        BigDecimal width = image.getWidth();
        if (width != null) {
            element.addAttribute("width", width.toString());
        }
        if ((height = image.getHeight()) != null) {
            element.addAttribute("height", height.toString());
        }
        if ((mimeType = image.getMimeType()) != null) {
            element.addAttribute("mime_type", mimeType.getLabel());
        }
    }

    protected ImageAsset getImageAsset(PageState state) {
        ImageAsset image = (ImageAsset)this.m_item.getSelectedObject(state);
        Assert.assertNotNull((Object)image, (String)"Image asset");
        return image;
    }
}

