/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.ui;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Container;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.Link;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.TabbedPane;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormValidationListener;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.bebop.parameters.NotNullValidationListener;
import com.arsdigita.bebop.parameters.ParameterModel;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ItemSelectionModel;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.dispatcher.CMSPage;
import com.arsdigita.cms.dispatcher.ItemResolver;
import com.arsdigita.cms.ui.ContentItemContextBar;
import com.arsdigita.cms.ui.GlobalNavigation;
import com.arsdigita.cms.ui.authoring.WizardSelector;
import com.arsdigita.cms.ui.item.ContentItemRequestLocal;
import com.arsdigita.cms.ui.item.ItemLanguages;
import com.arsdigita.cms.ui.item.Summary;
import com.arsdigita.cms.ui.lifecycle.ItemLifecycleAdminPane;
import com.arsdigita.cms.ui.revision.ItemRevisionAdminPane;
import com.arsdigita.cms.ui.templates.ItemTemplates;
import com.arsdigita.cms.ui.workflow.ItemWorkflowAdminPane;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.kernel.ui.ACSObjectSelectionModel;
import com.arsdigita.persistence.OID;
import com.arsdigita.ui.DebugPanel;
import com.arsdigita.util.Assert;
import java.io.IOException;
import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;

public class ContentItemPage
extends CMSPage
implements ActionListener {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ui/ContentItemPage.java#40 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ui$ContentItemPage == null ? (class$com$arsdigita$cms$ui$ContentItemPage = ContentItemPage.class$("com.arsdigita.cms.ui.ContentItemPage")) : class$com$arsdigita$cms$ui$ContentItemPage));
    public static final String SET_TAB = "set_tab";
    public static final String ITEM_ID = "item_id";
    public static final String RETURN_URL = "return_url";
    public static final String STREAMLINED_CREATION = "streamlined_creation";
    public static final String STREAMLINED_CREATION_ACTIVE = "active";
    public static final String STREAMLINED_CREATION_INACTIVE = "active";
    private static int s_tabOrder = 0;
    public static final int SUMMARY_TAB = s_tabOrder++;
    public static final String CONTENT_TYPE = "content_type";
    public static final int AUTHORING_TAB = s_tabOrder++;
    public static final int LANGUAGE_TAB = s_tabOrder++;
    public static final int WORKFLOW_TAB = s_tabOrder++;
    public static final int PUBLISHING_TAB = s_tabOrder++;
    public static final int HISTORY_TAB = s_tabOrder++;
    public static final int TEMPLATES_TAB = s_tabOrder++;
    private final TabbedPane m_tabbedPane;
    private StringParameter m_returnURL;
    private ItemSelectionModel m_itemModel;
    private ACSObjectSelectionModel m_typeModel;
    private ContentItemRequestLocal m_item = new ItemRequestLocal();
    private Summary m_summaryPane;
    private ItemWorkflowAdminPane m_workflowPane;
    private ItemLifecycleAdminPane m_lifecyclePane;
    private WizardSelector m_wizardPane;
    private ItemLanguages m_languagesPane;
    private ItemRevisionAdminPane m_revisionsPane;
    private ItemTemplates m_templatesPane;
    private Link m_previewLink;
    static /* synthetic */ Class class$com$arsdigita$cms$ui$ContentItemPage;
    static /* synthetic */ Class class$com$arsdigita$cms$ContentType;

    public ContentItemPage() {
        super("", (Container)new SimpleContainer());
        this.setClassAttr("cms-admin");
        this.setTitle(new Label((PrintListener)new TitlePrinter()));
        BigDecimalParameter itemId = new BigDecimalParameter(ITEM_ID);
        itemId.addParameterListener((ParameterListener)new NotNullValidationListener(ITEM_ID));
        this.addGlobalStateParam((ParameterModel)itemId);
        this.m_itemModel = new ItemSelectionModel(itemId);
        BigDecimalParameter contentType = new BigDecimalParameter(CONTENT_TYPE);
        this.addGlobalStateParam((ParameterModel)contentType);
        StringParameter streamlinedCreation = new StringParameter(STREAMLINED_CREATION);
        this.addGlobalStateParam((ParameterModel)streamlinedCreation);
        this.m_typeModel = new ACSObjectSelectionModel((class$com$arsdigita$cms$ContentType == null ? (class$com$arsdigita$cms$ContentType = ContentItemPage.class$("com.arsdigita.cms.ContentType")) : class$com$arsdigita$cms$ContentType).getName(), "com.arsdigita.cms.ContentType", contentType);
        this.getStateModel().addValidationListener(new FormValidationListener(){

            public void validate(FormSectionEvent event) throws FormProcessException {
                ContentItemPage.this.validateItemID(event.getPageState());
            }
        });
        this.m_returnURL = new StringParameter(RETURN_URL);
        this.addGlobalStateParam((ParameterModel)this.m_returnURL);
        this.add((Component)new GlobalNavigation());
        this.add((Component)new ContentItemContextBar(this.m_itemModel));
        this.m_summaryPane = new Summary(this.m_itemModel);
        this.m_wizardPane = new WizardSelector(this.m_itemModel, (SingleSelectionModel)this.m_typeModel);
        this.m_languagesPane = new ItemLanguages(this.m_itemModel);
        this.m_workflowPane = new ItemWorkflowAdminPane(itemId);
        this.m_lifecyclePane = new ItemLifecycleAdminPane(this.m_item);
        this.m_revisionsPane = new ItemRevisionAdminPane(this.m_item);
        this.m_templatesPane = new ItemTemplates(this.m_itemModel);
        this.m_tabbedPane = new TabbedPane();
        this.add((Component)this.m_tabbedPane);
        this.m_tabbedPane.setIdAttr("page-body");
        this.m_tabbedPane.addTab((Component)new Label(ContentItemPage.gz("cms.ui.item.summary")), (Component)this.m_summaryPane);
        this.m_tabbedPane.addTab((Component)new Label(ContentItemPage.gz("cms.ui.item.authoring")), (Component)this.m_wizardPane);
        this.m_tabbedPane.addTab((Component)new Label(ContentItemPage.gz("cms.ui.item.languages")), (Component)this.m_languagesPane);
        this.m_tabbedPane.addTab((Component)new Label(ContentItemPage.gz("cms.ui.item.workflow")), (Component)this.m_workflowPane);
        this.m_tabbedPane.addTab((Component)new Label(ContentItemPage.gz("cms.ui.item.lifecycles")), (Component)this.m_lifecyclePane);
        this.m_tabbedPane.addTab((Component)new Label(ContentItemPage.gz("cms.ui.item.history")), (Component)this.m_revisionsPane);
        this.m_tabbedPane.addTab((Component)new Label(ContentItemPage.gz("cms.ui.item.templates")), (Component)this.m_templatesPane);
        this.m_tabbedPane.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                PageState state = e.getPageState();
                Component pane = ContentItemPage.this.m_tabbedPane.getCurrentPane(state);
                if (pane instanceof Resettable) {
                    ((Resettable)pane).reset(state);
                }
            }
        });
        this.m_previewLink = new Link((Component)new Label(ContentItemPage.gz("cms.ui.preview")), new PrintListener(){

            public final void prepare(PrintEvent e) {
                Link link = (Link)e.getTarget();
                link.setTarget(ContentItemPage.this.getPreviewURL(e.getPageState()));
                link.setTargetFrame("_blank");
            }
        });
        this.m_previewLink.setIdAttr("preview_link");
        this.add((Component)this.m_previewLink);
        this.addActionListener(this);
        this.getStateModel().addValidationListener(new FormValidationListener(){

            public void validate(FormSectionEvent e) throws FormProcessException {
                PageState s = e.getPageState();
                FormData data = e.getFormData();
                ContentItem item = ContentItemPage.this.m_item.getContentItem(s);
                if (item != null && "live".equals(item.getVersion())) {
                    String err = "The item " + item.getID() + " is live and cannot be edited.";
                    throw new FormProcessException(err);
                }
            }
        });
        this.add((Component)new DebugPanel());
    }

    protected void validateItemID(PageState state) throws FormProcessException {
        ContentItem item = this.m_item.getContentItem(state);
        if (item == null) {
            throw new FormProcessException("The item_id supplied does not reference a valid ContentItem.");
        }
    }

    public ContentSection getContentSection(HttpServletRequest request) {
        ContentSection section = super.getContentSection(request);
        Assert.assertNotNull((Object)((Object)section));
        return section;
    }

    public ContentItem getContentItem(PageState state) {
        return (ContentItem)this.m_itemModel.getSelectedObject(state);
    }

    public void actionPerformed(ActionEvent event) {
        PageState state = event.getPageState();
        String setTab = state.getRequest().getParameter(SET_TAB);
        ContentItem item = this.m_item.getContentItem(state);
        if (item instanceof Template) {
            this.m_tabbedPane.setTabVisible(state, (Component)this.m_templatesPane, false);
            this.m_tabbedPane.setTabVisible(state, (Component)this.m_workflowPane, false);
            this.m_tabbedPane.setTabVisible(state, (Component)this.m_languagesPane, false);
            this.m_previewLink.setVisible(state, false);
        } else {
            this.m_tabbedPane.setTabVisible(state, (Component)this.m_templatesPane, !ContentSection.getConfig().getHideTemplatesTab());
        }
        if (setTab != null) {
            Integer tab = null;
            try {
                tab = Integer.valueOf(setTab);
            }
            catch (NumberFormatException e) {
                return;
            }
            if (tab < this.m_tabbedPane.size()) {
                this.m_tabbedPane.setSelectedIndex(state, tab.intValue());
            }
        }
    }

    public static String getItemURL(String nodeURL, BigDecimal itemId, int tab) {
        return ContentItemPage.getItemURL(nodeURL, itemId, tab, false);
    }

    public static String getItemURL(String nodeURL, BigDecimal itemId, int tab, boolean streamlinedCreation) {
        StringBuffer url = new StringBuffer();
        url.append(nodeURL).append("admin/item.jsp").append("?").append(ITEM_ID).append("=").append(itemId.toString()).append("&").append(SET_TAB).append("=").append(tab);
        if (streamlinedCreation && ContentSection.getConfig().getUseStreamlinedCreation()) {
            url.append("&").append(STREAMLINED_CREATION).append("=").append("active");
        }
        return url.toString();
    }

    public static String getRelativeItemURL(BigDecimal itemId, int tab) {
        StringBuffer url = new StringBuffer();
        url.append("item.jsp").append("?").append(ITEM_ID).append("=").append(itemId.toString()).append("&").append(SET_TAB).append("=").append(tab);
        return url.toString();
    }

    public static String getItemURL(ContentItem item, int tab) {
        ContentSection section = ContentSection.getContentSection(item);
        if (section == null) {
            return null;
        }
        String nodeURL = section.getPath() + "/";
        return ContentItemPage.getItemURL(nodeURL, item.getID(), tab);
    }

    public static String getItemURL(BigDecimal itemId, int tab) {
        ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)new OID("com.arsdigita.cms.ContentItem", (Object)itemId));
        if (item == null) {
            return null;
        }
        return ContentItemPage.getItemURL(item, tab);
    }

    public void redirectBack(PageState state) {
        try {
            String returnURL = (String)state.getValue((ParameterModel)this.m_returnURL);
            state.getResponse().sendRedirect(returnURL);
        }
        catch (IOException e) {
            s_log.error((Object)"IO Error redirecting back", (Throwable)e);
        }
    }

    private String getPreviewURL(PageState state) {
        ContentItem item = this.m_item.getContentItem(state);
        ContentSection section = this.getContentSection(state);
        ItemResolver itemResolver = section.getItemResolver();
        return itemResolver.generateItemURL(state, item, section, "preview");
    }

    protected static final GlobalizedMessage gz(String key) {
        return GlobalizationUtil.globalize(key);
    }

    protected static final String lz(String key) {
        return (String)ContentItemPage.gz(key).localize();
    }

    public static boolean isStreamlinedCreationActive(PageState state) {
        return ContentSection.getConfig().getUseStreamlinedCreation() && "active".equals(state.getRequest().getParameter(STREAMLINED_CREATION));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TitlePrinter
    implements PrintListener {
        private TitlePrinter() {
        }

        public final void prepare(PrintEvent e) {
            Label label = (Label)e.getTarget();
            ContentItem item = ContentItemPage.this.m_item.getContentItem(e.getPageState());
            label.setLabel(item.getDisplayName());
        }
    }

    private class ItemRequestLocal
    extends ContentItemRequestLocal {
        private ItemRequestLocal() {
        }

        protected final Object initialValue(PageState state) {
            return CMS.getContext().getContentItem();
        }
    }
}

