/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.FileAsset;
import com.arsdigita.cms.TextAsset;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectTraversal;
import com.arsdigita.domain.DomainServiceInterfaceExposer;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.converter.ConversionException;
import com.arsdigita.search.converter.Converter;
import com.arsdigita.search.converter.ConverterRegistry;
import com.arsdigita.util.StringUtils;
import org.apache.log4j.Logger;

public class ContentPageTextContentProvider
implements ContentProvider {
    private ContentPage m_page;
    private String m_context;
    static /* synthetic */ Class class$com$arsdigita$cms$search$ContentPageMetadataProvider;
    static /* synthetic */ Class class$com$arsdigita$cms$search$ContentPageTextContentProvider$TextRenderer;

    public ContentPageTextContentProvider(String context, ContentPage page) {
        this.m_context = context;
        this.m_page = page;
    }

    public String getContext() {
        return this.m_context;
    }

    public ContentType getType() {
        return ContentType.TEXT;
    }

    public byte[] getBytes() {
        TextRenderer renderer = new TextRenderer();
        renderer.walk((DomainObject)this.m_page, (class$com$arsdigita$cms$search$ContentPageMetadataProvider == null ? (class$com$arsdigita$cms$search$ContentPageMetadataProvider = ContentPageTextContentProvider.class$("com.arsdigita.cms.search.ContentPageMetadataProvider")) : class$com$arsdigita$cms$search$ContentPageMetadataProvider).getName());
        String text = renderer.getText();
        return text.getBytes();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class TextRenderer
    extends DomainObjectTraversal {
        private Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$search$ContentPageTextContentProvider$TextRenderer == null ? (class$com$arsdigita$cms$search$ContentPageTextContentProvider$TextRenderer = ContentPageTextContentProvider.class$("com.arsdigita.cms.search.ContentPageTextContentProvider$TextRenderer")) : class$com$arsdigita$cms$search$ContentPageTextContentProvider$TextRenderer));
        private StringBuffer m_text = new StringBuffer("");

        public String getText() {
            return this.m_text.toString();
        }

        protected void beginObject(DomainObject obj, String path) {
        }

        protected void endObject(DomainObject obj, String path) {
        }

        protected void revisitObject(DomainObject obj, String path) {
        }

        protected void handleAttribute(DomainObject obj, String path, Property property) {
            Object value = DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
            if (value != null && property.isRole() && value instanceof DataObject) {
                ObjectType assetType = ((DataObject)value).getOID().getObjectType();
                String assetTypeName = assetType.getQualifiedName();
                if (assetTypeName.equals("com.arsdigita.cms.TextAsset")) {
                    this.appendTextAsset(new TextAsset((DataObject)value));
                } else if (assetTypeName.equals("com.arsdigita.cms.FileAsset")) {
                    FileAsset fa = new FileAsset((DataObject)value);
                    this.appendFileAsset(fa);
                }
            } else if (value != null && !property.isRole()) {
                this.m_text.append(" " + value);
            }
        }

        protected void beginRole(DomainObject obj, String path, Property property) {
        }

        protected void endRole(DomainObject obj, String path, Property property) {
        }

        protected void beginAssociation(DomainObject obj, String path, Property property) {
            block3: {
                DataAssociation association;
                block2: {
                    association = (DataAssociation)DomainServiceInterfaceExposer.get((DomainObject)obj, (String)property.getName());
                    if (association == null || !association.getObjectType().isSubtypeOf("com.arsdigita.cms.FileAsset")) break block2;
                    while (association.next()) {
                        this.appendFileAsset(new FileAsset(association.getDataObject()));
                    }
                    break block3;
                }
                if (association == null || !association.getObjectType().isSubtypeOf("com.arsdigita.cms.TextAsset")) break block3;
                while (association.next()) {
                    this.appendTextAsset(new TextAsset(association.getDataObject()));
                }
            }
        }

        protected void endAssociation(DomainObject obj, String path, Property property) {
        }

        private void appendTextAsset(TextAsset asset) {
            String content = asset.getText();
            if (content != null) {
                this.m_text.append(" " + StringUtils.htmlToText((String)content));
            }
        }

        private void appendFileAsset(FileAsset asset) {
            Converter converter = ConverterRegistry.getConverter((MimeType)asset.getMimeType());
            if (converter != null) {
                try {
                    this.m_text.append(" " + converter.convertDocument(asset.getContent()));
                }
                catch (ConversionException e) {
                    this.s_log.error((Object)("Error converting FileAsset " + asset.getOID() + " with MimeType " + asset.getMimeType()), (Throwable)e);
                }
            } else {
                this.s_log.debug((Object)("Skipping FileAsset " + asset.getOID() + " with MimeType " + asset.getMimeType()));
            }
        }
    }
}

