/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.search;

import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.search.ContentPageAssetExtractor;
import com.arsdigita.cms.search.ContentPageTextContentProvider;
import com.arsdigita.cms.search.ContentPageXMLContentProvider;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.Party;
import com.arsdigita.search.ContentProvider;
import com.arsdigita.search.ContentType;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import org.apache.log4j.Logger;

public class ContentPageMetadataProvider
implements MetadataProvider {
    public static final String ADAPTER_CONTEXT = (class$com$arsdigita$cms$search$ContentPageMetadataProvider == null ? (class$com$arsdigita$cms$search$ContentPageMetadataProvider = ContentPageMetadataProvider.class$("com.arsdigita.cms.search.ContentPageMetadataProvider")) : class$com$arsdigita$cms$search$ContentPageMetadataProvider).getName();
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$search$ContentPageMetadataProvider == null ? (class$com$arsdigita$cms$search$ContentPageMetadataProvider = ContentPageMetadataProvider.class$("com.arsdigita.cms.search.ContentPageMetadataProvider")) : class$com$arsdigita$cms$search$ContentPageMetadataProvider));
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/search/ContentPageMetadataProvider.java#4 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    static /* synthetic */ Class class$com$arsdigita$cms$search$ContentPageMetadataProvider;
    static /* synthetic */ Class class$com$arsdigita$cms$search$ContentPageAssetExtractor;

    public String getTypeSpecificInfo(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        return "live".equals(item.getVersion()) ? "live" : "draft";
    }

    public Locale getLocale(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        String lang = item.getLanguage();
        return lang == null ? null : new Locale(lang, "");
    }

    public String getTitle(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        String title = item.getTitle();
        if (StringUtils.emptyString((String)title)) {
            throw new IllegalArgumentException("ContentPage must have non-blank title!");
        }
        return title;
    }

    public String getSummary(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        return item.getSearchSummary();
    }

    public ContentProvider[] getContent(DomainObject dobj, ContentType type) {
        ArrayList<Object> content = new ArrayList<Object>();
        if (type == ContentType.XML) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Adding XML Content");
            }
            content.add(new ContentPageXMLContentProvider("xml", (ContentPage)dobj));
        } else if (type == ContentType.TEXT) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Adding Text Content");
            }
            content.add(new ContentPageTextContentProvider("text", (ContentPage)dobj));
        } else if (type == ContentType.RAW) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)"Adding Raw Content");
            }
            ContentPageAssetExtractor ex = new ContentPageAssetExtractor();
            ex.walk(dobj, (class$com$arsdigita$cms$search$ContentPageAssetExtractor == null ? (class$com$arsdigita$cms$search$ContentPageAssetExtractor = ContentPageMetadataProvider.class$("com.arsdigita.cms.search.ContentPageAssetExtractor")) : class$com$arsdigita$cms$search$ContentPageAssetExtractor).getName());
            content.addAll(ex.getContent());
        }
        return content.toArray(new ContentProvider[content.size()]);
    }

    public Date getCreationDate(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        return item.getCreationDate();
    }

    public Party getCreationParty(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        return item.getCreationUser();
    }

    public Date getLastModifiedDate(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        return item.getLastModifiedDate();
    }

    public Party getLastModifiedParty(DomainObject dobj) {
        ContentPage item = (ContentPage)dobj;
        return item.getLastModifiedUser();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

