/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.publishToFile.PublishToFileException;
import com.arsdigita.cms.publishToFile.Utilities;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Host;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;
import org.apache.log4j.Logger;

public class QueueEntry
extends DomainObject {
    private static final String SEQUENCE_NAME = "publish_to_file_system_seq";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.publishToFile.QueueEntry";
    public static final String ID = "id";
    public static final String ITEM_ID = "itemId";
    public static final String PARENT_ID = "parentId";
    public static final String ITEM_TYPE = "itemType";
    public static final String TASK = "task";
    public static final String HOST = "host";
    public static final String DESTINATION = "destination";
    public static final String TIME_QUEUED = "timeQueued";
    public static final String TIME_LAST_FAILED = "timeLastFailed";
    public static final String FAIL_COUNT = "failCount";
    public static final String SORT_ORDER = "sortOrder";
    public static final String IN_PROCESS = "inProcess";
    public static final String TASK_PUBLISH = "publish";
    public static final String TASK_UNPUBLISH = "unpublish";
    public static final String TASK_MOVE = "move";
    public static final String TASK_REPUBLISH = "republish";
    public static final String IN_PROCESS_YES = "1";
    public static final String IN_PROCESS_NO = "0";
    private static Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$publishToFile$QueueEntry == null ? (class$com$arsdigita$cms$publishToFile$QueueEntry = QueueEntry.class$("com.arsdigita.cms.publishToFile.QueueEntry")) : class$com$arsdigita$cms$publishToFile$QueueEntry).getName());
    static /* synthetic */ Class class$com$arsdigita$cms$publishToFile$QueueEntry;

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public QueueEntry(DataObject dataObject) {
        super(dataObject);
    }

    protected QueueEntry() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected QueueEntry(String objectType) {
        super(objectType);
    }

    public void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.set(ID, QueueEntry.generateID());
        }
    }

    public static QueueEntry create(ContentItem item, BigDecimal parentId, String task, Host host, String destination) {
        QueueEntry entry = new QueueEntry();
        entry.setItemId(item.getID());
        entry.setItemType(item.getSpecificObjectType());
        entry.setParentId(parentId);
        entry.setTask(task);
        entry.setHost(host);
        entry.setFailCount(new Long(0L));
        entry.setDestination(destination);
        entry.setSortOrder(entry.getID());
        entry.setInProcess(IN_PROCESS_NO);
        entry.setTimeQueued(new Date());
        return entry;
    }

    void requeue() {
        this.setSortOrder(QueueEntry.generateID());
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get(ID);
    }

    private void setItemId(BigDecimal itemId) {
        this.set(ITEM_ID, itemId);
    }

    public BigDecimal getItemId() {
        return (BigDecimal)this.get(ITEM_ID);
    }

    private void setItemType(String itemType) {
        this.set(ITEM_TYPE, itemType);
    }

    public String getItemType() {
        return (String)this.get(ITEM_TYPE);
    }

    public ContentItem getItem() {
        ContentItem result = Utilities.getContentItemOrNull(this.getItemId());
        Assert.assertTrue((TASK_MOVE.equals(this.getTask()) || !(result instanceof ContentBundle) ? 1 : 0) != 0, (String)"The item for a task must not be a ContentBundle");
        return result;
    }

    private void setParentId(BigDecimal parentId) {
        this.set(PARENT_ID, parentId);
    }

    public BigDecimal getParentId() {
        return (BigDecimal)this.get(PARENT_ID);
    }

    public ContentItem getParent() {
        ContentItem result = Utilities.getContentItemOrNull(this.getParentId());
        Assert.assertTrue((result == null || result instanceof ContentBundle ? 1 : 0) != 0);
        return result;
    }

    private void setDestination(String destination) {
        this.set(DESTINATION, destination);
    }

    public String getDestination() {
        return (String)this.get(DESTINATION);
    }

    private void setTask(String task) {
        this.set(TASK, task);
    }

    public String getTask() {
        return (String)this.get(TASK);
    }

    private void setHost(Host host) {
        this.setAssociation(HOST, (DomainObject)host);
    }

    public Host getHost() {
        DataObject obj = (DataObject)this.get(HOST);
        return new Host(obj);
    }

    public boolean isPublishTask() {
        return TASK_PUBLISH.equals(this.getTask());
    }

    public boolean isUnpublishTask() {
        return TASK_UNPUBLISH.equals(this.getTask());
    }

    public boolean isRepublishTask() {
        return TASK_REPUBLISH.equals(this.getTask());
    }

    public boolean isMoveTask() {
        return TASK_MOVE.equals(this.getTask());
    }

    private void setTimeQueued(Date timeQueued) {
        this.set(TIME_QUEUED, timeQueued);
    }

    public Date getTimeQueued() {
        return (Date)this.get(TIME_QUEUED);
    }

    private void setTimeLastFailed(Date timeLastFailed) {
        this.set(TIME_LAST_FAILED, timeLastFailed);
    }

    public Date getTimeLastFailed() {
        return (Date)this.get(TIME_LAST_FAILED);
    }

    private void setFailCount(Long count) {
        this.set(FAIL_COUNT, count);
    }

    public Long getFailCount() {
        return (Long)this.get(FAIL_COUNT);
    }

    private void setSortOrder(BigDecimal sOrder) {
        this.set(SORT_ORDER, sOrder);
    }

    private void setInProcess(String s) {
        this.set(IN_PROCESS, s);
    }

    private String getInProcess() {
        return (String)this.get(IN_PROCESS);
    }

    public String toString() {
        return this.getTask() + " for item " + this.getItemId() + "(parent " + this.getParentId() + ") on host " + this.getHost();
    }

    static BigDecimal generateID() throws PublishToFileException {
        try {
            return Sequences.getNextValue((String)SEQUENCE_NAME);
        }
        catch (SQLException e) {
            throw new PublishToFileException("Failed to generate pfs ID", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

