/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.publishToFile.DestinationStub;
import com.arsdigita.cms.publishToFile.PublishToFile;
import com.arsdigita.cms.publishToFile.QueueEntry;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainCollection;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.web.Host;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

class PublishedFile
extends DomainObject {
    public static final String versionId = "$Id";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.publishToFile.PublishedFile";
    private static final String ID = "id";
    private static final String HOST = "host";
    private static final String ITEM_TYPE = "itemType";
    private static final String ITEM_ID = "itemId";
    private static final String DRAFT_ID = "draftId";
    private static final String FILE_NAME = "fileName";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$publishToFile$PublishedFile == null ? (class$com$arsdigita$cms$publishToFile$PublishedFile = PublishedFile.class$("com.arsdigita.cms.publishToFile.PublishedFile")) : class$com$arsdigita$cms$publishToFile$PublishedFile));
    static /* synthetic */ Class class$com$arsdigita$cms$publishToFile$PublishedFile;

    protected PublishedFile() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    protected PublishedFile(String objectType) {
        super(objectType);
    }

    public PublishedFile(DataObject dataObject) {
        super(dataObject);
    }

    File getFile() {
        File p;
        DestinationStub dest = PublishToFile.getDestination(this.getItemType());
        File f = new File(dest.getFile(), this.getFileName());
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("published file path is " + f.getPath()));
        }
        if (!(p = f.getParentFile()).exists()) {
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Making all directories leading up to & including" + p.getPath()));
            }
            p.mkdirs();
        }
        return f;
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.getFile());
    }

    public void delete() {
        DestinationStub dest = PublishToFile.getDestination(this.getItemType());
        File f = this.getFile();
        f.delete();
        String fileName = this.getFileName();
        Host host = this.getHost();
        super.delete();
        long n = 0L;
        File path = new File(fileName).getParentFile();
        File p = f.getParentFile();
        do {
            Assert.assertTrue((boolean)p.isDirectory());
            DataCollection coll = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
            coll.addEqualsFilter("host.id", (Object)host.getID());
            coll.addFilter("fileName like '" + path.getPath() + "%'");
            n = coll.size();
            if (n == 0L) {
                s_log.debug((Object)("Deleting emptied directory " + path.getPath()));
                File[] files = p.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    s_log.debug((Object)("Deleting " + files[i].getPath()));
                    files[i].delete();
                }
                if (p.compareTo(dest.getFile()) != 0) {
                    s_log.debug((Object)("Deleting " + p.getPath()));
                    p.delete();
                } else {
                    s_log.debug((Object)("NOT Deleting " + p.getPath() + " because it is the doc root"));
                }
            }
            path = path.getParentFile();
            p = p.getParentFile();
        } while (path != null && p != null && n == 0L);
    }

    public static PublishedFile create(ContentItem item, String fileName, Host host) {
        Assert.truth((item != null ? 1 : 0) != 0, (String)"item is not null");
        Assert.truth((boolean)item.isLive(), (String)"item is live");
        Assert.truth((fileName != null ? 1 : 0) != 0, (String)"fileName is not null");
        Assert.truth((host != null ? 1 : 0) != 0, (String)"host is not null");
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("creating published file with item " + item.getOID() + " and fileName " + fileName + " on host " + host));
        }
        PublishedFile file = new PublishedFile();
        file.set(ID, QueueEntry.generateID());
        file.set(ITEM_TYPE, item.getSpecificObjectType());
        file.set(ITEM_ID, item.getID());
        file.set(DRAFT_ID, item.getWorkingVersion().getID());
        file.set(FILE_NAME, fileName);
        file.setAssociation(HOST, (DomainObject)host);
        return file;
    }

    static PublishedFile loadOrCreate(ContentItem item, String fileName, Host host) {
        Assert.truth((item != null ? 1 : 0) != 0, (String)"item is not null");
        Assert.truth((boolean)item.isLive(), (String)"item is live");
        Assert.truth((fileName != null ? 1 : 0) != 0, (String)"fileName is not null");
        Assert.truth((host != null ? 1 : 0) != 0, (String)"host is not null");
        PublishedFile f = PublishedFile.findByFileName(fileName, host);
        if (f == null) {
            f = PublishedFile.create(item, fileName, host);
            f.save();
        }
        Assert.assertEquals((Object)host, (Object)f.getHost());
        Assert.assertEquals((Object)item.getID(), (Object)f.getItemId());
        Assert.assertEquals((Object)item.getWorkingVersion().getID(), (Object)f.getDraftId());
        Assert.assertEquals((Object)fileName, (Object)f.getFileName());
        return f;
    }

    static void deleteAll(BigDecimal id, Host host) {
        DataCollection coll = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        coll.addEqualsFilter("host.id", (Object)host.getID());
        coll.addEqualsFilter(ITEM_ID, (Object)id);
        while (coll.next()) {
            PublishedFile f = new PublishedFile(coll.getDataObject());
            f.delete();
        }
    }

    public static DomainCollection retrieveAll() {
        return PublishedFile.retrieveAll(null);
    }

    public static DomainCollection retrieveAll(Host host) {
        Session session = SessionManager.getSession();
        DataCollection files = session.retrieve(BASE_DATA_OBJECT_TYPE);
        return new DomainCollection(files);
    }

    public static PublishedFile findByFileName(String fileName, Host host) {
        DataCollection coll = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        coll.addEqualsFilter("host.id", (Object)host.getID());
        coll.addEqualsFilter(FILE_NAME, (Object)fileName);
        PublishedFile result = null;
        if (coll.next()) {
            result = new PublishedFile(coll.getDataObject());
        }
        coll.close();
        return result;
    }

    public BigDecimal getItemId() {
        return (BigDecimal)this.get(ITEM_ID);
    }

    public ContentItem getItem() {
        ContentItem item;
        OID oid = new OID(this.getItemType(), (Object)this.getItemId());
        try {
            item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        }
        catch (DataObjectNotFoundException donfe) {
            item = null;
        }
        return item;
    }

    public BigDecimal getDraftId() {
        return (BigDecimal)this.get(DRAFT_ID);
    }

    public ContentItem getDraftItem() {
        OID oid = new OID(this.getItemType(), (Object)this.getDraftId());
        ContentItem item = (ContentItem)DomainObjectFactory.newInstance((OID)oid);
        return item;
    }

    public String getItemType() {
        return (String)this.get(ITEM_TYPE);
    }

    public Host getHost() {
        DataObject obj = (DataObject)this.get(HOST);
        return new Host(obj);
    }

    public String getFileName() {
        return (String)this.get(FILE_NAME);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

