/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.publishToFile;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.publishToFile.Utilities;
import com.arsdigita.util.Assert;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.MatchResult;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternMatcherInput;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

class LinkScanner {
    private static Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$publishToFile$LinkScanner == null ? (class$com$arsdigita$cms$publishToFile$LinkScanner = LinkScanner.class$("com.arsdigita.cms.publishToFile.LinkScanner")) : class$com$arsdigita$cms$publishToFile$LinkScanner).getName());
    private static final int MATCH_MASK = 9;
    private static final String ELEMS_RE = "(a|img|link)";
    private static final String TAG_RE = "\\<\\s*(a|img|link)\\s*([^>]*?)\\s*/?\\>";
    private static final String ATTR_RE = "([a-z][a-z0-9]*)\\s*=\\s*([^\\s'\"]+|'[^']*'|\"[^\"]*\")";
    private static final Pattern TAG_PAT;
    private static final Pattern ATTR_PAT;
    private static final String[] TAGS;
    private static final String[] REF_ATTR;
    private static final String OID_ATTR = "oid";
    private static final String[] NOT_FOUND;
    private String m_content;
    private TagRef[] m_tags;
    static /* synthetic */ Class class$com$arsdigita$cms$publishToFile$LinkScanner;

    public LinkScanner(String html) {
        Assert.assertNotNull((Object)html);
        this.m_content = html;
        this.m_tags = this.parse();
    }

    public void transform(Writer out) throws IOException {
        if (this.m_tags == null || this.m_tags.length == 0) {
            out.write(this.m_content);
            return;
        }
        int i = 0;
        out.write(this.m_content.substring(0, this.m_tags[0].tagStart));
        for (i = 0; i < this.m_tags.length; ++i) {
            TagRef ta = this.m_tags[i];
            if (i > 0) {
                out.write(this.m_content.substring(this.m_tags[i - 1].tagEnd, ta.tagStart));
            }
            ta.replaceReference(out);
        }
        out.write(this.m_content.substring(this.m_tags[this.m_tags.length - 1].tagEnd));
    }

    public int size() {
        return this.m_tags == null ? 0 : this.m_tags.length;
    }

    public ContentItem getTarget(int i) {
        return this.m_tags[i].getItem();
    }

    protected BigDecimal getItemOID(int i) {
        return this.m_tags[i].oid;
    }

    public void setTargetURL(int i, String url) {
        this.m_tags[i].url = url;
    }

    private TagRef[] parse() {
        ArrayList<TagRef> foundTags = new ArrayList<TagRef>();
        PatternMatcherInput body = new PatternMatcherInput(this.m_content);
        PatternMatcherInput tag = new PatternMatcherInput(body.getBuffer());
        Perl5Matcher tagMatcher = new Perl5Matcher();
        Perl5Matcher attrMatcher = new Perl5Matcher();
        while (tagMatcher.contains(body, TAG_PAT)) {
            MatchResult t = tagMatcher.getMatch();
            int tagType = this.getTagType(t.group(1));
            int tagStart = t.beginOffset(2);
            int tagEnd = t.endOffset(2);
            tag.setBeginOffset(tagStart);
            tag.setEndOffset(tagEnd);
            BigDecimal oid = null;
            int linkStart = -1;
            int linkEnd = -1;
            while (attrMatcher.contains(tag, ATTR_PAT)) {
                MatchResult a = attrMatcher.getMatch();
                if (OID_ATTR.equalsIgnoreCase(a.group(1))) {
                    oid = this.extractOID(a.beginOffset(2), a.endOffset(2));
                    continue;
                }
                if (!REF_ATTR[tagType].equalsIgnoreCase(a.group(1))) continue;
                linkStart = a.beginOffset(2);
                linkEnd = a.endOffset(2);
            }
            if (oid == null) continue;
            TagRef ref = new TagRef(tagType, tagStart, tagEnd, linkStart, linkEnd, oid);
            foundTags.add(ref);
        }
        int size = foundTags.size();
        return size > 0 ? foundTags.toArray(new TagRef[size]) : null;
    }

    private BigDecimal extractOID(int begin, int end) {
        String val = null;
        val = this.m_content.charAt(begin) == '\"' || this.m_content.charAt(begin) == '\'' ? this.m_content.substring(begin + 1, end - 1) : this.m_content.substring(begin, end);
        return new BigDecimal(val);
    }

    private int getTagType(String tag) {
        for (int i = 0; i < TAGS.length; ++i) {
            if (!TAGS[i].equalsIgnoreCase(tag)) continue;
            return i;
        }
        throw new IllegalStateException("Tag '" + tag + "' found, but no information registered for it in TAGS. This is a programming error.");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        TAGS = new String[]{"img", "link", "a"};
        REF_ATTR = new String[]{"src", "href", "href"};
        NOT_FOUND = new String[]{"/notfound.jpg", "/notfound.html", "/notfound.html"};
        Perl5Compiler comp = new Perl5Compiler();
        try {
            TAG_PAT = comp.compile(TAG_RE, 9);
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException("Failed to compile \n'\\<\\s*(a|img|link)\\s*([^>]*?)\\s*/?\\>' " + e.getMessage());
        }
        try {
            ATTR_PAT = comp.compile(ATTR_RE, 9);
        }
        catch (MalformedPatternException e) {
            throw new RuntimeException("Failed to compile \n'([a-z][a-z0-9]*)\\s*=\\s*([^\\s'\"]+|'[^']*'|\"[^\"]*\")' " + e.getMessage());
        }
    }

    private class TagRef {
        int tagType;
        int tagStart;
        int tagEnd;
        int linkStart;
        int linkEnd;
        String url;
        BigDecimal oid;
        private ContentItem m_item;

        public TagRef(int type, int start, int end, int lstart, int lend, BigDecimal oid) {
            this.tagType = type;
            this.tagStart = start;
            this.tagEnd = end;
            this.linkStart = lstart;
            this.linkEnd = lend;
            this.oid = oid;
        }

        public void replaceReference(Writer out) throws IOException {
            String target;
            String string = target = this.url == null ? NOT_FOUND[this.tagType] : this.url;
            if (this.linkStart == -1) {
                out.write(LinkScanner.this.m_content.substring(this.tagStart, this.tagEnd));
                out.write(" ");
                out.write(REF_ATTR[this.tagType]);
                out.write("='");
                out.write(target);
                out.write("'");
            } else {
                out.write(LinkScanner.this.m_content.substring(this.tagStart, this.linkStart));
                out.write(39);
                out.write(target);
                out.write("' ");
                if (this.tagEnd > this.linkEnd) {
                    out.write(LinkScanner.this.m_content.substring(this.linkEnd + 1, this.tagEnd));
                }
            }
        }

        public ContentItem getItem() {
            if (this.m_item == null) {
                this.m_item = Utilities.getContentItemOrNull(this.oid);
                if (this.m_item != null) {
                    this.m_item = this.m_item.getLiveVersion();
                }
            }
            return this.m_item;
        }
    }
}

