/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.lifecycle;

import com.arsdigita.cms.lifecycle.Lifecycle;
import com.arsdigita.cms.lifecycle.LifecycleEvent;
import com.arsdigita.cms.lifecycle.LifecycleListener;
import com.arsdigita.cms.lifecycle.PhaseDefinition;
import com.arsdigita.cms.lifecycle.PublishingException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class Phase
extends ACSObject {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/lifecycle/Phase.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Phase";
    private final String LABEL = "label";
    private final String START_DATE_TIME = "startDateTime";
    private final String END_DATE_TIME = "endDateTime";
    private final String LISTENER = "listener";
    private final String HAS_BEGUN = "hasBegun";
    private final String HAS_ENDED = "hasEnded";
    private final String LIFECYCLE = "lifecycle";
    private final String DEFINITION = "definition";
    private static final String PHASE_ID = "phaseId";
    private static final String OBJECT_ID = "objectId";
    private static final String OBJECT_TYPE = "objectType";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$lifecycle$Phase == null ? (class$com$arsdigita$cms$lifecycle$Phase = Phase.class$("com.arsdigita.cms.lifecycle.Phase")) : class$com$arsdigita$cms$lifecycle$Phase));
    static /* synthetic */ Class class$com$arsdigita$cms$lifecycle$Phase;

    protected Phase() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    protected void initialize() {
        super.initialize();
        if (this.isNew()) {
            this.set("hasBegun", Boolean.FALSE);
            this.set("hasEnded", Boolean.FALSE);
            this.setStartDate(new Date());
        }
    }

    public Phase(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Phase(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public Phase(DataObject obj) {
        super(obj);
    }

    protected Phase(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public String getLabel() {
        PhaseDefinition definition = this.getPhaseDefinition();
        if (definition == null) {
            return "No Label";
        }
        return definition.getLabel();
    }

    public Date getStartDate() {
        return (Date)this.get("startDateTime");
    }

    public void setStartTime(Long time) {
        if (time == null) {
            this.setStartDate(null);
        } else {
            this.setStartDate(new Date(time));
        }
    }

    public void setStartDate(Date date) {
        this.set("startDateTime", date);
    }

    public Date getEndDate() {
        return (Date)this.get("endDateTime");
    }

    public void setEndTime(Long time) {
        if (time == null) {
            this.setEndDate(null);
        } else {
            this.setEndDate(new Date(time));
        }
    }

    public void setEndDate(Date date) {
        this.set("endDateTime", date);
    }

    public String getListenerClassName() {
        return (String)this.get("listener");
    }

    public LifecycleListener getListener() {
        String listenerClassName = this.getListenerClassName();
        LifecycleListener listener = null;
        if (listenerClassName != null) {
            try {
                Class<?> listenerClass = Class.forName(listenerClassName);
                listener = (LifecycleListener)listenerClass.newInstance();
            }
            catch (Exception e) {
                s_log.error((Object)"Listener instantiation error", (Throwable)e);
                throw new PublishingException("Error instantiating lifecycle listener: " + listenerClassName, e);
            }
        }
        return listener;
    }

    public void setListenerClassName(String listener) {
        this.set("listener", listener);
    }

    public boolean hasBegun() {
        return (Boolean)this.get("hasBegun");
    }

    protected void setHasBegun(boolean hasBegun) {
        this.set("hasBegun", new Boolean(hasBegun));
    }

    public boolean hasEnded() {
        return (Boolean)this.get("hasEnded");
    }

    public Lifecycle getLifecycle() {
        DataObject lifecycle = (DataObject)this.get("lifecycle");
        if (lifecycle == null) {
            return null;
        }
        return new Lifecycle(lifecycle);
    }

    protected void setLifecycle(Lifecycle lifecycle) {
        this.setAssociation("lifecycle", (DomainObject)lifecycle);
    }

    public PhaseDefinition getPhaseDefinition() {
        DataObject definition = (DataObject)this.get("definition");
        if (definition == null) {
            return null;
        }
        return new PhaseDefinition(definition);
    }

    protected void setPhaseDefinition(PhaseDefinition definition) {
        this.setAssociation("definition", (DomainObject)definition);
    }

    public void delete() {
        Lifecycle cycle = this.getLifecycle();
        super.delete();
        if (cycle != null) {
            cycle.updateStartEndTimes();
        }
    }

    protected void afterSave() {
        super.afterSave();
        Lifecycle cycle = this.getLifecycle();
        if (cycle != null) {
            cycle.updateStartEndTimes();
        }
    }

    public void start() {
        if (!this.hasBegun()) {
            Date now = new Date();
            Date startDate = this.getStartDate();
            if (startDate == null) {
                startDate = now;
            }
            if (startDate.before(now) || startDate.equals(now)) {
                this.fireListeners();
            }
        }
    }

    private void fireListeners() {
        LifecycleListener listener = this.getListener();
        if (listener != null) {
            Session ssn = SessionManager.getSession();
            DataQuery dq = ssn.retrieveQuery("com.arsdigita.cms.getObjectPhaseMappings");
            Filter f = dq.addEqualsFilter(PHASE_ID, (Object)this.getID());
            while (dq.next()) {
                BigDecimal objectId = (BigDecimal)dq.get(OBJECT_ID);
                String objectType = (String)dq.get(OBJECT_TYPE);
                LifecycleEvent event = new LifecycleEvent(0, this.getStartDate(), this.getEndDate(), objectType, objectId);
                try {
                    listener.begin(event);
                    this.setHasBegun(true);
                    this.save();
                }
                catch (Exception e) {
                    s_log.error((Object)"Error firing listeners", (Throwable)e);
                    dq.close();
                    throw new PublishingException(e.getMessage());
                }
            }
        }
    }

    protected void stop() {
        this.set("hasEnded", Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

