/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer.xml;

import com.arsdigita.cms.AuthoringKit;
import com.arsdigita.cms.AuthoringStep;
import com.arsdigita.cms.AuthoringStepCollection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.installer.xml.ContentTypeHelper;
import com.arsdigita.cms.search.ContentPageMetadataProvider;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.search.MetadataProvider;
import com.arsdigita.search.MetadataProviderRegistry;
import com.arsdigita.util.Assert;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ContentTypeHelperImpl
implements ContentTypeHelper {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$installer$xml$ContentTypeHelperImpl == null ? (class$com$arsdigita$cms$installer$xml$ContentTypeHelperImpl = ContentTypeHelperImpl.class$("com.arsdigita.cms.installer.xml.ContentTypeHelperImpl")) : class$com$arsdigita$cms$installer$xml$ContentTypeHelperImpl));
    private ContentType m_type;
    private ContentType m_parent;
    private String m_label;
    private String m_labelKey;
    private String m_labelBundle;
    private String m_description;
    private String m_descriptionKey;
    private String m_descriptionBundle;
    private String m_objectType;
    private String m_className;
    private String m_createComponent;
    private AuthoringKit m_kit;
    private boolean m_internal;
    static /* synthetic */ Class class$com$arsdigita$cms$installer$xml$ContentTypeHelperImpl;

    public void setLabel(String label) {
        this.m_label = label;
    }

    public String getLabel() {
        return this.m_label;
    }

    public void setLabelBundle(String labelBundle) {
        this.m_labelBundle = labelBundle;
    }

    public String getLabelBundle() {
        return this.m_labelBundle;
    }

    public void setLabelKey(String labelKey) {
        this.m_labelKey = labelKey;
    }

    public String getLabelKey() {
        return this.m_labelKey;
    }

    public void setInternal(boolean internal) {
        this.m_internal = internal;
    }

    public boolean isInternal() {
        return this.m_internal;
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescriptionBundle(String descriptionBundle) {
        this.m_descriptionBundle = descriptionBundle;
    }

    public String getDescriptionBundle() {
        return this.m_descriptionBundle;
    }

    public void setDescriptionKey(String descriptionKey) {
        this.m_descriptionKey = descriptionKey;
    }

    public String getDescriptionKey() {
        return this.m_descriptionKey;
    }

    public void setObjectType(String objType) {
        this.m_objectType = objType;
    }

    public String getObjectType() {
        return this.m_objectType;
    }

    public void setClassName(String classname) {
        this.m_className = classname;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setCreateComponent(String createComponent) {
        this.m_createComponent = createComponent;
    }

    public AuthoringKit getAuthoringKit() {
        Assert.exists((Object)((Object)this.m_kit));
        return this.m_kit;
    }

    public ContentType getContentType() {
        Assert.exists((Object)((Object)this.m_type));
        return this.m_type;
    }

    public void setName(String name) {
    }

    public void setParentType(String parentType) {
    }

    public ContentType createType() {
        Assert.exists((Object)this.m_label);
        Assert.exists((Object)this.m_description);
        Assert.exists((Object)this.m_objectType);
        Assert.exists((Object)this.m_className);
        try {
            s_log.debug((Object)"making new content type");
            this.m_type = ContentType.findByAssociatedObjectType(this.m_objectType);
            this.m_type.setLabel(this.m_label);
            this.m_type.setDescription(this.m_description);
            this.m_type.save();
        }
        catch (DataObjectNotFoundException e) {
            s_log.debug((Object)"Looking for content type");
            s_log.debug((Object)("Creating ContentType Label: " + this.m_label + " Description: " + this.m_description + " className: " + this.m_className + " AssociatedObjectType: " + this.m_objectType));
            this.m_type = new ContentType();
            this.m_type.setLabel(this.m_label);
            this.m_type.setDescription(this.m_description);
            this.m_type.setClassName(this.m_className);
            this.m_type.setAssociatedObjectType(this.m_objectType);
            this.m_type.setInternal(this.m_internal);
            this.m_type.save();
        }
        ObjectType type = SessionManager.getMetadataRoot().getObjectType(this.m_objectType);
        if (type.isSubtypeOf("com.arsdigita.cms.ContentPage") && !this.m_internal) {
            s_log.debug((Object)("Registering search adapter for " + this.m_objectType));
            MetadataProviderRegistry.registerAdapter((String)this.m_objectType, (MetadataProvider)new ContentPageMetadataProvider());
        }
        Assert.exists((Object)((Object)this.m_type));
        return this.m_type;
    }

    public AuthoringKit createAuthoringKit() {
        Assert.exists((Object)((Object)this.m_type));
        s_log.debug((Object)("Createcomponent is : " + this.m_createComponent));
        this.m_kit = this.m_type.getAuthoringKit();
        if (this.m_kit != null) {
            if (this.m_createComponent != null) {
                this.m_kit.setCreateComponent(this.m_createComponent);
            }
            AuthoringStepCollection ac = this.m_kit.getSteps();
            while (ac.next()) {
                AuthoringStep step = ac.getAuthoringStep();
                s_log.debug((Object)("Deleting authoringStep " + step.getLabel()));
                this.m_kit.removeStep(step);
                step.delete();
            }
        } else {
            this.m_kit = this.m_type.createAuthoringKit(this.m_createComponent);
        }
        s_log.debug((Object)"saving authoring kit");
        this.m_kit.save();
        this.m_type.save();
        return this.m_kit;
    }

    public void addAuthoringStep(String label, String description, String component, BigDecimal ordering) {
        this.addAuthoringStep(label, null, description, null, component, ordering);
    }

    public void addAuthoringStep(String labelKey, String labelBundle, String descriptionKey, String descriptionBundle, String component, BigDecimal ordering) {
        s_log.debug((Object)("Creating AuthoringStep  LabelKey: " + labelKey + " LabelBundle: " + labelBundle + " DescriptionKey: " + descriptionKey + " DescriptionBundle: " + descriptionBundle + " Component " + component + " Ordering: " + ordering));
        Assert.exists((Object)((Object)this.m_kit));
        Assert.exists((Object)labelKey);
        Assert.exists((Object)descriptionKey);
        Assert.exists((Object)component);
        Assert.exists((Object)ordering);
        this.m_kit.createStep(labelKey, labelBundle, descriptionKey, descriptionBundle, component, ordering);
        this.m_kit.save();
        this.m_type.save();
    }

    public void saveType() {
        this.m_kit.save();
        this.m_type.save();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

