/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.installer.xml;

import com.arsdigita.cms.ContentBundle;
import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentPage;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.Folder;
import com.arsdigita.cms.installer.xml.ContentItemHelper;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class ContentBundleHelper
extends ContentItemHelper {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$installer$xml$ContentBundleHelper == null ? (class$com$arsdigita$cms$installer$xml$ContentBundleHelper = ContentBundleHelper.class$("com.arsdigita.cms.installer.xml.ContentBundleHelper")) : class$com$arsdigita$cms$installer$xml$ContentBundleHelper));
    private ContentBundle m_bundle = null;
    static /* synthetic */ Class class$com$arsdigita$cms$installer$xml$ContentBundleHelper;

    public ContentBundleHelper(ContentSection section) {
        super(section);
    }

    public void setParent(Folder parent) {
        super.setParent(parent);
        if (this.m_bundle != null) {
            this.m_bundle.setParent((ACSObject)parent);
        }
    }

    public void setContentItem(ContentItem item) {
        super.setContentItem(item);
        this.m_bundle = null;
    }

    public void save() {
        s_log.debug((Object)"About to save bundle");
        this.m_bundle.save();
        this.m_item.save();
        s_log.debug((Object)"Saved bundle");
    }

    protected ContentItem createContentItem(boolean save) {
        super.createContentItem(save);
        if (this.m_item instanceof ContentBundle) {
            s_log.warn((Object)"Item already existed as a ContentBundle");
            this.m_bundle = (ContentBundle)this.m_item;
            this.m_item = this.m_bundle.getInstance(this.m_language);
            if (this.m_item == null) {
                this.m_item = this.createNewContentItem();
                this.m_bundle.addInstance(this.m_item);
            }
        } else {
            s_log.warn((Object)"Wrapping new Item in ContentBundle");
            this.m_bundle = new ContentBundle(this.m_item);
            this.m_bundle.setContentSection(this.getContentSection());
            this.m_bundle.setParent((ACSObject)this.getParent());
        }
        if (save) {
            this.save();
        }
        s_log.warn((Object)("Created bundled Item: " + this.getName() + "  " + this.m_item));
        return this.m_item;
    }

    protected ContentItem createNewContentItem() {
        ContentItem toReturn = super.createNewContentItem();
        ((ContentPage)toReturn).setTitle(toReturn.getName());
        return toReturn;
    }

    public ContentItem cloneItem(String name, Folder parent, boolean save) {
        ContentBundle originalBundle = ((ContentPage)this.m_item).getContentBundle();
        s_log.debug((Object)("Original bundle before cloning: " + originalBundle.getName() + " " + originalBundle));
        ContentBundle cloneBundle = (ContentBundle)this.getContentItemByName(name, parent);
        ContentItem clone = super.newCloneItem(name, parent);
        ((ContentPage)clone).setTitle(clone.getName());
        originalBundle.setName(this.getName());
        originalBundle.setParent((ACSObject)this.getParent());
        s_log.debug((Object)("Original bundle after cloning: " + originalBundle.getName() + " " + originalBundle));
        if (cloneBundle != null) {
            cloneBundle.addInstance(clone);
        } else {
            cloneBundle = new ContentBundle(clone);
            cloneBundle.setContentSection(clone.getContentSection());
            cloneBundle.setParent((ACSObject)parent);
        }
        s_log.debug((Object)("Used Bundle: " + cloneBundle));
        if (save) {
            clone.save();
            cloneBundle.save();
        }
        Assert.assertNotNull((Object)clone);
        return clone;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

