/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.PageState;
import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.CMS;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.SecurityManager;
import com.arsdigita.cms.dispatcher.CMSDispatcher;
import com.arsdigita.cms.dispatcher.ContentCenterDispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.KernelContext;
import com.arsdigita.kernel.PackageInstance;
import com.arsdigita.kernel.PackageInstanceCollection;
import com.arsdigita.kernel.PackageType;
import com.arsdigita.kernel.SiteNode;
import com.arsdigita.kernel.SiteNodeCollection;
import com.arsdigita.kernel.User;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class Utilities {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/Utilities.java#16 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String CMS_WORKSPACE = "content-center";
    public static final String CMS_SERVICE = "cms-service";
    private static HashMap m_cache = new HashMap();
    private static Date s_lastSectionRefresh = null;
    private static Map s_sectionRefreshTimes = Collections.synchronizedMap(new HashMap());
    public static final Logger LOG = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$Utilities == null ? (class$com$arsdigita$cms$dispatcher$Utilities = Utilities.class$("com.arsdigita.cms.dispatcher.Utilities")) : class$com$arsdigita$cms$dispatcher$Utilities));
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$Utilities;

    public static String getWorkspaceURL() {
        String url = (String)m_cache.get(CMS_WORKSPACE);
        if (url == null) {
            url = Utilities.getSingletonPackageURL(CMS_WORKSPACE);
            m_cache.put(CMS_WORKSPACE, url);
        }
        return url;
    }

    public static String getServiceURL() {
        String url = (String)m_cache.get(CMS_SERVICE);
        if (url == null) {
            url = Utilities.getSingletonPackageURL(CMS_SERVICE);
            m_cache.put(CMS_SERVICE, url);
        }
        return url;
    }

    public static String getLogoutURL() {
        StringBuffer buf = new StringBuffer(Utilities.getServiceURL());
        buf.append("logout");
        return buf.toString();
    }

    public static String getAssetURL(BinaryAsset asset) {
        return Utilities.getAssetURL(asset.getID());
    }

    public static String getAssetURL(BigDecimal assetId) {
        StringBuffer buf = new StringBuffer(Utilities.getServiceURL());
        buf.append("stream/asset?");
        buf.append("asset_id").append("=").append(assetId);
        return buf.toString();
    }

    public static String getImageURL(ImageAsset asset) {
        StringBuffer buf = new StringBuffer(Utilities.getServiceURL());
        buf.append("stream/image/?");
        buf.append("image_id").append("=").append(asset.getID());
        return buf.toString();
    }

    public static String getImageOID(ImageAsset asset) {
        String oid = asset.getOID().toString();
        return oid;
    }

    public static String getGlobalAssetsURL() {
        return Utilities.getWebappContext();
    }

    private static String getSingletonPackageURL(String key) {
        PackageType type = null;
        type = PackageType.findByKey((String)key);
        PackageInstanceCollection instances = type.getInstances();
        PackageInstance instance = null;
        if (!instances.next()) {
            instances.close();
            throw new RuntimeException("Failed to locate an instance of the singleton package: " + key);
        }
        instance = instances.getPackageInstance();
        instances.close();
        SiteNodeCollection nodes = instance.getMountPoints();
        SiteNode node = null;
        if (!nodes.next()) {
            nodes.close();
            throw new RuntimeException("Failed to locate a mountpoint for the singleton package: " + key);
        }
        node = nodes.getSiteNode();
        nodes.close();
        StringBuffer url = new StringBuffer();
        String context = Utilities.getWebappContext();
        if (context != null) {
            url.append(context);
        }
        url.append(SiteNode.getRootSiteNode().getURL()).append(node.getURL().substring(1));
        LOG.debug((Object)("Single package url for " + key + " is " + url));
        return url.toString();
    }

    public static String getWebappContext() {
        return DispatcherHelper.getWebappContext();
    }

    public static synchronized Date getLastSectionRefresh(ContentSection section) {
        String sectionURL = section.getURL();
        Date lastModified = (Date)s_sectionRefreshTimes.get(sectionURL);
        if (lastModified == null) {
            s_lastSectionRefresh = lastModified = new Date();
            s_sectionRefreshTimes.put(sectionURL, lastModified);
        }
        return lastModified;
    }

    public static Date getLastSectionRefresh() {
        if (s_lastSectionRefresh == null) {
            s_lastSectionRefresh = new Date();
        }
        return s_lastSectionRefresh;
    }

    public static void refreshItemUI(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        CMSDispatcher.releaseResource(section, "admin/item");
        ContentCenterDispatcher.releaseResource("");
        ContentCenterDispatcher.releaseResource("index");
        Utilities.refreshAdminUI(state);
        s_lastSectionRefresh = new Date();
        s_sectionRefreshTimes.put(section.getURL(), s_lastSectionRefresh);
    }

    public static void refreshAdminUI(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        CMSDispatcher.releaseResource(section, "admin");
        CMSDispatcher.releaseResource(section, "admin/index");
        CMSDispatcher.releaseResource(section, "");
        ContentCenterDispatcher.releaseResource("");
        ContentCenterDispatcher.releaseResource("index");
    }

    public static void disableBrowserCache(HttpServletResponse response) {
        response.addHeader("pragma", "no-cache");
    }

    public static User getCurrentUser(HttpServletRequest request) {
        KernelContext kernelContext = Kernel.getContext();
        if (kernelContext.getParty() instanceof User) {
            return (User)kernelContext.getParty();
        }
        return null;
    }

    public static SecurityManager getSecurityManager(PageState state) {
        ContentSection section = CMS.getContext().getContentSection();
        return new SecurityManager(section);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

