/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.bebop.parameters.BigDecimalParameter;
import com.arsdigita.cms.Article;
import com.arsdigita.cms.ImageAsset;
import com.arsdigita.cms.ImageAssetCollection;
import com.arsdigita.cms.dispatcher.ResourceHandlerImpl;
import com.arsdigita.cms.util.GlobalizationUtil;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.persistence.OID;
import com.arsdigita.toolbox.ui.OIDParameter;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class StreamImage
extends ResourceHandlerImpl {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/StreamImage.java#19 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String IMAGE_ID = "image_id";
    public static final String OID_PARAM = "oid";
    public static final String TRANSACTION_ID = "transID";
    public static final String OBJECT_ID = "objectID";
    private BigDecimalParameter m_imageId = new BigDecimalParameter("image_id");
    private OIDParameter m_oid = new OIDParameter("oid");
    private BigDecimalParameter m_transactionID = new BigDecimalParameter("transID");
    private BigDecimalParameter m_objectID = new BigDecimalParameter("objectID");
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$dispatcher$StreamImage == null ? (class$com$arsdigita$cms$dispatcher$StreamImage = StreamImage.class$("com.arsdigita.cms.dispatcher.StreamImage")) : class$com$arsdigita$cms$dispatcher$StreamImage));
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$StreamImage;

    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        OID oid = (OID)this.m_oid.transformValue(request);
        BigDecimal imageId = (BigDecimal)this.m_imageId.transformValue(request);
        if (imageId == null && oid == null) {
            throw new ServletException("image_id or oid is required.");
        }
        if (imageId != null && oid != null) {
            throw new ServletException("image_id or oid must not both be specified.");
        }
        if (oid == null) {
            oid = new OID("com.arsdigita.cms.ImageAsset", (Object)imageId);
        }
        BigDecimal transactionID = (BigDecimal)this.m_transactionID.transformValue(request);
        BigDecimal objectID = (BigDecimal)this.m_objectID.transformValue(request);
        Object transaction = null;
        Article article = null;
        ImageAsset image = null;
        Object mimeType = null;
        if (article == null) {
            try {
                image = (ImageAsset)DomainObjectFactory.newInstance((OID)oid);
            }
            catch (DataObjectNotFoundException nfe) {
                if (s_log.isInfoEnabled()) {
                    s_log.info((Object)("no ImageAsset with oid " + oid));
                }
                throw new ServletException((String)GlobalizationUtil.globalize("cms.dispatcher.could_not_find_imageasset").localize() + oid);
            }
        } else {
            ImageAssetCollection col = article.getImages();
            col.addEqualsFilter("id", imageId);
            if (col.next()) {
                image = col.getImage();
                col.close();
            } else {
                s_log.error((Object)("failed to retrieve ImageAsset: " + imageId));
                throw new ServletException((String)GlobalizationUtil.globalize("cms.dispatcher.failed_to_retrieve_imageasset").localize() + imageId);
            }
        }
        if (image.getMimeType() == null) {
            s_log.error((Object)("MIME type for ImageAsset not found; id = " + imageId));
            throw new ServletException("Failed to retrieve MIME type for ImageAsset: " + imageId);
        }
        if ("live".equals(image.getVersion())) {
            DispatcherHelper.cacheForWorld((HttpServletResponse)response);
        } else {
            DispatcherHelper.cacheDisable((HttpServletResponse)response);
        }
        response.setContentType(image.getMimeType().getMimeType());
        ServletOutputStream out = response.getOutputStream();
        image.writeBytes((OutputStream)out);
        out.close();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

