/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.dispatcher.ResourceMapping;
import com.arsdigita.cms.dispatcher.ResourceType;
import com.arsdigita.db.Sequences;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.sql.SQLException;

public class Resource
extends DomainObject {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/Resource.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.Resource";
    private static final String ID = "id";
    private static final String RESOURCE_TYPE = "type";
    private static final String CLASSNAME = "className";

    public Resource() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public Resource(String type) {
        super(type);
    }

    public Resource(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public Resource(DataObject obj) {
        super(obj);
    }

    public BigDecimal getID() {
        return (BigDecimal)this.get(ID);
    }

    public String getClassName() {
        return (String)this.get(CLASSNAME);
    }

    private void setID(BigDecimal id) {
        this.set(ID, id);
    }

    public void setClassName(String s) {
        this.set(CLASSNAME, s);
    }

    public ResourceType getType() {
        DataObject type = (DataObject)this.get(RESOURCE_TYPE);
        if (type == null) {
            return null;
        }
        return new ResourceType(type);
    }

    public void setType(ResourceType t) {
        this.setAssociation(RESOURCE_TYPE, t);
    }

    protected static Resource create(ResourceType type, String className) {
        Resource resource = new Resource();
        try {
            BigDecimal id = Sequences.getNextValue();
            resource.setID(id);
        }
        catch (SQLException e) {
            throw new UncheckedWrapperException("Error creating Resource", (Throwable)e);
        }
        resource.setClassName(className);
        resource.setType(type);
        return resource;
    }

    public ResourceMapping createInstance(ContentSection section, String url) {
        return this.createInstance(section.getID(), url);
    }

    public ResourceMapping createInstance(BigDecimal sectionId, String url) {
        ResourceMapping map = new ResourceMapping();
        map.setSectionID(sectionId);
        map.setUrl(url);
        map.setResourceID(this.getID());
        return map;
    }

    public static Resource findResource(ContentSection section, String url) throws DataObjectNotFoundException {
        Session session = SessionManager.getSession();
        DataQuery dq = session.retrieveQuery("com.arsdigita.cms.getResourceMappings");
        Filter f = dq.addFilter("sectionId = :sectionId and url = :url");
        f.set("sectionId", (Object)section.getID());
        f.set("url", (Object)url);
        Resource resource = null;
        BigDecimal id = null;
        if (dq.next()) {
            id = (BigDecimal)dq.get("resourceId");
            resource = new Resource(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
            dq.close();
        }
        return resource;
    }
}

