/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms.dispatcher;

import com.arsdigita.cms.dispatcher.ResourceHandler;
import com.arsdigita.cms.dispatcher.SimpleCache;
import com.arsdigita.cms.installer.ContentCenterSetup;
import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.DispatcherHelper;
import com.arsdigita.dispatcher.JSPApplicationDispatcher;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.kernel.security.Initializer;
import com.arsdigita.kernel.security.UserContext;
import com.arsdigita.ui.login.LoginHelper;
import com.arsdigita.util.LockableImpl;
import com.arsdigita.web.LoginSignal;
import com.arsdigita.web.Web;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class ContentCenterDispatcher
extends LockableImpl
implements Dispatcher {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/dispatcher/ContentCenterDispatcher.java#17 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String DEFAULT_MAP_FILE = "/WEB-INF/resources/content-center-map.xml";
    private static Logger s_log = Logger.getLogger((String)(class$com$arsdigita$cms$dispatcher$ContentCenterDispatcher == null ? (class$com$arsdigita$cms$dispatcher$ContentCenterDispatcher = ContentCenterDispatcher.class$("com.arsdigita.cms.dispatcher.ContentCenterDispatcher")) : class$com$arsdigita$cms$dispatcher$ContentCenterDispatcher).getName());
    private static HashMap s_pageClasses = ContentCenterSetup.getURLToClassMap();
    private static HashMap s_pageURLs = ContentCenterSetup.getClassToURLMap();
    private static SimpleCache s_pages = new SimpleCache();
    private Dispatcher m_notFoundHandler;
    private ArrayList m_trailingSlashList = new ArrayList();
    static /* synthetic */ Class class$com$arsdigita$cms$dispatcher$ContentCenterDispatcher;

    public ContentCenterDispatcher() {
        this.requireTrailingSlash("");
        this.setNotFoundDispatcher((Dispatcher)JSPApplicationDispatcher.getInstance());
    }

    public void dispatch(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws IOException, ServletException {
        DeveloperSupport.startStage((String)"ContentCenterDispatcher.dispatch");
        String url = actx.getRemainingURLPart();
        String originalUrl = actx.getOriginalURL();
        if (this.m_trailingSlashList.contains(url) && !originalUrl.endsWith("/")) {
            DispatcherHelper.sendRedirect((HttpServletResponse)response, (String)(originalUrl + "/"));
            return;
        }
        this.checkUserAccess(request, response, actx);
        ResourceHandler page = this.getResource(url);
        if (page != null) {
            page.init();
            page.dispatch(request, response, actx);
            DispatcherHelper.maybeCacheDisable((HttpServletResponse)response);
        } else {
            this.m_notFoundHandler.dispatch(request, response, actx);
        }
        DeveloperSupport.endStage((String)"ContentCenterDispatcher.dispatch");
    }

    public final void setNotFoundDispatcher(Dispatcher d) {
        this.m_notFoundHandler = d;
    }

    public void requireTrailingSlash(String url) {
        this.m_trailingSlashList.add(url);
    }

    public static String getURLStubForClass(String classname) {
        s_log.debug((Object)("Getting URL Stub for : " + classname));
        Iterator itr = s_pageURLs.keySet().iterator();
        while (itr.hasNext()) {
            String classname2 = (String)itr.next();
            s_log.debug((Object)("key: " + classname + " value: " + (String)s_pageURLs.get(classname2)));
        }
        String url = (String)s_pageURLs.get(classname);
        return url;
    }

    protected ResourceHandler getResource(String url) throws ServletException {
        String pageClassName;
        ResourceHandler page = (ResourceHandler)s_pages.get(url);
        if (page == null && (pageClassName = (String)s_pageClasses.get(url)) != null) {
            Class<?> pageClass;
            try {
                pageClass = Class.forName(pageClassName);
            }
            catch (ClassNotFoundException e) {
                s_log.error((Object)"error fetching class for ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            try {
                page = (ResourceHandler)pageClass.newInstance();
            }
            catch (InstantiationException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            catch (IllegalAccessException e) {
                s_log.error((Object)"error instantiating a ResourceHandler", (Throwable)e);
                throw new ServletException((Throwable)e);
            }
            page.init();
            s_pages.put(url, page);
        }
        return page;
    }

    protected void addResource(String url, String className) {
        s_pageClasses.put(url, className);
        s_pageURLs.put(className, url);
    }

    public static void releaseResource(String url) {
        s_pages.remove(url);
    }

    protected void checkUserAccess(HttpServletRequest request, HttpServletResponse response, RequestContext actx) throws ServletException {
        if (!Web.getUserContext().isLoggedIn()) {
            throw new LoginSignal(request);
        }
    }

    protected void redirectToLoginPage(HttpServletRequest req, HttpServletResponse resp) throws ServletException {
        String url = Initializer.getSecurityHelper().getLoginURL(req) + "?" + "return_url" + "=" + UserContext.encodeReturnURL((HttpServletRequest)req);
        try {
            LoginHelper.sendRedirect((HttpServletRequest)req, (HttpServletResponse)resp, (String)url);
        }
        catch (IOException e) {
            s_log.error((Object)"IO Exception", (Throwable)e);
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

