/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.Asset;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;

public class TextAsset
extends Asset {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/TextAsset.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.TextAsset";
    public static final String CONTENT = "content";

    public TextAsset() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public TextAsset(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public TextAsset(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public TextAsset(DataObject obj) {
        super(obj);
    }

    public TextAsset(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public long readText(Reader reader) throws IOException {
        StringWriter writer = new StringWriter();
        char[] buffer = new char[8];
        int length = -1;
        while ((length = reader.read(buffer)) != -1) {
            writer.write(buffer, 0, length);
        }
        String content = writer.toString();
        this.setText(content);
        reader.close();
        writer.close();
        long total = content.length();
        return total;
    }

    public long writeText(Writer writer) throws IOException {
        String text = null;
        Object content = this.get(CONTENT);
        if (content == null) {
            return 0L;
        }
        text = (String)content;
        writer.write(text);
        writer.close();
        return text.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) throws IOException {
        FileOutputStream fs = new FileOutputStream(file);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(fs);
            this.writeText(writer);
        }
        finally {
            if (null != fs) {
                fs.close();
            }
        }
    }

    public String getText() {
        Object content = this.get(CONTENT);
        return (String)content;
    }

    public void setText(String text) {
        this.set(CONTENT, text);
    }

    public boolean recordChanges() {
        return "draft".equals(this.getVersion());
    }
}

