/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.BinaryAsset;
import com.arsdigita.cms.ImageAssetCollection;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.mimetypes.ImageMimeType;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.mimetypes.image.ImageSizer;
import com.arsdigita.mimetypes.image.ImageSizerFactory;
import com.arsdigita.persistence.DataCollection;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import java.awt.Dimension;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class ImageAsset
extends BinaryAsset {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ImageAsset.java#19 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.cms.ImageAsset";
    public static final String CONTENT = "content";
    public static final String HEIGHT = "height";
    public static final String WIDTH = "width";
    public static final String MIME_JPEG = "image/jpeg";
    public static final String MIME_GIF = "image/gif";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ImageAsset == null ? (class$com$arsdigita$cms$ImageAsset = ImageAsset.class$("com.arsdigita.cms.ImageAsset")) : class$com$arsdigita$cms$ImageAsset));
    static /* synthetic */ Class class$com$arsdigita$cms$ImageAsset;

    public ImageAsset() {
        super(BASE_DATA_OBJECT_TYPE);
    }

    public ImageAsset(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public ImageAsset(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public ImageAsset(DataObject obj) {
        super(obj);
    }

    public ImageAsset(String type) {
        super(type);
    }

    public String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public BigDecimal getWidth() {
        return (BigDecimal)this.get(WIDTH);
    }

    public void setWidth(BigDecimal width) {
        this.set(WIDTH, width);
    }

    public BigDecimal getHeight() {
        return (BigDecimal)this.get(HEIGHT);
    }

    public void setHeight(BigDecimal height) {
        this.set(HEIGHT, height);
    }

    protected byte[] getContent() {
        return (byte[])this.get(CONTENT);
    }

    protected void setContent(byte[] content) {
        this.set(CONTENT, content);
    }

    public void loadFromFile(String fileName, File file, String defaultMimeType) throws IOException {
        MimeType mime = MimeType.guessMimeTypeFromFile((String)fileName);
        if (mime != null && mime instanceof ImageMimeType) {
            this.guessSize(file, (ImageMimeType)mime);
        } else {
            mime = MimeType.loadMimeType((String)defaultMimeType);
        }
        this.setMimeType(mime);
        int i = fileName.lastIndexOf("/");
        if (i > 0) {
            fileName = fileName.substring(i + 1);
        }
        if ((i = fileName.lastIndexOf("\\")) > 0) {
            fileName = fileName.substring(i + 1);
        }
        this.setName(fileName);
        FileInputStream in = new FileInputStream(file);
        this.readBytes(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File file) throws IOException {
        FileOutputStream fs = new FileOutputStream(file);
        try {
            fs.write(this.getContent());
        }
        finally {
            if (null != fs) {
                fs.close();
            }
        }
    }

    protected void guessSize(File file, ImageMimeType mime) {
        BigDecimal width = null;
        BigDecimal height = null;
        ImageSizer sizer = ImageSizerFactory.getImageSizer((String)mime.getMimeType());
        try {
            Dimension d;
            if (sizer != null && (d = sizer.computeImageSize(file)) != null) {
                width = new BigDecimal((double)((int)d.getWidth()));
                height = new BigDecimal((double)((int)d.getHeight()));
            }
        }
        catch (IOException ex) {
            s_log.error((Object)"IOException guessing file size", (Throwable)ex);
        }
        this.setWidth(width);
        this.setHeight(height);
    }

    public static ImageAssetCollection getAllImages() {
        DataCollection da = SessionManager.getSession().retrieve(BASE_DATA_OBJECT_TYPE);
        da.addEqualsFilter("isDeleted", (Object)new Integer(0));
        return new ImageAssetCollection(da);
    }

    public static ImageAssetCollection getImagesByKeyword(String keyword, String context) {
        ImageAssetCollection c = ImageAsset.getAllImages();
        c.addOrder("name");
        Filter f = c.addFilter("name like ('%' || :keyword || '%')");
        f.set("keyword", (Object)keyword);
        f = c.addFilter("version = :version");
        f.set("version", (Object)context);
        return c;
    }

    public static ImageAssetCollection getImagesByKeyword(String keyword) {
        return ImageAsset.getImagesByKeyword(keyword, "draft");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

