/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentSection;
import com.arsdigita.cms.ContentType;
import com.arsdigita.cms.ItemTemplateCollection;
import com.arsdigita.cms.ItemTemplateMapping;
import com.arsdigita.cms.SectionTemplateMapping;
import com.arsdigita.cms.Template;
import com.arsdigita.cms.TemplateCollection;
import com.arsdigita.cms.TemplateManager;
import com.arsdigita.cms.dispatcher.ContentItemDispatcher;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.mimetypes.MimeType;
import com.arsdigita.persistence.DataOperation;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;

public class DefaultTemplateManager
implements TemplateManager {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/DefaultTemplateManager.java#11 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final String SECTION_ID = "sectionID";
    private static final String TYPE_ID = "typeID";
    private static final String USE_CONTEXT = "useContext";
    private static final String NEW_DEFAULT_ID = "newDefaultID";
    private static final String MIME_TYPE_STRING = "mimeTypeString";
    private static final String OP_SET_DEFAULT = "com.arsdigita.cms.setDefaultTemplate";
    private static final String OP_SET_DEFAULT_NO_MIME_TYPE = "com.arsdigita.cms.setDefaultTemplateNullMimeType";
    private static final DefaultTemplateManager m_instance = new DefaultTemplateManager();

    public void addTemplate(ContentItem item, Template template, String context, MimeType mimeType) {
        ItemTemplateMapping m = ItemTemplateMapping.getMapping(item, context, mimeType);
        if (m == null) {
            m = new ItemTemplateMapping();
            m.setContentItem(item);
            m.setUseContext(context);
        }
        m.setTemplate(template);
        m.save();
    }

    public void addTemplate(ContentItem item, Template template, String context) {
        this.addTemplate(item, template, context, template.getMimeType());
    }

    public void removeTemplate(ContentItem item, Template template, String context) {
        ItemTemplateMapping m = ItemTemplateMapping.getMapping(item, context, template);
        if (m != null) {
            m.delete();
        }
    }

    public void addTemplate(ContentSection section, ContentType type, Template template, String context, boolean isDefault) {
        SectionTemplateMapping m = new SectionTemplateMapping();
        if (template.getParent() == null) {
            template.setParent((ACSObject)section.getTemplatesFolder());
            template.setContentSection(section);
            template.save();
        }
        m.setContentSection(section);
        m.setContentType(type);
        m.setUseContext(context);
        m.setTemplate(template);
        m.setDefault(isDefault ? Boolean.TRUE : Boolean.FALSE);
        m.save();
    }

    public void setDefaultTemplate(ContentSection section, ContentType type, Template template, String useContext) {
        Session s = SessionManager.getSession();
        DataOperation op = null;
        if (template.getMimeType() != null) {
            op = s.retrieveDataOperation(OP_SET_DEFAULT);
            op.setParameter(MIME_TYPE_STRING, (Object)template.getMimeType().getMimeType());
        } else {
            op = s.retrieveDataOperation(OP_SET_DEFAULT_NO_MIME_TYPE);
        }
        op.setParameter(SECTION_ID, (Object)section.getID());
        op.setParameter(TYPE_ID, (Object)type.getID());
        op.setParameter(USE_CONTEXT, (Object)useContext);
        op.setParameter(NEW_DEFAULT_ID, (Object)template.getID());
        op.execute();
        ContentItemDispatcher.cachePut(section, type, template);
    }

    public void addTemplate(ContentSection section, ContentType type, Template template, String context) {
        TemplateCollection c = this.getTemplates(section, type, context);
        boolean hasNext = c.next();
        if (hasNext) {
            c.close();
        }
        this.addTemplate(section, type, template, context, !hasNext);
    }

    public void removeTemplate(ContentSection section, ContentType type, Template template, String context) {
        SectionTemplateMapping m = SectionTemplateMapping.getMapping(section, type, template, context);
        if (m != null) {
            m.delete();
        }
    }

    public Template getTemplate(ContentItem item, String context) {
        ItemTemplateMapping m = ItemTemplateMapping.getMapping(item, context);
        if (m == null) {
            return null;
        }
        return m.getTemplate();
    }

    public TemplateCollection getTemplates(ContentItem item) {
        return ItemTemplateMapping.getTemplates(item);
    }

    public TemplateCollection getUseContexts(ContentItem item) {
        return ItemTemplateMapping.getUseContexts(item);
    }

    public ItemTemplateCollection getContextsWithTypes(ContentItem item) {
        return ItemTemplateMapping.getContextsWithTypes(item);
    }

    public Template getDefaultTemplate(ContentSection section, ContentType type, String context) {
        return SectionTemplateMapping.getDefaultTemplate(section, type, context);
    }

    public Template getDefaultTemplate(ContentSection section, ContentType type, String context, MimeType mimeType) {
        return SectionTemplateMapping.getDefaultTemplate(section, type, context, mimeType);
    }

    public TemplateCollection getTemplates(ContentSection section, ContentType type) {
        return SectionTemplateMapping.getTemplates(section, type);
    }

    public TemplateCollection getTemplates(ContentSection section, ContentType type, String context) {
        return SectionTemplateMapping.getTemplates(section, type, context);
    }
}

