/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.categorization.Category;
import com.arsdigita.domain.DomainQuery;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import java.math.BigDecimal;

public class CategoryItemsQuery
extends DomainQuery {
    private static final String ITEMS_QUERY = "com.arsdigita.cms.itemsInCategory";
    public static final String CATEGORY_ID = "categoryID";
    public static final String CONTEXT = "context";
    public static final String ITEM_ID = "itemID";
    public static final String NAME = "name";
    public static final String DISPLAY_NAME = "displayName";
    public static final String OBJECT_TYPE = "objectType";
    public static final String DEFAULT_DOMAIN_CLASS = "defaultDomainClass";

    private CategoryItemsQuery(DataQuery items) {
        super(items);
    }

    public static CategoryItemsQuery retrieve(Category cat) {
        return CategoryItemsQuery.retrieve(cat, "live");
    }

    public static CategoryItemsQuery retrieve(Category cat, String context) {
        Session s = SessionManager.getSession();
        DataQuery dc = s.retrieveQuery(ITEMS_QUERY);
        dc.setParameter(CATEGORY_ID, (Object)cat.getID());
        dc.setParameter(CONTEXT, (Object)("live" == context ? "live" : "draft"));
        return new CategoryItemsQuery(dc);
    }

    public BigDecimal getItemID() {
        return (BigDecimal)this.get(ITEM_ID);
    }

    public String getName() {
        return (String)this.get(NAME);
    }

    public String getDisplayName() {
        return (String)this.get(DISPLAY_NAME);
    }

    public String getObjectType() {
        return (String)this.get(OBJECT_TYPE);
    }

    public String getDefaultDomainClass() {
        return (String)this.get(DEFAULT_DOMAIN_CLASS);
    }
}

