/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.cms;

import com.arsdigita.cms.ContentItem;
import com.arsdigita.cms.ContentType;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.domain.DomainService;
import com.arsdigita.kernel.ACSObject;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.UncheckedWrapperException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class ACSObjectFactory
extends DomainService {
    public static final String versionId = "$Id: //cms/dev/src/com/arsdigita/cms/ACSObjectFactory.java#15 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$cms$ACSObjectFactory == null ? (class$com$arsdigita$cms$ACSObjectFactory = ACSObjectFactory.class$("com.arsdigita.cms.ACSObjectFactory")) : class$com$arsdigita$cms$ACSObjectFactory));
    private static Class[] s_args = new Class[]{class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = ACSObjectFactory.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID};
    private static Class[] s_newArgs = new Class[]{class$java$lang$String == null ? (class$java$lang$String = ACSObjectFactory.class$("java.lang.String")) : class$java$lang$String};
    private static Class[] s_dataArgs = new Class[]{class$com$arsdigita$persistence$DataObject == null ? (class$com$arsdigita$persistence$DataObject = ACSObjectFactory.class$("com.arsdigita.persistence.DataObject")) : class$com$arsdigita$persistence$DataObject};
    static /* synthetic */ Class class$com$arsdigita$cms$ACSObjectFactory;
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$arsdigita$persistence$DataObject;

    public static ACSObject loadACSObject(Class javaClass, String objectType, BigDecimal id) {
        try {
            Constructor constr = javaClass.getConstructor(s_args);
            OID oid = new OID(objectType, (Object)id);
            return (ACSObject)constr.newInstance(oid);
        }
        catch (NoSuchMethodException nsme) {
            throw new UncheckedWrapperException((Throwable)nsme);
        }
        catch (InstantiationException ie) {
            throw new UncheckedWrapperException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new UncheckedWrapperException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new UncheckedWrapperException((Throwable)ite);
        }
    }

    public static ACSObject loadACSObject(String javaClass, String objectType, BigDecimal id) {
        try {
            return ACSObjectFactory.loadACSObject(Class.forName(javaClass), objectType, id);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UncheckedWrapperException((Throwable)cnfe);
        }
    }

    public static ContentItem castContentItem(ContentItem item) {
        String javaClass = null;
        String objectType = null;
        ContentType t = item.getContentType();
        if (t != null) {
            javaClass = t.getClassName();
            objectType = t.getAssociatedObjectType();
        } else {
            javaClass = objectType = item.getSpecificObjectType();
        }
        return (ContentItem)ACSObjectFactory.loadACSObject(javaClass, objectType, item.getID());
    }

    public static ObjectType getSpecificObjectType(ACSObject obj) {
        String typeName = obj.getSpecificObjectType();
        return SessionManager.getMetadataRoot().getObjectType(typeName);
    }

    public static ACSObject castACSObject(DataObject obj) {
        String objType = obj.getOID().getObjectType().getQualifiedName();
        String javaClassName = (String)obj.get("objectType");
        if (!javaClassName.equals(objType)) {
            obj.specialize(javaClassName);
        }
        try {
            Class<?> javaClass = Class.forName(javaClassName);
            Constructor<?> constr = javaClass.getConstructor(s_dataArgs);
            return (ACSObject)constr.newInstance(obj);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UncheckedWrapperException((Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new UncheckedWrapperException((Throwable)nsme);
        }
        catch (InstantiationException ie) {
            throw new UncheckedWrapperException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new UncheckedWrapperException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new UncheckedWrapperException((Throwable)ite);
        }
    }

    public static ACSObject castACSObject(ACSObject obj) {
        String objectTypeName = null;
        ObjectType specificType = null;
        ObjectType currentType = obj.getOID().getObjectType();
        objectTypeName = obj.getSpecificObjectType();
        if (objectTypeName == null) {
            objectTypeName = currentType.getQualifiedName();
        } else {
            specificType = SessionManager.getMetadataRoot().getObjectType(objectTypeName);
            if (specificType == null) {
                return obj;
            }
            objectTypeName = specificType.getQualifiedName();
        }
        if (obj.getClass().getName().equals(objectTypeName)) {
            return obj;
        }
        ACSObject newObj = ACSObjectFactory.loadACSObject(objectTypeName, objectTypeName, obj.getID());
        if (newObj == null) {
            return obj;
        }
        return newObj;
    }

    public static ContentItem castContentItem(DataObject obj, boolean useContentType) {
        DataObject tobj;
        OID oid = obj.getOID();
        ContentType t = null;
        String javaClassName = null;
        String objectType = (String)obj.get("objectType");
        if (objectType == null) {
            objectType = oid.getObjectType().getQualifiedName();
        }
        if (useContentType && (t = (tobj = (DataObject)obj.get("type")) != null ? new ContentType(tobj) : ContentType.findByAssociatedObjectType(objectType)) != null) {
            javaClassName = t.getClassName();
        }
        if (javaClassName == null) {
            javaClassName = objectType;
        }
        try {
            Class<?> javaClass = Class.forName(javaClassName);
            Constructor<?> constr = javaClass.getConstructor(s_dataArgs);
            return (ContentItem)constr.newInstance(obj);
        }
        catch (ClassNotFoundException cnfe) {
            throw new UncheckedWrapperException((Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            try {
                return (ContentItem)ACSObjectFactory.loadACSObject(javaClassName, objectType, (BigDecimal)oid.get("id"));
            }
            catch (ClassCastException ex) {
                s_log.warn((Object)("Assumption (type == java class) for " + objectType + " is incorrect, giving up"));
                return null;
            }
        }
        catch (InstantiationException ie) {
            throw new UncheckedWrapperException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new UncheckedWrapperException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new UncheckedWrapperException((Throwable)ite);
        }
    }

    public static ContentItem castContentItem(DataObject obj) {
        return ACSObjectFactory.castContentItem(obj, true);
    }

    public static ContentItem castContentItem(DomainObject obj) {
        return ACSObjectFactory.castContentItem(ACSObjectFactory.getDataObject((DomainObject)obj));
    }

    public static ACSObject createACSObject(String javaClassName, String objectType) {
        try {
            Class<?> javaClass = Class.forName(javaClassName);
            Constructor<?> constr = javaClass.getConstructor(s_newArgs);
            ACSObject obj = (ACSObject)constr.newInstance(objectType);
            return obj;
        }
        catch (ClassNotFoundException cnfe) {
            throw new UncheckedWrapperException((Throwable)cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new UncheckedWrapperException((Throwable)nsme);
        }
        catch (InstantiationException ie) {
            throw new UncheckedWrapperException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new UncheckedWrapperException((Throwable)iae);
        }
        catch (InvocationTargetException ite) {
            throw new UncheckedWrapperException((Throwable)ite);
        }
    }

    public static ACSObject createACSObject(String javaClassName) {
        try {
            Class<?> javaClass = Class.forName(javaClassName);
            ACSObject obj = (ACSObject)javaClass.newInstance();
            return obj;
        }
        catch (ClassNotFoundException cnfe) {
            throw new UncheckedWrapperException((Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            throw new UncheckedWrapperException((Throwable)ie);
        }
        catch (IllegalAccessException iae) {
            throw new UncheckedWrapperException((Throwable)iae);
        }
    }

    public static Collection getKeyAttributes(ObjectType type) {
        ArrayList keys = new ArrayList(1);
        Iterator it = type.getKeyProperties();
        while (it.hasNext()) {
            keys.add(it.next());
        }
        return keys;
    }

    public static Collection getKeyAttributeNames(ObjectType type) {
        Collection attrs = ACSObjectFactory.getKeyAttributes(type);
        ArrayList<String> names = new ArrayList<String>(attrs.size());
        Iterator i = attrs.iterator();
        while (i.hasNext()) {
            names.add(((Property)i.next()).getName());
        }
        return names;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

