/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.bookmarks.installer;

import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.OID;
import com.arsdigita.web.*;
import com.arsdigita.kernel.*;
import com.arsdigita.sitenode.*;
import com.arsdigita.bookmarks.*;
import com.arsdigita.bookmarks.ui.*;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.domain.DomainObject;
import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;
import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.portal.PortletType;
import com.arsdigita.portal.apportlet.AppPortletSetup;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

/**
 * <p><strong>Experimental</strong></p>
 *
 * @author <a href="mailto:jparsons@redhat.com">Jim Parsons</a>
 */
public class OldInitializer extends BaseInitializer {

    private static final Logger s_log = Logger.getLogger
        (OldInitializer.class);

    private Configuration m_conf = new Configuration();

    public OldInitializer() throws InitializationException {
        super();
        
    }

    public Configuration getConfiguration() {
        return m_conf;
    }

    public final void doStartup() {
        s_log.info("Initializing Bookmarks...");

        TransactionContext txn =
            SessionManager.getSession().getTransactionContext();

        txn.beginTxn();

            setupBookmarks();

        txn.commitTxn();

    }

    private void setupBookmarks() {

        ApplicationSetup appsetup = new ApplicationSetup(s_log);
        appsetup.setApplicationObjectType( BookmarkApplication.BASE_DATA_OBJECT_TYPE);
        appsetup.setKey("bookmarks");
        appsetup.setTitle("Bookmarks Application");
        appsetup.setDescription("Bookmarks for a Portal");
        appsetup.setDispatcherClass("com.arsdigita.bookmarks.BookmarkDispatcher");
        appsetup.setStylesheet("/packages/bookmarks/xsl/bookmarks.xsl");
        appsetup.setPortalApplication(true);
        appsetup.setInstantiator(new ACSObjectInstantiator() {
                protected DomainObject doNewInstance(DataObject dataObject) {
                    return new BookmarkApplication(dataObject);
                }
            });

        ApplicationType bmrkAppType = appsetup.run();


        AppPortletSetup setup = new AppPortletSetup(s_log);

        setup.setPortletObjectType
            (BookmarkPortlet.BASE_DATA_OBJECT_TYPE);
        setup.setTitle("Portal Bookmarks");
        setup.setDescription("Displays bookmarks for this portal.");
        setup.setProfile(PortletType.NARROW_PROFILE);
        setup.setPortalApplication(false);
        setup.setProviderApplicationType(bmrkAppType);
        setup.setInstantiator(new ACSObjectInstantiator() {
                public DomainObject doNewInstance(DataObject dataObject) {
                    return new BookmarkPortlet(dataObject);
                }
            });
        setup.run();
    }


    public final void doShutdown() {}
}
