/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.bookmarks;

import com.arsdigita.bookmarks.Bookmark;
import com.arsdigita.bookmarks.BookmarkApplication;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;
import java.math.BigDecimal;
import java.util.List;

public class PopulateBookmarks
extends AbstractPopulateApp
implements PopulateApp {
    private static final String ARGS_DESC = "1 PopulateBookmarks arg: numBookmarks";

    public void populateApp(List args) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();
        BookmarkApplication bookmarks = (BookmarkApplication)this.getApp();
        this.validateArgs(args, 1, ARGS_DESC);
        int iBookmarks = (Integer)args.get(0);
        Assert.assertTrue((iBookmarks >= 0 ? 1 : 0) != 0, (String)"iBookmarks must be >= 0");
        String sUserName = User.retrieve((BigDecimal)((BigDecimal)Utilities.getUsersIDs((int)1).get(0))).getDisplayName();
        for (int i = 0; i < iBookmarks; ++i) {
            txn.beginTxn();
            String sName = "bookmark " + i;
            String sURL = "http://redhat.com";
            Bookmark bookmark = new Bookmark(sName, sURL, sUserName);
            bookmark.setDescription("this is a bookmark");
            bookmark.setBookmarkApplication(bookmarks);
            bookmark.save();
            this.s_log.info((Object)("created bookmark " + sName));
            txn.commitTxn();
        }
    }

    public String getArgsDescription() {
        return ARGS_DESC;
    }

    public ApplicationType getAppType() {
        return ApplicationType.retrieveApplicationTypeForApplication((String)"com.arsdigita.workspace.BookmarkApplication");
    }

    protected String getPortletType() {
        return "com.arsdigita.workspace.BookmarkPortlet";
    }
}

