/*
 * Copyright (C) 2001, 2002, 2003 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 *
 */

package com.arsdigita.bookmarks.ui;


import com.arsdigita.bookmarks.util.GlobalizationUtil; 
import com.arsdigita.bookmarks.BookmarkCollection; 
import com.arsdigita.bookmarks.Bookmark; 
import com.arsdigita.bookmarks.BookmarkApplication; 

import com.arsdigita.web.Application;
import com.arsdigita.web.URL;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.portal.apportlet.AppPortlet;
import com.arsdigita.bebop.portal.AbstractPortletRenderer;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.ExternalLink;
import com.arsdigita.bebop.GridPanel;
import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

public class BookmarkPortlet extends AppPortlet {
    public static final String versionId =
        "$Id: //apps/bookmarks/dev/src/com/arsdigita/bookmarks/ui/BookmarkPortlet.java#6 $" +
        "$Author: dennis $" +
        "$DateTime: 2003/08/15 13:46:34 $";

    private static final Logger s_log = Logger.getLogger(BookmarkPortlet.class);

    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.workspace.BookmarkPortlet";

    protected String getBaseDataObjectType() {
        return BASE_DATA_OBJECT_TYPE;
    }

    public BookmarkPortlet(DataObject dataObject) {
        super(dataObject);
    }

    public String getZoomURL() {
        return (URL.getDispatcherPath() + getParentApplication().getPrimaryURL());
    }

    protected AbstractPortletRenderer doGetPortletRenderer() {
        return new BookmarkPortletRenderer(this);
    }
}

class BookmarkPortletRenderer extends AbstractPortletRenderer {
    private BookmarkPortlet m_portlet;

    public BookmarkPortletRenderer
        (BookmarkPortlet portlet) {
        m_portlet = portlet;
    }

    protected void generateBodyXML(PageState pageState, Element parentElement) {
        BookmarkApplication bmrkapp = 
                 (BookmarkApplication)m_portlet.getParentApplication();

        // Variables used cursorwise.
        int counter;
        String name = null;
        String url = null;

        BookmarkCollection bmrks =
            bmrkapp.getBookmarks();

        GridPanel innerPanel = new GridPanel(1);

        for (counter = 0; bmrks.next(); counter++) {
            name = bmrks.getName();
            url = bmrks.getURL();
            innerPanel.add(new ExternalLink(name, url));
        }

        if (counter == 0) {
            innerPanel.add(new Label(GlobalizationUtil.globalize("bookmarks.ui.none")));
        }

        innerPanel.generateXML(pageState, parentElement);
    }
}
