/*
 * Copyright (C) 2001, 2002 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of
 * the License at http://www.redhat.com/licenses/ccmpl.html
 *
 * Software distributed under the License is distributed on an "AS
 * IS" basis, WITHOUT WARRANTY OF ANY KIND, either express or
 * implied. See the License for the specific language governing
 * rights and limitations under the License.
 */
 
package com.arsdigita.bookmarks;

import java.math.BigDecimal;
import java.util.List;

import com.arsdigita.bookmarks.ui.BookmarkPortlet;
import com.arsdigita.kernel.User;
import com.arsdigita.persistence.Session;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.persistence.TransactionContext;
import com.arsdigita.populate.Utilities;
import com.arsdigita.populate.apps.AbstractPopulateApp;
import com.arsdigita.populate.apps.PopulateApp;
import com.arsdigita.util.Assert;
import com.arsdigita.web.ApplicationType;

/**
 * @author bche
 */
public class PopulateBookmarks extends AbstractPopulateApp implements PopulateApp {
    private static final String ARGS_DESC = "1 PopulateBookmarks arg: numBookmarks";

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#populateApp(java.util.List)
     */
    public void populateApp(List args) {
        Session ses = SessionManager.getSession();
        TransactionContext txn = ses.getTransactionContext();

        BookmarkApplication bookmarks = (BookmarkApplication) getApp();

        //validate the arguments
        this.validateArgs(args, 1, ARGS_DESC);

        int iBookmarks = ((Integer)args.get(0)).intValue();        
        Assert.assertTrue(iBookmarks >= 0, "iBookmarks must be >= 0");     
        
        //get a user name
        String sUserName = User.retrieve((BigDecimal)Utilities.getUsersIDs(1).get(0)).getDisplayName();
        
        for (int i=0; i < iBookmarks; i++) {
            txn.beginTxn();
            
            String sName = "bookmark " + i;
            String sURL = "http://redhat.com";
            Bookmark bookmark = new Bookmark(sName, sURL, sUserName);
            bookmark.setDescription("this is a bookmark");
            bookmark.setBookmarkApplication(bookmarks);
            bookmark.save();
            
            s_log.info("created bookmark " + sName);
            
            txn.commitTxn();
        }

    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getArgsDescription()
     */
    public String getArgsDescription() {
        return ARGS_DESC;
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.PopulateApp#getAppType()
     */
    public ApplicationType getAppType() {
        return ApplicationType.retrieveApplicationTypeForApplication(BookmarkApplication.BASE_DATA_OBJECT_TYPE);
    }

    /* (non-Javadoc)
     * @see com.arsdigita.populate.apps.AbstractPopulateApp#getPortletType()
     */
    protected String getPortletType() {
        return BookmarkPortlet.BASE_DATA_OBJECT_TYPE;
    }

}
