# Compute locations from <prefix>/@{LIBRARY_DIR@/cmake/lapacke-<v>/<self>.cmake
get_filename_component(_CBLAS_SELF_DIR "${CMAKE_CURRENT_LIST_FILE}" PATH)

# Load the LAPACK package with which we were built.
set(LAPACK_DIR "/usr/lib64/cmake/lapack-reference-3.12.0")
find_package(LAPACK NO_MODULE)

# Load lapacke targets from the install tree.
if(NOT TARGET cblas-reference)
  include(${_CBLAS_SELF_DIR}/cblas-reference-targets.cmake)
endif()

# Report lapacke header search locations.
set(CBLAS_INCLUDE_DIRS /usr/include/lapack-reference)

# Report lapacke libraries.
set(CBLAS_LIBRARIES cblas-reference)

unset(_CBLAS_SELF_DIR)
