from chardet.enums import CharacterCategory, SequenceLikelihood
from chardet.sbcharsetprober import SingleByteCharSetModel

GREEK_LANG_MODEL = {
    56: {  # 'Ά'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.NEGATIVE,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.NEGATIVE,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.NEGATIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.LIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.NEGATIVE,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    54: {  # 'Έ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.NEGATIVE,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.LIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.NEGATIVE,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    60: {  # 'Ή'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.NEGATIVE,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.NEGATIVE,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.NEGATIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.NEGATIVE,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.NEGATIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.NEGATIVE,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.NEGATIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.NEGATIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.NEGATIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.NEGATIVE,  # 'ω'
        18: SequenceLikelihood.NEGATIVE,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    61: {  # 'Ί'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.NEGATIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.NEGATIVE,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    55: {  # 'Ό'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.NEGATIVE,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.NEGATIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.NEGATIVE,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.NEGATIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.NEGATIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.LIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.NEGATIVE,  # 'ω'
        18: SequenceLikelihood.NEGATIVE,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    62: {  # 'Ύ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.NEGATIVE,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.NEGATIVE,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.NEGATIVE,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.NEGATIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.NEGATIVE,  # 'η'
        25: SequenceLikelihood.NEGATIVE,  # 'θ'
        4: SequenceLikelihood.NEGATIVE,  # 'ι'
        9: SequenceLikelihood.NEGATIVE,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.NEGATIVE,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.NEGATIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.NEGATIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.NEGATIVE,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.NEGATIVE,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    63: {  # 'Ώ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.NEGATIVE,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.NEGATIVE,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.NEGATIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.NEGATIVE,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.NEGATIVE,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.NEGATIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.NEGATIVE,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.NEGATIVE,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.NEGATIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.NEGATIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.NEGATIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.NEGATIVE,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    30: {  # 'Α'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.LIKELY,  # 'Β'
        44: SequenceLikelihood.LIKELY,  # 'Γ'
        42: SequenceLikelihood.LIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.LIKELY,  # 'Θ'
        40: SequenceLikelihood.POSITIVE,  # 'Ι'
        38: SequenceLikelihood.LIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.POSITIVE,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.LIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.POSITIVE,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.LIKELY,  # 'Υ'
        52: SequenceLikelihood.LIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.LIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.LIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.NEGATIVE,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    49: {  # 'Β'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.NEGATIVE,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.NEGATIVE,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    44: {  # 'Γ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.NEGATIVE,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    42: {  # 'Δ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    31: {  # 'Ε'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.LIKELY,  # 'Γ'
        42: SequenceLikelihood.LIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.LIKELY,  # 'Θ'
        40: SequenceLikelihood.POSITIVE,  # 'Ι'
        38: SequenceLikelihood.LIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.LIKELY,  # 'Ν'
        58: SequenceLikelihood.LIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.LIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.POSITIVE,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.LIKELY,  # 'Υ'
        52: SequenceLikelihood.LIKELY,  # 'Φ'
        50: SequenceLikelihood.LIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.LIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.LIKELY,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    57: {  # 'Ζ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.NEGATIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.NEGATIVE,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.NEGATIVE,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.NEGATIVE,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    41: {  # 'Η'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.LIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.LIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.POSITIVE,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.NEGATIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.NEGATIVE,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    51: {  # 'Θ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.NEGATIVE,  # 'β'
        20: SequenceLikelihood.NEGATIVE,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.NEGATIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.NEGATIVE,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    40: {  # 'Ι'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.POSITIVE,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.LIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.LIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.POSITIVE,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.LIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.POSITIVE,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.LIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.NEGATIVE,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    38: {  # 'Κ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.POSITIVE,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.LIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.POSITIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.LIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.LIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.NEGATIVE,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    47: {  # 'Λ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.LIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.NEGATIVE,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    39: {  # 'Μ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.POSITIVE,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.LIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    43: {  # 'Ν'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.LIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.LIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.NEGATIVE,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    58: {  # 'Ξ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.NEGATIVE,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.NEGATIVE,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.NEGATIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.NEGATIVE,  # 'λ'
        14: SequenceLikelihood.NEGATIVE,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.NEGATIVE,  # 'π'
        8: SequenceLikelihood.NEGATIVE,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.NEGATIVE,  # 'σ'
        3: SequenceLikelihood.NEGATIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.NEGATIVE,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    36: {  # 'Ο'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.LIKELY,  # 'Γ'
        42: SequenceLikelihood.LIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.LIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.LIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.LIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.POSITIVE,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.POSITIVE,  # 'Υ'
        52: SequenceLikelihood.LIKELY,  # 'Φ'
        50: SequenceLikelihood.LIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    34: {  # 'Π'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.POSITIVE,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.POSITIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    46: {  # 'Ρ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.LIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.POSITIVE,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.POSITIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.LIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.NEGATIVE,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.NEGATIVE,  # 'ς'
        7: SequenceLikelihood.NEGATIVE,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    33: {  # 'Σ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.LIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.LIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.LIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.LIKELY,  # 'Σ'
        37: SequenceLikelihood.POSITIVE,  # 'Τ'
        48: SequenceLikelihood.LIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.LIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.LIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    37: {  # 'Τ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.POSITIVE,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.POSITIVE,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.POSITIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.LIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.LIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.LIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    48: {  # 'Υ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.LIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.LIKELY,  # 'Λ'
        39: SequenceLikelihood.LIKELY,  # 'Μ'
        43: SequenceLikelihood.LIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.LIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.LIKELY,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.NEGATIVE,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.LIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.NEGATIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.NEGATIVE,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    52: {  # 'Φ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.NEGATIVE,  # 'β'
        20: SequenceLikelihood.NEGATIVE,  # 'γ'
        21: SequenceLikelihood.NEGATIVE,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    50: {  # 'Χ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.LIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.LIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.LIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.LIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.NEGATIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    59: {  # 'Ψ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.NEGATIVE,  # 'β'
        20: SequenceLikelihood.NEGATIVE,  # 'γ'
        21: SequenceLikelihood.NEGATIVE,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.NEGATIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.NEGATIVE,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.NEGATIVE,  # 'μ'
        6: SequenceLikelihood.NEGATIVE,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.NEGATIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    53: {  # 'Ω'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.LIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.LIKELY,  # 'Ρ'
        33: SequenceLikelihood.LIKELY,  # 'Σ'
        37: SequenceLikelihood.LIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.NEGATIVE,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.NEGATIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.LIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    17: {  # 'ά'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.POSITIVE,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.POSITIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.POSITIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    19: {  # 'έ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.NEGATIVE,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.NEGATIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.NEGATIVE,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.POSITIVE,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.NEGATIVE,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    23: {  # 'ή'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.LIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.LIKELY,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    16: {  # 'ί'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.POSITIVE,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    1: {  # 'α'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.POSITIVE,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.POSITIVE,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.POSITIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    29: {  # 'β'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.NEGATIVE,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.NEGATIVE,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.NEGATIVE,  # 'Π'
        46: SequenceLikelihood.NEGATIVE,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.NEGATIVE,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.LIKELY,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    20: {  # 'γ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.NEGATIVE,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    21: {  # 'δ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.NEGATIVE,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.NEGATIVE,  # 'Μ'
        43: SequenceLikelihood.NEGATIVE,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.NEGATIVE,  # 'Ρ'
        33: SequenceLikelihood.NEGATIVE,  # 'Σ'
        37: SequenceLikelihood.NEGATIVE,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.NEGATIVE,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    5: {  # 'ε'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.POSITIVE,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.POSITIVE,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    35: {  # 'ζ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.NEGATIVE,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.NEGATIVE,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    11: {  # 'η'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.LIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.LIKELY,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    25: {  # 'θ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.NEGATIVE,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.NEGATIVE,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.NEGATIVE,  # 'Ρ'
        33: SequenceLikelihood.NEGATIVE,  # 'Σ'
        37: SequenceLikelihood.NEGATIVE,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    4: {  # 'ι'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.POSITIVE,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.POSITIVE,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    9: {  # 'κ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    15: {  # 'λ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.LIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.LIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    14: {  # 'μ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.POSITIVE,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    6: {  # 'ν'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.LIKELY,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    32: {  # 'ξ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.NEGATIVE,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.NEGATIVE,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.NEGATIVE,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.NEGATIVE,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.NEGATIVE,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.NEGATIVE,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    2: {  # 'ο'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.POSITIVE,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    10: {  # 'π'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.LIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    8: {  # 'ρ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.LIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.LIKELY,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    12: {  # 'ς'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.UNLIKELY,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    7: {  # 'σ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.NEGATIVE,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.LIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    3: {  # 'τ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.LIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.LIKELY,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.LIKELY,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.POSITIVE,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    13: {  # 'υ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.UNLIKELY,  # 'Ό'
        62: SequenceLikelihood.UNLIKELY,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.LIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.POSITIVE,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.POSITIVE,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.LIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    27: {  # 'φ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.NEGATIVE,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.LIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.POSITIVE,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.LIKELY,  # 'ώ'
    },
    24: {  # 'χ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.NEGATIVE,  # 'Ι'
        38: SequenceLikelihood.NEGATIVE,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.NEGATIVE,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.POSITIVE,  # 'ά'
        19: SequenceLikelihood.POSITIVE,  # 'έ'
        23: SequenceLikelihood.POSITIVE,  # 'ή'
        16: SequenceLikelihood.POSITIVE,  # 'ί'
        1: SequenceLikelihood.POSITIVE,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.POSITIVE,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.POSITIVE,  # 'ω'
        18: SequenceLikelihood.POSITIVE,  # 'ό'
        26: SequenceLikelihood.LIKELY,  # 'ύ'
        28: SequenceLikelihood.POSITIVE,  # 'ώ'
    },
    45: {  # 'ψ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.NEGATIVE,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.NEGATIVE,  # 'Δ'
        31: SequenceLikelihood.NEGATIVE,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.NEGATIVE,  # 'Θ'
        40: SequenceLikelihood.NEGATIVE,  # 'Ι'
        38: SequenceLikelihood.NEGATIVE,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.NEGATIVE,  # 'Μ'
        43: SequenceLikelihood.NEGATIVE,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.NEGATIVE,  # 'Ο'
        34: SequenceLikelihood.NEGATIVE,  # 'Π'
        46: SequenceLikelihood.NEGATIVE,  # 'Ρ'
        33: SequenceLikelihood.NEGATIVE,  # 'Σ'
        37: SequenceLikelihood.NEGATIVE,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.NEGATIVE,  # 'Φ'
        50: SequenceLikelihood.NEGATIVE,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.UNLIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.NEGATIVE,  # 'ζ'
        11: SequenceLikelihood.POSITIVE,  # 'η'
        25: SequenceLikelihood.UNLIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.NEGATIVE,  # 'κ'
        15: SequenceLikelihood.UNLIKELY,  # 'λ'
        14: SequenceLikelihood.UNLIKELY,  # 'μ'
        6: SequenceLikelihood.UNLIKELY,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.UNLIKELY,  # 'π'
        8: SequenceLikelihood.UNLIKELY,  # 'ρ'
        12: SequenceLikelihood.UNLIKELY,  # 'ς'
        7: SequenceLikelihood.UNLIKELY,  # 'σ'
        3: SequenceLikelihood.UNLIKELY,  # 'τ'
        13: SequenceLikelihood.LIKELY,  # 'υ'
        27: SequenceLikelihood.NEGATIVE,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    22: {  # 'ω'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.UNLIKELY,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.NEGATIVE,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.NEGATIVE,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.LIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.LIKELY,  # 'ή'
        16: SequenceLikelihood.LIKELY,  # 'ί'
        1: SequenceLikelihood.LIKELY,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.UNLIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    18: {  # 'ό'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.UNLIKELY,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.NEGATIVE,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.POSITIVE,  # 'δ'
        5: SequenceLikelihood.LIKELY,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.LIKELY,  # 'ι'
        9: SequenceLikelihood.POSITIVE,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.LIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.POSITIVE,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
    26: {  # 'ύ'
        56: SequenceLikelihood.UNLIKELY,  # 'Ά'
        54: SequenceLikelihood.UNLIKELY,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.UNLIKELY,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.UNLIKELY,  # 'Ζ'
        41: SequenceLikelihood.UNLIKELY,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.UNLIKELY,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.UNLIKELY,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.UNLIKELY,  # 'Ν'
        58: SequenceLikelihood.UNLIKELY,  # 'Ξ'
        36: SequenceLikelihood.UNLIKELY,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.UNLIKELY,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.UNLIKELY,  # 'Χ'
        59: SequenceLikelihood.UNLIKELY,  # 'Ψ'
        53: SequenceLikelihood.UNLIKELY,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.UNLIKELY,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.NEGATIVE,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.LIKELY,  # 'β'
        20: SequenceLikelihood.POSITIVE,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.POSITIVE,  # 'ε'
        35: SequenceLikelihood.LIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.POSITIVE,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.LIKELY,  # 'κ'
        15: SequenceLikelihood.POSITIVE,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.LIKELY,  # 'ξ'
        2: SequenceLikelihood.POSITIVE,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.LIKELY,  # 'φ'
        24: SequenceLikelihood.POSITIVE,  # 'χ'
        45: SequenceLikelihood.LIKELY,  # 'ψ'
        22: SequenceLikelihood.LIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.UNLIKELY,  # 'ύ'
        28: SequenceLikelihood.NEGATIVE,  # 'ώ'
    },
    28: {  # 'ώ'
        56: SequenceLikelihood.NEGATIVE,  # 'Ά'
        54: SequenceLikelihood.NEGATIVE,  # 'Έ'
        60: SequenceLikelihood.NEGATIVE,  # 'Ή'
        61: SequenceLikelihood.NEGATIVE,  # 'Ί'
        55: SequenceLikelihood.NEGATIVE,  # 'Ό'
        62: SequenceLikelihood.NEGATIVE,  # 'Ύ'
        63: SequenceLikelihood.NEGATIVE,  # 'Ώ'
        30: SequenceLikelihood.UNLIKELY,  # 'Α'
        49: SequenceLikelihood.UNLIKELY,  # 'Β'
        44: SequenceLikelihood.NEGATIVE,  # 'Γ'
        42: SequenceLikelihood.UNLIKELY,  # 'Δ'
        31: SequenceLikelihood.UNLIKELY,  # 'Ε'
        57: SequenceLikelihood.NEGATIVE,  # 'Ζ'
        41: SequenceLikelihood.NEGATIVE,  # 'Η'
        51: SequenceLikelihood.UNLIKELY,  # 'Θ'
        40: SequenceLikelihood.NEGATIVE,  # 'Ι'
        38: SequenceLikelihood.UNLIKELY,  # 'Κ'
        47: SequenceLikelihood.NEGATIVE,  # 'Λ'
        39: SequenceLikelihood.UNLIKELY,  # 'Μ'
        43: SequenceLikelihood.NEGATIVE,  # 'Ν'
        58: SequenceLikelihood.NEGATIVE,  # 'Ξ'
        36: SequenceLikelihood.NEGATIVE,  # 'Ο'
        34: SequenceLikelihood.UNLIKELY,  # 'Π'
        46: SequenceLikelihood.UNLIKELY,  # 'Ρ'
        33: SequenceLikelihood.UNLIKELY,  # 'Σ'
        37: SequenceLikelihood.UNLIKELY,  # 'Τ'
        48: SequenceLikelihood.NEGATIVE,  # 'Υ'
        52: SequenceLikelihood.UNLIKELY,  # 'Φ'
        50: SequenceLikelihood.NEGATIVE,  # 'Χ'
        59: SequenceLikelihood.NEGATIVE,  # 'Ψ'
        53: SequenceLikelihood.NEGATIVE,  # 'Ω'
        17: SequenceLikelihood.UNLIKELY,  # 'ά'
        19: SequenceLikelihood.NEGATIVE,  # 'έ'
        23: SequenceLikelihood.UNLIKELY,  # 'ή'
        16: SequenceLikelihood.UNLIKELY,  # 'ί'
        1: SequenceLikelihood.UNLIKELY,  # 'α'
        29: SequenceLikelihood.UNLIKELY,  # 'β'
        20: SequenceLikelihood.UNLIKELY,  # 'γ'
        21: SequenceLikelihood.LIKELY,  # 'δ'
        5: SequenceLikelihood.UNLIKELY,  # 'ε'
        35: SequenceLikelihood.UNLIKELY,  # 'ζ'
        11: SequenceLikelihood.LIKELY,  # 'η'
        25: SequenceLikelihood.LIKELY,  # 'θ'
        4: SequenceLikelihood.UNLIKELY,  # 'ι'
        9: SequenceLikelihood.UNLIKELY,  # 'κ'
        15: SequenceLikelihood.LIKELY,  # 'λ'
        14: SequenceLikelihood.POSITIVE,  # 'μ'
        6: SequenceLikelihood.POSITIVE,  # 'ν'
        32: SequenceLikelihood.UNLIKELY,  # 'ξ'
        2: SequenceLikelihood.UNLIKELY,  # 'ο'
        10: SequenceLikelihood.POSITIVE,  # 'π'
        8: SequenceLikelihood.POSITIVE,  # 'ρ'
        12: SequenceLikelihood.POSITIVE,  # 'ς'
        7: SequenceLikelihood.POSITIVE,  # 'σ'
        3: SequenceLikelihood.POSITIVE,  # 'τ'
        13: SequenceLikelihood.UNLIKELY,  # 'υ'
        27: SequenceLikelihood.UNLIKELY,  # 'φ'
        24: SequenceLikelihood.UNLIKELY,  # 'χ'
        45: SequenceLikelihood.UNLIKELY,  # 'ψ'
        22: SequenceLikelihood.UNLIKELY,  # 'ω'
        18: SequenceLikelihood.UNLIKELY,  # 'ό'
        26: SequenceLikelihood.NEGATIVE,  # 'ύ'
        28: SequenceLikelihood.UNLIKELY,  # 'ώ'
    },
}

# Character Mapping Table(s):
CP737_GREEK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 30,  # 'Α'
    129: 49,  # 'Β'
    130: 44,  # 'Γ'
    131: 42,  # 'Δ'
    132: 31,  # 'Ε'
    133: 57,  # 'Ζ'
    134: 41,  # 'Η'
    135: 51,  # 'Θ'
    136: 40,  # 'Ι'
    137: 38,  # 'Κ'
    138: 47,  # 'Λ'
    139: 39,  # 'Μ'
    140: 43,  # 'Ν'
    141: 58,  # 'Ξ'
    142: 36,  # 'Ο'
    143: 34,  # 'Π'
    144: 46,  # 'Ρ'
    145: 33,  # 'Σ'
    146: 37,  # 'Τ'
    147: 48,  # 'Υ'
    148: 52,  # 'Φ'
    149: 50,  # 'Χ'
    150: 59,  # 'Ψ'
    151: 53,  # 'Ω'
    152: 1,  # 'α'
    153: 29,  # 'β'
    154: 20,  # 'γ'
    155: 21,  # 'δ'
    156: 5,  # 'ε'
    157: 35,  # 'ζ'
    158: 11,  # 'η'
    159: 25,  # 'θ'
    160: 4,  # 'ι'
    161: 9,  # 'κ'
    162: 15,  # 'λ'
    163: 14,  # 'μ'
    164: 6,  # 'ν'
    165: 32,  # 'ξ'
    166: 2,  # 'ο'
    167: 10,  # 'π'
    168: 8,  # 'ρ'
    169: 7,  # 'σ'
    170: 12,  # 'ς'
    171: 3,  # 'τ'
    172: 13,  # 'υ'
    173: 27,  # 'φ'
    174: 24,  # 'χ'
    175: 45,  # 'ψ'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: CharacterCategory.SYMBOL,  # '╡'
    182: CharacterCategory.SYMBOL,  # '╢'
    183: CharacterCategory.SYMBOL,  # '╖'
    184: CharacterCategory.SYMBOL,  # '╕'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: CharacterCategory.SYMBOL,  # '╜'
    190: CharacterCategory.SYMBOL,  # '╛'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: CharacterCategory.SYMBOL,  # '╞'
    199: CharacterCategory.SYMBOL,  # '╟'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: CharacterCategory.SYMBOL,  # '╧'
    208: CharacterCategory.SYMBOL,  # '╨'
    209: CharacterCategory.SYMBOL,  # '╤'
    210: CharacterCategory.SYMBOL,  # '╥'
    211: CharacterCategory.SYMBOL,  # '╙'
    212: CharacterCategory.SYMBOL,  # '╘'
    213: CharacterCategory.SYMBOL,  # '╒'
    214: CharacterCategory.SYMBOL,  # '╓'
    215: CharacterCategory.SYMBOL,  # '╫'
    216: CharacterCategory.SYMBOL,  # '╪'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: CharacterCategory.SYMBOL,  # '▌'
    222: CharacterCategory.SYMBOL,  # '▐'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 22,  # 'ω'
    225: 17,  # 'ά'
    226: 19,  # 'έ'
    227: 23,  # 'ή'
    228: 0,  # 'ϊ'
    229: 16,  # 'ί'
    230: 18,  # 'ό'
    231: 26,  # 'ύ'
    232: 0,  # 'ϋ'
    233: 28,  # 'ώ'
    234: 56,  # 'Ά'
    235: 54,  # 'Έ'
    236: 60,  # 'Ή'
    237: 61,  # 'Ί'
    238: 55,  # 'Ό'
    239: 62,  # 'Ύ'
    240: 63,  # 'Ώ'
    241: CharacterCategory.SYMBOL,  # '±'
    242: CharacterCategory.SYMBOL,  # '≥'
    243: CharacterCategory.SYMBOL,  # '≤'
    244: 0,  # 'Ϊ'
    245: 0,  # 'Ϋ'
    246: CharacterCategory.SYMBOL,  # '÷'
    247: CharacterCategory.SYMBOL,  # '≈'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '∙'
    250: CharacterCategory.SYMBOL,  # '·'
    251: CharacterCategory.SYMBOL,  # '√'
    252: 0,  # 'ⁿ'
    253: CharacterCategory.DIGIT,  # '²'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP737_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="CP737",
    language="Greek",
    char_to_order_map=CP737_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.9505466431988192,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)

CP869_GREEK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.UNDEFINED,  # None
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.UNDEFINED,  # None
    131: CharacterCategory.UNDEFINED,  # None
    132: CharacterCategory.UNDEFINED,  # None
    133: CharacterCategory.UNDEFINED,  # None
    134: 56,  # 'Ά'
    135: CharacterCategory.UNDEFINED,  # None
    136: CharacterCategory.SYMBOL,  # '·'
    137: CharacterCategory.SYMBOL,  # '¬'
    138: CharacterCategory.SYMBOL,  # '¦'
    139: CharacterCategory.SYMBOL,  # '‘'
    140: CharacterCategory.SYMBOL,  # '’'
    141: 54,  # 'Έ'
    142: CharacterCategory.SYMBOL,  # '―'
    143: 60,  # 'Ή'
    144: 61,  # 'Ί'
    145: 0,  # 'Ϊ'
    146: 55,  # 'Ό'
    147: CharacterCategory.UNDEFINED,  # None
    148: CharacterCategory.UNDEFINED,  # None
    149: 62,  # 'Ύ'
    150: 0,  # 'Ϋ'
    151: CharacterCategory.SYMBOL,  # '©'
    152: 63,  # 'Ώ'
    153: CharacterCategory.DIGIT,  # '²'
    154: CharacterCategory.DIGIT,  # '³'
    155: 17,  # 'ά'
    156: CharacterCategory.SYMBOL,  # '£'
    157: 19,  # 'έ'
    158: 23,  # 'ή'
    159: 16,  # 'ί'
    160: 0,  # 'ϊ'
    161: 0,  # 'ΐ'
    162: 18,  # 'ό'
    163: 26,  # 'ύ'
    164: 30,  # 'Α'
    165: 49,  # 'Β'
    166: 44,  # 'Γ'
    167: 42,  # 'Δ'
    168: 31,  # 'Ε'
    169: 57,  # 'Ζ'
    170: 41,  # 'Η'
    171: CharacterCategory.DIGIT,  # '½'
    172: 51,  # 'Θ'
    173: 40,  # 'Ι'
    174: CharacterCategory.SYMBOL,  # '«'
    175: CharacterCategory.SYMBOL,  # '»'
    176: CharacterCategory.SYMBOL,  # '░'
    177: CharacterCategory.SYMBOL,  # '▒'
    178: CharacterCategory.SYMBOL,  # '▓'
    179: CharacterCategory.SYMBOL,  # '│'
    180: CharacterCategory.SYMBOL,  # '┤'
    181: 38,  # 'Κ'
    182: 47,  # 'Λ'
    183: 39,  # 'Μ'
    184: 43,  # 'Ν'
    185: CharacterCategory.SYMBOL,  # '╣'
    186: CharacterCategory.SYMBOL,  # '║'
    187: CharacterCategory.SYMBOL,  # '╗'
    188: CharacterCategory.SYMBOL,  # '╝'
    189: 58,  # 'Ξ'
    190: 36,  # 'Ο'
    191: CharacterCategory.SYMBOL,  # '┐'
    192: CharacterCategory.SYMBOL,  # '└'
    193: CharacterCategory.SYMBOL,  # '┴'
    194: CharacterCategory.SYMBOL,  # '┬'
    195: CharacterCategory.SYMBOL,  # '├'
    196: CharacterCategory.SYMBOL,  # '─'
    197: CharacterCategory.SYMBOL,  # '┼'
    198: 34,  # 'Π'
    199: 46,  # 'Ρ'
    200: CharacterCategory.SYMBOL,  # '╚'
    201: CharacterCategory.SYMBOL,  # '╔'
    202: CharacterCategory.SYMBOL,  # '╩'
    203: CharacterCategory.SYMBOL,  # '╦'
    204: CharacterCategory.SYMBOL,  # '╠'
    205: CharacterCategory.SYMBOL,  # '═'
    206: CharacterCategory.SYMBOL,  # '╬'
    207: 33,  # 'Σ'
    208: 37,  # 'Τ'
    209: 48,  # 'Υ'
    210: 52,  # 'Φ'
    211: 50,  # 'Χ'
    212: 59,  # 'Ψ'
    213: 53,  # 'Ω'
    214: 1,  # 'α'
    215: 29,  # 'β'
    216: 20,  # 'γ'
    217: CharacterCategory.SYMBOL,  # '┘'
    218: CharacterCategory.SYMBOL,  # '┌'
    219: CharacterCategory.SYMBOL,  # '█'
    220: CharacterCategory.SYMBOL,  # '▄'
    221: 21,  # 'δ'
    222: 5,  # 'ε'
    223: CharacterCategory.SYMBOL,  # '▀'
    224: 35,  # 'ζ'
    225: 11,  # 'η'
    226: 25,  # 'θ'
    227: 4,  # 'ι'
    228: 9,  # 'κ'
    229: 15,  # 'λ'
    230: 14,  # 'μ'
    231: 6,  # 'ν'
    232: 32,  # 'ξ'
    233: 2,  # 'ο'
    234: 10,  # 'π'
    235: 8,  # 'ρ'
    236: 7,  # 'σ'
    237: 12,  # 'ς'
    238: 3,  # 'τ'
    239: CharacterCategory.SYMBOL,  # '΄'
    240: CharacterCategory.CONTROL,  # '\xad'
    241: CharacterCategory.SYMBOL,  # '±'
    242: 13,  # 'υ'
    243: 27,  # 'φ'
    244: 24,  # 'χ'
    245: CharacterCategory.SYMBOL,  # '§'
    246: 45,  # 'ψ'
    247: CharacterCategory.SYMBOL,  # '΅'
    248: CharacterCategory.SYMBOL,  # '°'
    249: CharacterCategory.SYMBOL,  # '¨'
    250: 22,  # 'ω'
    251: 0,  # 'ϋ'
    252: 0,  # 'ΰ'
    253: 28,  # 'ώ'
    254: CharacterCategory.SYMBOL,  # '■'
    255: CharacterCategory.CONTROL,  # '\xa0'
}

CP869_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="CP869",
    language="Greek",
    char_to_order_map=CP869_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.9505466431988192,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)

CP875_GREEK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x9c'
    5: CharacterCategory.CONTROL,  # '\t'
    6: CharacterCategory.CONTROL,  # '\x86'
    7: CharacterCategory.CONTROL,  # '\x7f'
    8: CharacterCategory.CONTROL,  # '\x97'
    9: CharacterCategory.CONTROL,  # '\x8d'
    10: CharacterCategory.CONTROL,  # '\x8e'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x9d'
    21: CharacterCategory.CONTROL,  # '\x85'
    22: CharacterCategory.CONTROL,  # '\x08'
    23: CharacterCategory.CONTROL,  # '\x87'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x92'
    27: CharacterCategory.CONTROL,  # '\x8f'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # '\x80'
    33: CharacterCategory.CONTROL,  # '\x81'
    34: CharacterCategory.CONTROL,  # '\x82'
    35: CharacterCategory.CONTROL,  # '\x83'
    36: CharacterCategory.CONTROL,  # '\x84'
    37: CharacterCategory.LINE_BREAK,  # '\n'
    38: CharacterCategory.CONTROL,  # '\x17'
    39: CharacterCategory.CONTROL,  # '\x1b'
    40: CharacterCategory.CONTROL,  # '\x88'
    41: CharacterCategory.CONTROL,  # '\x89'
    42: CharacterCategory.CONTROL,  # '\x8a'
    43: CharacterCategory.CONTROL,  # '\x8b'
    44: CharacterCategory.CONTROL,  # '\x8c'
    45: CharacterCategory.CONTROL,  # '\x05'
    46: CharacterCategory.CONTROL,  # '\x06'
    47: CharacterCategory.CONTROL,  # '\x07'
    48: CharacterCategory.CONTROL,  # '\x90'
    49: CharacterCategory.CONTROL,  # '\x91'
    50: CharacterCategory.CONTROL,  # '\x16'
    51: CharacterCategory.CONTROL,  # '\x93'
    52: CharacterCategory.CONTROL,  # '\x94'
    53: CharacterCategory.CONTROL,  # '\x95'
    54: CharacterCategory.CONTROL,  # '\x96'
    55: CharacterCategory.CONTROL,  # '\x04'
    56: CharacterCategory.CONTROL,  # '\x98'
    57: CharacterCategory.CONTROL,  # '\x99'
    58: CharacterCategory.CONTROL,  # '\x9a'
    59: CharacterCategory.CONTROL,  # '\x9b'
    60: CharacterCategory.CONTROL,  # '\x14'
    61: CharacterCategory.CONTROL,  # '\x15'
    62: CharacterCategory.CONTROL,  # '\x9e'
    63: CharacterCategory.CONTROL,  # '\x1a'
    64: CharacterCategory.CONTROL,  # ' '
    65: 30,  # 'Α'
    66: 49,  # 'Β'
    67: 44,  # 'Γ'
    68: 42,  # 'Δ'
    69: 31,  # 'Ε'
    70: 57,  # 'Ζ'
    71: 41,  # 'Η'
    72: 51,  # 'Θ'
    73: 40,  # 'Ι'
    74: CharacterCategory.SYMBOL,  # '['
    75: CharacterCategory.SYMBOL,  # '.'
    76: CharacterCategory.SYMBOL,  # '<'
    77: CharacterCategory.SYMBOL,  # '('
    78: CharacterCategory.SYMBOL,  # '+'
    79: CharacterCategory.SYMBOL,  # '!'
    80: CharacterCategory.SYMBOL,  # '&'
    81: 38,  # 'Κ'
    82: 47,  # 'Λ'
    83: 39,  # 'Μ'
    84: 43,  # 'Ν'
    85: 58,  # 'Ξ'
    86: 36,  # 'Ο'
    87: 34,  # 'Π'
    88: 46,  # 'Ρ'
    89: 33,  # 'Σ'
    90: CharacterCategory.SYMBOL,  # ']'
    91: CharacterCategory.SYMBOL,  # '$'
    92: CharacterCategory.SYMBOL,  # '*'
    93: CharacterCategory.SYMBOL,  # ')'
    94: CharacterCategory.SYMBOL,  # ';'
    95: CharacterCategory.SYMBOL,  # '^'
    96: CharacterCategory.SYMBOL,  # '-'
    97: CharacterCategory.SYMBOL,  # '/'
    98: 37,  # 'Τ'
    99: 48,  # 'Υ'
    100: 52,  # 'Φ'
    101: 50,  # 'Χ'
    102: 59,  # 'Ψ'
    103: 53,  # 'Ω'
    104: 0,  # 'Ϊ'
    105: 0,  # 'Ϋ'
    106: CharacterCategory.SYMBOL,  # '|'
    107: CharacterCategory.SYMBOL,  # ','
    108: CharacterCategory.SYMBOL,  # '%'
    109: CharacterCategory.SYMBOL,  # '_'
    110: CharacterCategory.SYMBOL,  # '>'
    111: CharacterCategory.SYMBOL,  # '?'
    112: CharacterCategory.SYMBOL,  # '¨'
    113: 56,  # 'Ά'
    114: 54,  # 'Έ'
    115: 60,  # 'Ή'
    116: CharacterCategory.CONTROL,  # '\xa0'
    117: 61,  # 'Ί'
    118: 55,  # 'Ό'
    119: 62,  # 'Ύ'
    120: 63,  # 'Ώ'
    121: CharacterCategory.SYMBOL,  # '`'
    122: CharacterCategory.SYMBOL,  # ':'
    123: CharacterCategory.SYMBOL,  # '#'
    124: CharacterCategory.SYMBOL,  # '@'
    125: CharacterCategory.SYMBOL,  # "'"
    126: CharacterCategory.SYMBOL,  # '='
    127: CharacterCategory.SYMBOL,  # '"'
    128: CharacterCategory.SYMBOL,  # '΅'
    129: 0,  # 'a'
    130: 0,  # 'b'
    131: 0,  # 'c'
    132: 0,  # 'd'
    133: 0,  # 'e'
    134: 0,  # 'f'
    135: 0,  # 'g'
    136: 0,  # 'h'
    137: 0,  # 'i'
    138: 1,  # 'α'
    139: 29,  # 'β'
    140: 20,  # 'γ'
    141: 21,  # 'δ'
    142: 5,  # 'ε'
    143: 35,  # 'ζ'
    144: CharacterCategory.SYMBOL,  # '°'
    145: 0,  # 'j'
    146: 0,  # 'k'
    147: 0,  # 'l'
    148: 0,  # 'm'
    149: 0,  # 'n'
    150: 0,  # 'o'
    151: 0,  # 'p'
    152: 0,  # 'q'
    153: 0,  # 'r'
    154: 11,  # 'η'
    155: 25,  # 'θ'
    156: 4,  # 'ι'
    157: 9,  # 'κ'
    158: 15,  # 'λ'
    159: 14,  # 'μ'
    160: CharacterCategory.SYMBOL,  # '´'
    161: CharacterCategory.SYMBOL,  # '~'
    162: 0,  # 's'
    163: 0,  # 't'
    164: 0,  # 'u'
    165: 0,  # 'v'
    166: 0,  # 'w'
    167: 0,  # 'x'
    168: 0,  # 'y'
    169: 0,  # 'z'
    170: 6,  # 'ν'
    171: 32,  # 'ξ'
    172: 2,  # 'ο'
    173: 10,  # 'π'
    174: 8,  # 'ρ'
    175: 7,  # 'σ'
    176: CharacterCategory.SYMBOL,  # '£'
    177: 17,  # 'ά'
    178: 19,  # 'έ'
    179: 23,  # 'ή'
    180: 0,  # 'ϊ'
    181: 16,  # 'ί'
    182: 18,  # 'ό'
    183: 26,  # 'ύ'
    184: 0,  # 'ϋ'
    185: 28,  # 'ώ'
    186: 12,  # 'ς'
    187: 3,  # 'τ'
    188: 13,  # 'υ'
    189: 27,  # 'φ'
    190: 24,  # 'χ'
    191: 45,  # 'ψ'
    192: CharacterCategory.SYMBOL,  # '{'
    193: 0,  # 'A'
    194: 0,  # 'B'
    195: 0,  # 'C'
    196: 0,  # 'D'
    197: 0,  # 'E'
    198: 0,  # 'F'
    199: 0,  # 'G'
    200: 0,  # 'H'
    201: 0,  # 'I'
    202: CharacterCategory.CONTROL,  # '\xad'
    203: 22,  # 'ω'
    204: 0,  # 'ΐ'
    205: 0,  # 'ΰ'
    206: CharacterCategory.SYMBOL,  # '‘'
    207: CharacterCategory.SYMBOL,  # '―'
    208: CharacterCategory.SYMBOL,  # '}'
    209: 0,  # 'J'
    210: 0,  # 'K'
    211: 0,  # 'L'
    212: 0,  # 'M'
    213: 0,  # 'N'
    214: 0,  # 'O'
    215: 0,  # 'P'
    216: 0,  # 'Q'
    217: 0,  # 'R'
    218: CharacterCategory.SYMBOL,  # '±'
    219: CharacterCategory.DIGIT,  # '½'
    220: CharacterCategory.CONTROL,  # '\x1a'
    221: CharacterCategory.SYMBOL,  # '·'
    222: CharacterCategory.SYMBOL,  # '’'
    223: CharacterCategory.SYMBOL,  # '¦'
    224: CharacterCategory.SYMBOL,  # '\\'
    225: CharacterCategory.CONTROL,  # '\x1a'
    226: 0,  # 'S'
    227: 0,  # 'T'
    228: 0,  # 'U'
    229: 0,  # 'V'
    230: 0,  # 'W'
    231: 0,  # 'X'
    232: 0,  # 'Y'
    233: 0,  # 'Z'
    234: CharacterCategory.DIGIT,  # '²'
    235: CharacterCategory.SYMBOL,  # '§'
    236: CharacterCategory.CONTROL,  # '\x1a'
    237: CharacterCategory.CONTROL,  # '\x1a'
    238: CharacterCategory.SYMBOL,  # '«'
    239: CharacterCategory.SYMBOL,  # '¬'
    240: CharacterCategory.DIGIT,  # '0'
    241: CharacterCategory.DIGIT,  # '1'
    242: CharacterCategory.DIGIT,  # '2'
    243: CharacterCategory.DIGIT,  # '3'
    244: CharacterCategory.DIGIT,  # '4'
    245: CharacterCategory.DIGIT,  # '5'
    246: CharacterCategory.DIGIT,  # '6'
    247: CharacterCategory.DIGIT,  # '7'
    248: CharacterCategory.DIGIT,  # '8'
    249: CharacterCategory.DIGIT,  # '9'
    250: CharacterCategory.DIGIT,  # '³'
    251: CharacterCategory.SYMBOL,  # '©'
    252: CharacterCategory.CONTROL,  # '\x1a'
    253: CharacterCategory.CONTROL,  # '\x1a'
    254: CharacterCategory.SYMBOL,  # '»'
    255: CharacterCategory.CONTROL,  # '\x9f'
}

CP875_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="CP875",
    language="Greek",
    char_to_order_map=CP875_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.9505466431988192,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)

ISO_8859_7_GREEK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.CONTROL,  # '\x80'
    129: CharacterCategory.CONTROL,  # '\x81'
    130: CharacterCategory.CONTROL,  # '\x82'
    131: CharacterCategory.CONTROL,  # '\x83'
    132: CharacterCategory.CONTROL,  # '\x84'
    133: CharacterCategory.CONTROL,  # '\x85'
    134: CharacterCategory.CONTROL,  # '\x86'
    135: CharacterCategory.CONTROL,  # '\x87'
    136: CharacterCategory.CONTROL,  # '\x88'
    137: CharacterCategory.CONTROL,  # '\x89'
    138: CharacterCategory.CONTROL,  # '\x8a'
    139: CharacterCategory.CONTROL,  # '\x8b'
    140: CharacterCategory.CONTROL,  # '\x8c'
    141: CharacterCategory.CONTROL,  # '\x8d'
    142: CharacterCategory.CONTROL,  # '\x8e'
    143: CharacterCategory.CONTROL,  # '\x8f'
    144: CharacterCategory.CONTROL,  # '\x90'
    145: CharacterCategory.CONTROL,  # '\x91'
    146: CharacterCategory.CONTROL,  # '\x92'
    147: CharacterCategory.CONTROL,  # '\x93'
    148: CharacterCategory.CONTROL,  # '\x94'
    149: CharacterCategory.CONTROL,  # '\x95'
    150: CharacterCategory.CONTROL,  # '\x96'
    151: CharacterCategory.CONTROL,  # '\x97'
    152: CharacterCategory.CONTROL,  # '\x98'
    153: CharacterCategory.CONTROL,  # '\x99'
    154: CharacterCategory.CONTROL,  # '\x9a'
    155: CharacterCategory.CONTROL,  # '\x9b'
    156: CharacterCategory.CONTROL,  # '\x9c'
    157: CharacterCategory.CONTROL,  # '\x9d'
    158: CharacterCategory.CONTROL,  # '\x9e'
    159: CharacterCategory.CONTROL,  # '\x9f'
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '‘'
    162: CharacterCategory.SYMBOL,  # '’'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '€'
    165: CharacterCategory.SYMBOL,  # '₯'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 0,  # 'ͺ'
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.UNDEFINED,  # None
    175: CharacterCategory.SYMBOL,  # '―'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '΄'
    181: CharacterCategory.SYMBOL,  # '΅'
    182: 56,  # 'Ά'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 54,  # 'Έ'
    185: 60,  # 'Ή'
    186: 61,  # 'Ί'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 55,  # 'Ό'
    189: CharacterCategory.DIGIT,  # '½'
    190: 62,  # 'Ύ'
    191: 63,  # 'Ώ'
    192: 0,  # 'ΐ'
    193: 30,  # 'Α'
    194: 49,  # 'Β'
    195: 44,  # 'Γ'
    196: 42,  # 'Δ'
    197: 31,  # 'Ε'
    198: 57,  # 'Ζ'
    199: 41,  # 'Η'
    200: 51,  # 'Θ'
    201: 40,  # 'Ι'
    202: 38,  # 'Κ'
    203: 47,  # 'Λ'
    204: 39,  # 'Μ'
    205: 43,  # 'Ν'
    206: 58,  # 'Ξ'
    207: 36,  # 'Ο'
    208: 34,  # 'Π'
    209: 46,  # 'Ρ'
    210: CharacterCategory.UNDEFINED,  # None
    211: 33,  # 'Σ'
    212: 37,  # 'Τ'
    213: 48,  # 'Υ'
    214: 52,  # 'Φ'
    215: 50,  # 'Χ'
    216: 59,  # 'Ψ'
    217: 53,  # 'Ω'
    218: 0,  # 'Ϊ'
    219: 0,  # 'Ϋ'
    220: 17,  # 'ά'
    221: 19,  # 'έ'
    222: 23,  # 'ή'
    223: 16,  # 'ί'
    224: 0,  # 'ΰ'
    225: 1,  # 'α'
    226: 29,  # 'β'
    227: 20,  # 'γ'
    228: 21,  # 'δ'
    229: 5,  # 'ε'
    230: 35,  # 'ζ'
    231: 11,  # 'η'
    232: 25,  # 'θ'
    233: 4,  # 'ι'
    234: 9,  # 'κ'
    235: 15,  # 'λ'
    236: 14,  # 'μ'
    237: 6,  # 'ν'
    238: 32,  # 'ξ'
    239: 2,  # 'ο'
    240: 10,  # 'π'
    241: 8,  # 'ρ'
    242: 12,  # 'ς'
    243: 7,  # 'σ'
    244: 3,  # 'τ'
    245: 13,  # 'υ'
    246: 27,  # 'φ'
    247: 24,  # 'χ'
    248: 45,  # 'ψ'
    249: 22,  # 'ω'
    250: 0,  # 'ϊ'
    251: 0,  # 'ϋ'
    252: 18,  # 'ό'
    253: 26,  # 'ύ'
    254: 28,  # 'ώ'
    255: CharacterCategory.UNDEFINED,  # None
}

ISO_8859_7_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="ISO-8859-7",
    language="Greek",
    char_to_order_map=ISO_8859_7_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.9505466431988192,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)

MACGREEK_GREEK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: 0,  # 'Ä'
    129: CharacterCategory.DIGIT,  # '¹'
    130: CharacterCategory.DIGIT,  # '²'
    131: 0,  # 'É'
    132: CharacterCategory.DIGIT,  # '³'
    133: 0,  # 'Ö'
    134: 0,  # 'Ü'
    135: CharacterCategory.SYMBOL,  # '΅'
    136: 0,  # 'à'
    137: 0,  # 'â'
    138: 0,  # 'ä'
    139: CharacterCategory.SYMBOL,  # '΄'
    140: CharacterCategory.SYMBOL,  # '¨'
    141: 0,  # 'ç'
    142: 0,  # 'é'
    143: 0,  # 'è'
    144: 0,  # 'ê'
    145: 0,  # 'ë'
    146: CharacterCategory.SYMBOL,  # '£'
    147: CharacterCategory.SYMBOL,  # '™'
    148: 0,  # 'î'
    149: 0,  # 'ï'
    150: CharacterCategory.SYMBOL,  # '•'
    151: CharacterCategory.DIGIT,  # '½'
    152: CharacterCategory.SYMBOL,  # '‰'
    153: 0,  # 'ô'
    154: 0,  # 'ö'
    155: CharacterCategory.SYMBOL,  # '¦'
    156: CharacterCategory.SYMBOL,  # '€'
    157: 0,  # 'ù'
    158: 0,  # 'û'
    159: 0,  # 'ü'
    160: CharacterCategory.SYMBOL,  # '†'
    161: 44,  # 'Γ'
    162: 42,  # 'Δ'
    163: 51,  # 'Θ'
    164: 47,  # 'Λ'
    165: 58,  # 'Ξ'
    166: 34,  # 'Π'
    167: 0,  # 'ß'
    168: CharacterCategory.SYMBOL,  # '®'
    169: CharacterCategory.SYMBOL,  # '©'
    170: 33,  # 'Σ'
    171: 0,  # 'Ϊ'
    172: CharacterCategory.SYMBOL,  # '§'
    173: CharacterCategory.SYMBOL,  # '≠'
    174: CharacterCategory.SYMBOL,  # '°'
    175: CharacterCategory.SYMBOL,  # '·'
    176: 30,  # 'Α'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.SYMBOL,  # '≤'
    179: CharacterCategory.SYMBOL,  # '≥'
    180: CharacterCategory.SYMBOL,  # '¥'
    181: 49,  # 'Β'
    182: 31,  # 'Ε'
    183: 57,  # 'Ζ'
    184: 41,  # 'Η'
    185: 40,  # 'Ι'
    186: 38,  # 'Κ'
    187: 39,  # 'Μ'
    188: 52,  # 'Φ'
    189: 0,  # 'Ϋ'
    190: 59,  # 'Ψ'
    191: 53,  # 'Ω'
    192: 17,  # 'ά'
    193: 43,  # 'Ν'
    194: CharacterCategory.SYMBOL,  # '¬'
    195: 36,  # 'Ο'
    196: 46,  # 'Ρ'
    197: CharacterCategory.SYMBOL,  # '≈'
    198: 37,  # 'Τ'
    199: CharacterCategory.SYMBOL,  # '«'
    200: CharacterCategory.SYMBOL,  # '»'
    201: CharacterCategory.SYMBOL,  # '…'
    202: CharacterCategory.CONTROL,  # '\xa0'
    203: 48,  # 'Υ'
    204: 50,  # 'Χ'
    205: 56,  # 'Ά'
    206: 54,  # 'Έ'
    207: 0,  # 'œ'
    208: CharacterCategory.SYMBOL,  # '–'
    209: CharacterCategory.SYMBOL,  # '―'
    210: CharacterCategory.SYMBOL,  # '“'
    211: CharacterCategory.SYMBOL,  # '”'
    212: CharacterCategory.SYMBOL,  # '‘'
    213: CharacterCategory.SYMBOL,  # '’'
    214: CharacterCategory.SYMBOL,  # '÷'
    215: 60,  # 'Ή'
    216: 61,  # 'Ί'
    217: 55,  # 'Ό'
    218: 62,  # 'Ύ'
    219: 19,  # 'έ'
    220: 23,  # 'ή'
    221: 16,  # 'ί'
    222: 18,  # 'ό'
    223: 63,  # 'Ώ'
    224: 26,  # 'ύ'
    225: 1,  # 'α'
    226: 29,  # 'β'
    227: 45,  # 'ψ'
    228: 21,  # 'δ'
    229: 5,  # 'ε'
    230: 27,  # 'φ'
    231: 20,  # 'γ'
    232: 11,  # 'η'
    233: 4,  # 'ι'
    234: 32,  # 'ξ'
    235: 9,  # 'κ'
    236: 15,  # 'λ'
    237: 14,  # 'μ'
    238: 6,  # 'ν'
    239: 2,  # 'ο'
    240: 10,  # 'π'
    241: 28,  # 'ώ'
    242: 8,  # 'ρ'
    243: 7,  # 'σ'
    244: 3,  # 'τ'
    245: 25,  # 'θ'
    246: 22,  # 'ω'
    247: 12,  # 'ς'
    248: 24,  # 'χ'
    249: 13,  # 'υ'
    250: 35,  # 'ζ'
    251: 0,  # 'ϊ'
    252: 0,  # 'ϋ'
    253: 0,  # 'ΐ'
    254: 0,  # 'ΰ'
    255: CharacterCategory.CONTROL,  # '\xad'
}

MACGREEK_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="MacGreek",
    language="Greek",
    char_to_order_map=MACGREEK_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.9505466431988192,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)

WINDOWS_1253_GREEK_CHAR_TO_ORDER = {
    0: CharacterCategory.CONTROL,  # '\x00'
    1: CharacterCategory.CONTROL,  # '\x01'
    2: CharacterCategory.CONTROL,  # '\x02'
    3: CharacterCategory.CONTROL,  # '\x03'
    4: CharacterCategory.CONTROL,  # '\x04'
    5: CharacterCategory.CONTROL,  # '\x05'
    6: CharacterCategory.CONTROL,  # '\x06'
    7: CharacterCategory.CONTROL,  # '\x07'
    8: CharacterCategory.CONTROL,  # '\x08'
    9: CharacterCategory.CONTROL,  # '\t'
    10: CharacterCategory.LINE_BREAK,  # '\n'
    11: CharacterCategory.CONTROL,  # '\x0b'
    12: CharacterCategory.CONTROL,  # '\x0c'
    13: CharacterCategory.LINE_BREAK,  # '\r'
    14: CharacterCategory.CONTROL,  # '\x0e'
    15: CharacterCategory.CONTROL,  # '\x0f'
    16: CharacterCategory.CONTROL,  # '\x10'
    17: CharacterCategory.CONTROL,  # '\x11'
    18: CharacterCategory.CONTROL,  # '\x12'
    19: CharacterCategory.CONTROL,  # '\x13'
    20: CharacterCategory.CONTROL,  # '\x14'
    21: CharacterCategory.CONTROL,  # '\x15'
    22: CharacterCategory.CONTROL,  # '\x16'
    23: CharacterCategory.CONTROL,  # '\x17'
    24: CharacterCategory.CONTROL,  # '\x18'
    25: CharacterCategory.CONTROL,  # '\x19'
    26: CharacterCategory.CONTROL,  # '\x1a'
    27: CharacterCategory.CONTROL,  # '\x1b'
    28: CharacterCategory.CONTROL,  # '\x1c'
    29: CharacterCategory.CONTROL,  # '\x1d'
    30: CharacterCategory.CONTROL,  # '\x1e'
    31: CharacterCategory.CONTROL,  # '\x1f'
    32: CharacterCategory.CONTROL,  # ' '
    33: CharacterCategory.SYMBOL,  # '!'
    34: CharacterCategory.SYMBOL,  # '"'
    35: CharacterCategory.SYMBOL,  # '#'
    36: CharacterCategory.SYMBOL,  # '$'
    37: CharacterCategory.SYMBOL,  # '%'
    38: CharacterCategory.SYMBOL,  # '&'
    39: CharacterCategory.SYMBOL,  # "'"
    40: CharacterCategory.SYMBOL,  # '('
    41: CharacterCategory.SYMBOL,  # ')'
    42: CharacterCategory.SYMBOL,  # '*'
    43: CharacterCategory.SYMBOL,  # '+'
    44: CharacterCategory.SYMBOL,  # ','
    45: CharacterCategory.SYMBOL,  # '-'
    46: CharacterCategory.SYMBOL,  # '.'
    47: CharacterCategory.SYMBOL,  # '/'
    48: CharacterCategory.DIGIT,  # '0'
    49: CharacterCategory.DIGIT,  # '1'
    50: CharacterCategory.DIGIT,  # '2'
    51: CharacterCategory.DIGIT,  # '3'
    52: CharacterCategory.DIGIT,  # '4'
    53: CharacterCategory.DIGIT,  # '5'
    54: CharacterCategory.DIGIT,  # '6'
    55: CharacterCategory.DIGIT,  # '7'
    56: CharacterCategory.DIGIT,  # '8'
    57: CharacterCategory.DIGIT,  # '9'
    58: CharacterCategory.SYMBOL,  # ':'
    59: CharacterCategory.SYMBOL,  # ';'
    60: CharacterCategory.SYMBOL,  # '<'
    61: CharacterCategory.SYMBOL,  # '='
    62: CharacterCategory.SYMBOL,  # '>'
    63: CharacterCategory.SYMBOL,  # '?'
    64: CharacterCategory.SYMBOL,  # '@'
    65: 0,  # 'A'
    66: 0,  # 'B'
    67: 0,  # 'C'
    68: 0,  # 'D'
    69: 0,  # 'E'
    70: 0,  # 'F'
    71: 0,  # 'G'
    72: 0,  # 'H'
    73: 0,  # 'I'
    74: 0,  # 'J'
    75: 0,  # 'K'
    76: 0,  # 'L'
    77: 0,  # 'M'
    78: 0,  # 'N'
    79: 0,  # 'O'
    80: 0,  # 'P'
    81: 0,  # 'Q'
    82: 0,  # 'R'
    83: 0,  # 'S'
    84: 0,  # 'T'
    85: 0,  # 'U'
    86: 0,  # 'V'
    87: 0,  # 'W'
    88: 0,  # 'X'
    89: 0,  # 'Y'
    90: 0,  # 'Z'
    91: CharacterCategory.SYMBOL,  # '['
    92: CharacterCategory.SYMBOL,  # '\\'
    93: CharacterCategory.SYMBOL,  # ']'
    94: CharacterCategory.SYMBOL,  # '^'
    95: CharacterCategory.SYMBOL,  # '_'
    96: CharacterCategory.SYMBOL,  # '`'
    97: 0,  # 'a'
    98: 0,  # 'b'
    99: 0,  # 'c'
    100: 0,  # 'd'
    101: 0,  # 'e'
    102: 0,  # 'f'
    103: 0,  # 'g'
    104: 0,  # 'h'
    105: 0,  # 'i'
    106: 0,  # 'j'
    107: 0,  # 'k'
    108: 0,  # 'l'
    109: 0,  # 'm'
    110: 0,  # 'n'
    111: 0,  # 'o'
    112: 0,  # 'p'
    113: 0,  # 'q'
    114: 0,  # 'r'
    115: 0,  # 's'
    116: 0,  # 't'
    117: 0,  # 'u'
    118: 0,  # 'v'
    119: 0,  # 'w'
    120: 0,  # 'x'
    121: 0,  # 'y'
    122: 0,  # 'z'
    123: CharacterCategory.SYMBOL,  # '{'
    124: CharacterCategory.SYMBOL,  # '|'
    125: CharacterCategory.SYMBOL,  # '}'
    126: CharacterCategory.SYMBOL,  # '~'
    127: CharacterCategory.CONTROL,  # '\x7f'
    128: CharacterCategory.SYMBOL,  # '€'
    129: CharacterCategory.UNDEFINED,  # None
    130: CharacterCategory.SYMBOL,  # '‚'
    131: 0,  # 'ƒ'
    132: CharacterCategory.SYMBOL,  # '„'
    133: CharacterCategory.SYMBOL,  # '…'
    134: CharacterCategory.SYMBOL,  # '†'
    135: CharacterCategory.SYMBOL,  # '‡'
    136: CharacterCategory.UNDEFINED,  # None
    137: CharacterCategory.SYMBOL,  # '‰'
    138: CharacterCategory.UNDEFINED,  # None
    139: CharacterCategory.SYMBOL,  # '‹'
    140: CharacterCategory.UNDEFINED,  # None
    141: CharacterCategory.UNDEFINED,  # None
    142: CharacterCategory.UNDEFINED,  # None
    143: CharacterCategory.UNDEFINED,  # None
    144: CharacterCategory.UNDEFINED,  # None
    145: CharacterCategory.SYMBOL,  # '‘'
    146: CharacterCategory.SYMBOL,  # '’'
    147: CharacterCategory.SYMBOL,  # '“'
    148: CharacterCategory.SYMBOL,  # '”'
    149: CharacterCategory.SYMBOL,  # '•'
    150: CharacterCategory.SYMBOL,  # '–'
    151: CharacterCategory.SYMBOL,  # '—'
    152: CharacterCategory.UNDEFINED,  # None
    153: CharacterCategory.SYMBOL,  # '™'
    154: CharacterCategory.UNDEFINED,  # None
    155: CharacterCategory.SYMBOL,  # '›'
    156: CharacterCategory.UNDEFINED,  # None
    157: CharacterCategory.UNDEFINED,  # None
    158: CharacterCategory.UNDEFINED,  # None
    159: CharacterCategory.UNDEFINED,  # None
    160: CharacterCategory.CONTROL,  # '\xa0'
    161: CharacterCategory.SYMBOL,  # '΅'
    162: 56,  # 'Ά'
    163: CharacterCategory.SYMBOL,  # '£'
    164: CharacterCategory.SYMBOL,  # '¤'
    165: CharacterCategory.SYMBOL,  # '¥'
    166: CharacterCategory.SYMBOL,  # '¦'
    167: CharacterCategory.SYMBOL,  # '§'
    168: CharacterCategory.SYMBOL,  # '¨'
    169: CharacterCategory.SYMBOL,  # '©'
    170: CharacterCategory.UNDEFINED,  # None
    171: CharacterCategory.SYMBOL,  # '«'
    172: CharacterCategory.SYMBOL,  # '¬'
    173: CharacterCategory.CONTROL,  # '\xad'
    174: CharacterCategory.SYMBOL,  # '®'
    175: CharacterCategory.SYMBOL,  # '―'
    176: CharacterCategory.SYMBOL,  # '°'
    177: CharacterCategory.SYMBOL,  # '±'
    178: CharacterCategory.DIGIT,  # '²'
    179: CharacterCategory.DIGIT,  # '³'
    180: CharacterCategory.SYMBOL,  # '΄'
    181: 0,  # 'µ'
    182: CharacterCategory.SYMBOL,  # '¶'
    183: CharacterCategory.SYMBOL,  # '·'
    184: 54,  # 'Έ'
    185: 60,  # 'Ή'
    186: 61,  # 'Ί'
    187: CharacterCategory.SYMBOL,  # '»'
    188: 55,  # 'Ό'
    189: CharacterCategory.DIGIT,  # '½'
    190: 62,  # 'Ύ'
    191: 63,  # 'Ώ'
    192: 0,  # 'ΐ'
    193: 30,  # 'Α'
    194: 49,  # 'Β'
    195: 44,  # 'Γ'
    196: 42,  # 'Δ'
    197: 31,  # 'Ε'
    198: 57,  # 'Ζ'
    199: 41,  # 'Η'
    200: 51,  # 'Θ'
    201: 40,  # 'Ι'
    202: 38,  # 'Κ'
    203: 47,  # 'Λ'
    204: 39,  # 'Μ'
    205: 43,  # 'Ν'
    206: 58,  # 'Ξ'
    207: 36,  # 'Ο'
    208: 34,  # 'Π'
    209: 46,  # 'Ρ'
    210: CharacterCategory.UNDEFINED,  # None
    211: 33,  # 'Σ'
    212: 37,  # 'Τ'
    213: 48,  # 'Υ'
    214: 52,  # 'Φ'
    215: 50,  # 'Χ'
    216: 59,  # 'Ψ'
    217: 53,  # 'Ω'
    218: 0,  # 'Ϊ'
    219: 0,  # 'Ϋ'
    220: 17,  # 'ά'
    221: 19,  # 'έ'
    222: 23,  # 'ή'
    223: 16,  # 'ί'
    224: 0,  # 'ΰ'
    225: 1,  # 'α'
    226: 29,  # 'β'
    227: 20,  # 'γ'
    228: 21,  # 'δ'
    229: 5,  # 'ε'
    230: 35,  # 'ζ'
    231: 11,  # 'η'
    232: 25,  # 'θ'
    233: 4,  # 'ι'
    234: 9,  # 'κ'
    235: 15,  # 'λ'
    236: 14,  # 'μ'
    237: 6,  # 'ν'
    238: 32,  # 'ξ'
    239: 2,  # 'ο'
    240: 10,  # 'π'
    241: 8,  # 'ρ'
    242: 12,  # 'ς'
    243: 7,  # 'σ'
    244: 3,  # 'τ'
    245: 13,  # 'υ'
    246: 27,  # 'φ'
    247: 24,  # 'χ'
    248: 45,  # 'ψ'
    249: 22,  # 'ω'
    250: 0,  # 'ϊ'
    251: 0,  # 'ϋ'
    252: 18,  # 'ό'
    253: 26,  # 'ύ'
    254: 28,  # 'ώ'
    255: CharacterCategory.UNDEFINED,  # None
}

WINDOWS_1253_GREEK_MODEL = SingleByteCharSetModel(
    charset_name="WINDOWS-1253",
    language="Greek",
    char_to_order_map=WINDOWS_1253_GREEK_CHAR_TO_ORDER,
    language_model=GREEK_LANG_MODEL,
    typical_positive_ratio=0.9505466431988192,
    keep_ascii_letters=False,
    alphabet="ΆΈΉΊΌΎΏΑΒΓΔΕΖΗΘΙΚΛΜΝΞΟΠΡΣΤΥΦΧΨΩάέήίαβγδεζηθικλμνξοπρςστυφχψωόύώ",
)
