/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.builder;

import java.util.Arrays;
import java.util.Collections;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.builder.StandardToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.builder.ToStringStyleTest;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class StandardToStringStyleTest
extends AbstractLangTest {
    private static final StandardToStringStyle STYLE = new StandardToStringStyle();
    private final Integer base = 5;
    private final String baseStr = "Integer";

    @BeforeEach
    public void setUp() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)STYLE);
    }

    @AfterEach
    public void tearDown() {
        ToStringBuilder.setDefaultStyle((ToStringStyle)ToStringStyle.DEFAULT_STYLE);
    }

    @Test
    public void testAppendSuper() {
        Assertions.assertEquals((Object)"Integer[]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").toString());
        Assertions.assertEquals((Object)"Integer[a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)"Integer[%NULL%,a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper("Integer@8888[%NULL%]").append("a", (Object)"hello").toString());
        Assertions.assertEquals((Object)"Integer[a=hello]", (Object)new ToStringBuilder((Object)this.base).appendSuper(null).append("a", (Object)"hello").toString());
    }

    @Test
    public void testArray() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[0], false).toString());
        Assertions.assertEquals((Object)"Integer[a=[]]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[0], true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=1%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3}, false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3]]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3}, true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=2%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3, i4}, false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3, 4]]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)new Integer[]{i3, i4}, true).toString());
    }

    @Test
    public void testBlank() {
        Assertions.assertEquals((Object)"Integer[]", (Object)new ToStringBuilder((Object)this.base).toString());
    }

    @Test
    public void testCollection() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyList(), false).toString());
        Assertions.assertEquals((Object)"Integer[a=[]]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyList(), true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=1%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonList(i3), false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3]]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonList(i3), true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=2%]", (Object)new ToStringBuilder((Object)this.base).append("a", Arrays.asList(i3, i4), false).toString());
        Assertions.assertEquals((Object)"Integer[a=[3, 4]]", (Object)new ToStringBuilder((Object)this.base).append("a", Arrays.asList(i3, i4), true).toString());
    }

    @Test
    public void testDefaultGetter() {
        Assertions.assertEquals((Object)"[", (Object)STYLE.getContentStart());
        Assertions.assertEquals((Object)"]", (Object)STYLE.getContentEnd());
        Assertions.assertEquals((Object)"=", (Object)STYLE.getFieldNameValueSeparator());
        Assertions.assertEquals((Object)",", (Object)STYLE.getFieldSeparator());
        Assertions.assertEquals((Object)"%NULL%", (Object)STYLE.getNullText());
        Assertions.assertEquals((Object)"%SIZE=", (Object)STYLE.getSizeStartText());
        Assertions.assertEquals((Object)"%", (Object)STYLE.getSizeEndText());
        Assertions.assertEquals((Object)"%", (Object)STYLE.getSummaryObjectStartText());
        Assertions.assertEquals((Object)"%", (Object)STYLE.getSummaryObjectEndText());
    }

    @Test
    public void testDefaultIsArrayContentDetail() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isArrayContentDetail());
    }

    @Test
    public void testDefaultIsFieldSeparatorAtEnd() {
        Assertions.assertFalse((boolean)new StandardToStringStyle().isFieldSeparatorAtEnd());
    }

    @Test
    public void testDefaultIsFieldSeparatorAtStart() {
        Assertions.assertFalse((boolean)new StandardToStringStyle().isFieldSeparatorAtStart());
    }

    @Test
    public void testDefaultValueOfFullDetail() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isDefaultFullDetail());
    }

    @Test
    public void testDefaultValueOfUseClassName() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isUseClassName());
    }

    @Test
    public void testDefaultValueOfUseFieldNames() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isUseFieldNames());
    }

    @Test
    public void testDefaultValueOfUseIdentityHashCode() {
        Assertions.assertTrue((boolean)new StandardToStringStyle().isUseIdentityHashCode());
    }

    @Test
    public void testDefaultValueOfUseShortClassName() {
        Assertions.assertFalse((boolean)new StandardToStringStyle().isUseShortClassName());
    }

    @Test
    public void testLong() {
        Assertions.assertEquals((Object)"Integer[3]", (Object)new ToStringBuilder((Object)this.base).append(3L).toString());
        Assertions.assertEquals((Object)"Integer[a=3]", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).toString());
        Assertions.assertEquals((Object)"Integer[a=3,b=4]", (Object)new ToStringBuilder((Object)this.base).append("a", 3L).append("b", 4L).toString());
    }

    @Test
    public void testLongArray() {
        long[] array = new long[]{1L, 2L, -3L, 4L};
        Assertions.assertEquals((Object)"Integer[[1, 2, -3, 4]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[[1, 2, -3, 4]]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testLongArrayArray() {
        long[][] array = new long[][]{{1L, 2L}, null, {5L}};
        Assertions.assertEquals((Object)"Integer[[[1, 2], %NULL%, [5]]]", (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)"Integer[[[1, 2], %NULL%, [5]]]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object[])array).toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testMap() {
        Assertions.assertEquals((Object)"Integer[a=%SIZE=0%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyMap(), false).toString());
        Assertions.assertEquals((Object)"Integer[a={}]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.emptyMap(), true).toString());
        Assertions.assertEquals((Object)"Integer[a=%SIZE=1%]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonMap("k", "v"), false).toString());
        Assertions.assertEquals((Object)"Integer[a={k=v}]", (Object)new ToStringBuilder((Object)this.base).append("a", Collections.singletonMap("k", "v"), true).toString());
    }

    @Test
    public void testObject() {
        Integer i3 = 3;
        Integer i4 = 4;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(null).toString());
        Assertions.assertEquals((Object)"Integer[3]", (Object)new ToStringBuilder((Object)this.base).append((Object)i3).toString());
        Assertions.assertEquals((Object)"Integer[a=%NULL%]", (Object)new ToStringBuilder((Object)this.base).append("a", null).toString());
        Assertions.assertEquals((Object)"Integer[a=3]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).toString());
        Assertions.assertEquals((Object)"Integer[a=3,b=4]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3).append("b", (Object)i4).toString());
        Assertions.assertEquals((Object)"Integer[a=%Integer%]", (Object)new ToStringBuilder((Object)this.base).append("a", (Object)i3, false).toString());
    }

    @Test
    public void testObjectArray() {
        Object[] array = new Object[]{null, this.base, new int[]{3, 6}};
        Assertions.assertEquals((Object)"Integer[[%NULL%, 5, [3, 6]]]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[[%NULL%, 5, [3, 6]]]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
        array = null;
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append(array).toString());
        Assertions.assertEquals((Object)"Integer[%NULL%]", (Object)new ToStringBuilder((Object)this.base).append((Object)array).toString());
    }

    @Test
    public void testPerson() {
        ToStringStyleTest.Person p = new ToStringStyleTest.Person();
        p.name = "Suzy Queue";
        p.age = 19;
        p.smoker = false;
        String pBaseStr = "ToStringStyleTest.Person";
        Assertions.assertEquals((Object)"ToStringStyleTest.Person[name=Suzy Queue,age=19,smoker=false]", (Object)new ToStringBuilder((Object)p).append("name", (Object)p.name).append("age", p.age).append("smoker", p.smoker).toString());
    }

    static {
        STYLE.setUseShortClassName(true);
        STYLE.setUseIdentityHashCode(false);
        STYLE.setArrayStart("[");
        STYLE.setArraySeparator(", ");
        STYLE.setArrayEnd("]");
        STYLE.setNullText("%NULL%");
        STYLE.setSizeStartText("%SIZE=");
        STYLE.setSizeEndText("%");
        STYLE.setSummaryObjectStartText("%");
        STYLE.setSummaryObjectEndText("%");
        STYLE.setUseClassName(true);
        STYLE.setUseFieldNames(true);
        STYLE.setUseClassName(true);
        STYLE.setUseFieldNames(true);
        STYLE.setDefaultFullDetail(true);
        STYLE.setArrayContentDetail(true);
        STYLE.setFieldNameValueSeparator("=");
    }
}

