/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.unboundidds.controls;

import com.unboundid.util.NotNull;
import com.unboundid.util.Nullable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public enum AttributeRight {
    SEARCH("search"),
    READ("read"),
    COMPARE("compare"),
    WRITE("write"),
    SELFWRITE_ADD("selfwrite_add"),
    SELFWRITE_DELETE("selfwrite_delete"),
    PROXY("proxy");

    @NotNull
    private final String name;

    private AttributeRight(String name) {
        this.name = name;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @Nullable
    public static AttributeRight forName(@NotNull String name) {
        switch (StaticUtils.toLowerCase(name)) {
            case "search": {
                return SEARCH;
            }
            case "read": {
                return READ;
            }
            case "compare": {
                return COMPARE;
            }
            case "write": {
                return WRITE;
            }
            case "selfwriteadd": 
            case "selfwrite-add": 
            case "selfwrite_add": 
            case "self-write-add": 
            case "self_write_add": {
                return SELFWRITE_ADD;
            }
            case "selfwritedelete": 
            case "selfwrite-delete": 
            case "selfwrite_delete": 
            case "self-write-delete": 
            case "self_write_delete": 
            case "selfwritedel": 
            case "selfwrite-del": 
            case "selfwrite_del": 
            case "self-write-del": 
            case "self_write_del": {
                return SELFWRITE_DELETE;
            }
            case "proxy": {
                return PROXY;
            }
        }
        return null;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

