#!/bin/bash
#pupchecksum.sh
#01micko 120731 GPL2 (see /usr/share/doc/legal)
#gtkdialog checksum checker
# shinobar: accept paramater
# don570 and shinobar: fix spaces in path name, BASEDIR, more message
#set -x #debug
# version 0.7 dec 7 2012
#+ modified to use Xdialog (for greater compatibility) by don570
# version 0.9 dec 19 2012 - save of md5sum to file possible
# version 1.0 dec 20 yaf-spash when saving -save file use \t
#gettext version 1.1 German French Spanish
#gettext version 1.2 - fixed bug in save 
#add extra checksum types - version 1.4
#add button to copy to clipboard - version 1.5
#enable saving of all checksum types, not just md5 - version 1.6
#jan 01 2019: adjust GUI - version 1.7
#jan 20 2019: code cleanup; launch xdialog message as background process - version 1.8

MYPATH=$0
MYNAME=$(basename "$0")
VERSION=1.9

CREDIT="$MYNAME - checksum checker: version $VERSION"
usage() {
  echo $CREDIT
  echo "usage: $MYNAME [FILENAME]"
}
case "$1" in
-v|--version) echo $CREDIT; exit ;;
-*) usage; exit;;
esac
export ENT1="$1"
export ENT2=""
rm -f /tmp/pupchecksum* 2>/dev/null
BASEDIR=$(dirname "$ENT1")
[ -d "$BASEDIR" ] || BASEDIR=""
[ -d "$ENT1" ] && BASEDIR="$ENT1"
[ "$BASEDIR" ] || BASEDIR=$HOME
[ "$BASEDIR" ] || BASEDIR="/root"

export TEXTDOMAIN=pupmd5sum.sh
export OUTPUT_CHARSET=UTF-8
TITLE="pupmd5sum"

# workdir for the save folder
export WORKDIR=$HOME/.pupmd5sum
if [ ! -d $WORKDIR ]; then
   mkdir -p $WORKDIR
   echo /root > $WORKDIR/savefolder
fi

#splash screens
export SPLASH1=$(gettext "Please enter a file!")
export _NGFILE=$(gettext "The source is not a file!")
export _NULL=$(gettext "The source file is null!")
export SPLASH2=$(gettext "Nothing to compare!")
export SPLASH3=$(gettext "Your checksums match")
export SPLASH4=$(gettext "Your checksums DO NOT match")
export SPLASH5=$(gettext "Please wait ...")
export SPLASHT1=$(gettext "Correct")
export SPLASHT2=$(gettext "Wrong!")
export SPLASHT3=$(gettext "Please complete the settings. ")
export SPLASHT4=$(gettext "Saving to disk ...")

#frames, buttons and tool-tips
FRAME1=$(gettext "File Name")
FRAME1a=$(gettext "Hash type")
FRAME2=$(gettext "Checksum")
FRAME3=$(gettext "Compare")
FRAME4=$(gettext "Save Directory")
BTN1=$(gettext "Calculate")
BTN2=$(gettext "Compare")
BTN4=$(gettext "OK")
BTN5=$(gettext "Select a Directory to save checksum")
BTN6=$(gettext "Clipboard")
BTN7=$(gettext "Select a File to calculate checksum")
BTN8=$(gettext "Clear")
TT=$(gettext "Paste the correct checksum here")
SAVETT=$(gettext "Checksum is saved to a text file")
COPY2CLIP=$(gettext "Copy checksum to clipboard")

#Save to file
#Check func

checkfunc()
{
	CHECKSUM=md5sum
	[ "$RB2" = "true" ] && CHECKSUM=sha1sum
	[ "$RB3" = "true" ] && CHECKSUM=sha256sum
	[ "$RB4" = "true" ] && CHECKSUM=sha512sum
	ERRMSG=""
	[ "$ENT1" ] || ERRMSG=$SPLASH1
	if [ "$ERRMSG" != "$SPLASH1" ]; then	# check if file exists and has a size greater than zero
	   [ -s "$ENT1" ] || ERRMSG=$_NULL
	fi
	if [ "$ERRMSG" != "$SPLASH1" ] && [ "$ERRMSG" != "$_NULL" ]; then
	   [ -f "$ENT1" ] || ERRMSG=$_NGFILE	# check if file exists and is a regular file
	fi
	if [ "$ERRMSG" ]; then
	   Xdialog --title pupmd5sum --ok-label "$BTN4" --backtitle "\n\n          $ERRMSG          " --msgbox "" 0 0 &
	   exit 1
	fi
	Xdialog --title pupmd5sum --ok-label "$BTN4" --backtitle "\n\n               $SPLASH5               "  --msgbox "" 0 0 &
	SPID=$!
	$CHECKSUM "$ENT1" > /tmp/pupchecksum
	ENT=$(cat /tmp/pupchecksum 2>/dev/null)
	rm /tmp/pupchecksum 2>/dev/null
	export ENT2=${ENT%% *}	# fix dirname with spaces
	echo -n $ENT2 > /tmp/pupchecksum_result	# record checksum only, do not append a newline
	kill $SPID
}
export -f checkfunc

# parse checksum for length and if foldername supplied then create file to save the checksum
checkmd5sum()
{
	CHECKSUM=md5
	[ "$RB2" = "true" ] && CHECKSUM=sha1
	[ "$RB3" = "true" ] && CHECKSUM=sha256
	[ "$RB4" = "true" ] && CHECKSUM=sha512
	export RESULT=$(cat /tmp/pupchecksum_result 2>/dev/null)
	if [ ${#RESULT} -gt 0 ] && [ -n "$FILE_DIRECTORY" ]; then	# save the checksum
	   continue
	elif [ ${#RESULT} -eq 0 ] || [ ! -e /tmp/pupchecksum_folder ];then	# don't save
	   Xdialog --title pupmd5sum --ok-label "$BTN4" --backtitle "\n\n          $SPLASHT2          "  --msgbox  "\n          $SPLASHT3          \n " 0 0 &
	   exit 0
	fi
	yaf-splash -timeout 2 -placement mouse -close never -bg orange -fontsize large -text "  $SPLASHT4 " &
	cd "$FILE_DIRECTORY"
	FILENAME="${ENT1##*/}"	# find ending of pathname
	echo -e "$RESULT\t$FILENAME" > "${FILENAME}-${CHECKSUM}".checksum
}
export -f checkmd5sum

#compare
comparefunc()
{
	CHECKSUM=md5sum
	[ "$RB2" = "true" ] && CHECKSUM=sha1sum
	[ "$RB3" = "true" ] && CHECKSUM=sha256
	[ "$RB4" = "true" ] && CHECKSUM=sha512
	if [ ! "$ENT2" -o ! "$ENT3" ]; then
	   Xdialog --title pupmd5sum --ok-label "$BTN4" --backtitle "\n\n          $SPLASH2          "  --msgbox  "" 0 0 &
	   exit 1
	else
	 ENT3=$(echo $ENT3)	# remove whitespace with bad copy/paste
	 ENT3=${ENT3%% *}	# extract only the checksum
	 if [ "$ENT2" = "$ENT3" ]; then
	    Xdialog --title pupmd5sum --ok-label "$BTN4" --backtitle "\n\n          ${CHECKSUM}: $SPLASH3          " --msgbox "" 0 0 &
	 else
	    Xdialog --title pupmd5sum --ok-label "$BTN4" --backtitle "\n\n          ${CHECKSUM}: $SPLASH4          "  --msgbox  "" 0 0 &
	 fi
	fi
}
export -f comparefunc

#copy2clipboard
copy2clipboard()
{
	cat /tmp/pupchecksum_result 2>/dev/null | xclip -selection clipboard
}
export -f copy2clipboard

[ ! -f /usr/share/icons/hicolor/48x48/apps/hash.xpm ] && ln -sf /usr/share/pixmaps/hash.xpm /usr/share/icons/hicolor/48x48/apps && gtk-update-icon-cache -f -i /usr/share/icons/hicolor 2>/dev/null

export MAINGUI='<window title="'"$TITLE"'-'"$VERSION"'" icon-name="hash" resizable="true">
 <hbox height-request="280">
  <vbox space-expand="true" space-fill="true" width-request="495">
   <text xalign="0" use-markup="true"><label>"<b><span size='"'small'"'>'"$FRAME1"'</span></b>"</label></text>
   <vbox>
    <hbox>
     <entry fs-action="file" fs-folder="'"$BASEDIR"'" fs-title="'"$BTN7"'" tooltip-text=" '"$BTN7"' " secondary-icon-stock="gtk-clear" secondary-icon-tooltip-text=" '"$BTN8"' ">
       <variable>ENT1</variable>
       <default>"'$ENT1'"</default>
       <action>clear:ENT2</action>
       <action>clear:ENT3</action>
       <action signal="secondary-icon-release">clear:ENT1</action>
       <action signal="secondary-icon-release">clear:ENT2</action>
       <action signal="secondary-icon-release">clear:ENT3</action>
       <action signal="secondary-icon-release">rm /tmp/pupchecksum* 2>/dev/null</action>
     </entry>
     <button>
       <input file stock="gtk-new"></input>
       <action>fileselect:ENT1</action>
     </button>
    </hbox>
   </vbox>

    <text xalign="0" use-markup="true"><label>"<b><span size='"'small'"'>'"$FRAME1a"'</span></b>"</label></text>
    <hbox homogeneous="true">
     <radiobutton>
       <label>MD5</label>
       <variable>RB1</variable>
     </radiobutton>
     <radiobutton>
       <label>Sha-1</label>
       <variable>RB2</variable>
     </radiobutton>
     <radiobutton>
       <label>Sha-256</label>
       <variable>RB3</variable>
     </radiobutton>
     <radiobutton>
       <label>Sha-512</label>
       <variable>RB4</variable>
     </radiobutton>
    </hbox>

    <text xalign="0" use-markup="true"><label>"<b><span size='"'small'"'>'"$FRAME2"'</span></b>"</label></text>
     <entry tooltip-text=" '"$(gettext 'Result of calculation')"' ">
       <variable>ENT2</variable>
       <input>cat /tmp/pupchecksum_result 2>/dev/null</input>
     </entry>

    <text height-request="1"><label>""</label></text>
    <text xalign="0" use-markup="true"><label>"<b><span size='"'small'"'>'"$FRAME3"'</span></b>"</label></text>
     <entry tooltip-text=" '"$TT"' ">
       <variable>ENT3</variable>
     </entry>

    <text height-request="1"><label>""</label></text>
    <text xalign="0" use-markup="true"><label>"<b><span size='"'small'"'>'"$FRAME4"'</span></b>"</label></text>
   <vbox>
    <hbox>
     <entry accept="directory" fs-title="'"$BTN5"'" tooltip-text=" '"$BTN5"' ">
       <variable>FILE_DIRECTORY</variable>
       <input>tac '$WORKDIR'/savefolder</input>
     </entry>
     <button>
       <input file stock="gtk-open"></input>
       <action type="fileselect">FILE_DIRECTORY</action>
       <action>touch  /tmp/pupchecksum_folder</action>
       <action>echo "$FILE_DIRECTORY" > '$WORKDIR'/savefolder</action>
     </button>
    </hbox>
   </vbox>
  </vbox>

   <vseparator></vseparator>

  <vbox space-expand="false" width-request="150">
   <hbox space-expand="true" space-fill="true">
    <button image-position="2" homogeneous="true">
     <input file stock="gtk-yes"></input>
     <height>24</height>
     <label>'"$BTN1"'</label>
     <action>checkfunc '"$ENT1"'</action>
     <action type="refresh">ENT2</action>
    </button>
   </hbox>
   <hbox space-expand="true" space-fill="true">
    <button image-position="2" homogeneous="true">
     <input file stock="gtk-refresh"></input>
     <height>24</height>
     <label>'"$BTN2"'</label>
     <action>comparefunc</action>
    </button>
   </hbox>
   <hbox space-expand="true" space-fill="true">
    <button image-position="2" tooltip-text=" '"$COPY2CLIP"' " homogeneous="true">
     <input file stock="gtk-copy"></input>
     <height>24</height>
     <label>'"$BTN6"'</label>
     <action>copy2clipboard</action>
    </button>
   </hbox>
    <hbox space-expand="true" space-fill="true">
    <button image-position="2" tooltip-text=" '"$SAVETT"' " homogeneous="true">
     <input file stock="gtk-save"></input>
     <height>24</height>
     <label>'"$(gettext "Save")"'</label>
     <action>checkmd5sum</action>
    </button>
   </hbox>
   <hbox space-expand="true" space-fill="true">
    <button image-position="2" homogeneous="true">
     <input file stock="gtk-close"></input>
     <height>24</height>
     <label>'$(gettext "Close")'</label>
     <action type="exit">CLOSE</action>
    </button>
   </hbox>
  </vbox>
 </hbox>
</window>'
for P in gtkdialog4 gtkdialog3 gtkdialog; do
  GTKDIALOG=$(which $P) && break
done
if [ -z "$GTKDIALOG" ]; then
  echo "$MYNAME: error: gtkdialog not found." >&2
  exit 1
fi
[ -f "$ENT1" -a -s "$ENT1" ] && checkfunc "$ENT1"
$GTKDIALOG -p MAINGUI  --geometry=+200+100
unset MAINGUI
