#!/bin/sh

export TEXTDOMAIN=gatotray
export OUTPUT_CHARSET=UTF-8
. gettext.sh 

export VERSION=3.3

# define about
gatotray_about()
{
export GATOTRAY_ABOUT="
<window title=\"About\" icon-name=\"graph\" window-position=\"3\" resizable=\"false\">
    <vbox margin=\"5\" width-request=\"425\">
        <pixmap><input file>/usr/share/pixmaps/puppy/graph.svg</input><height>64</height><width>64</width></pixmap>
        <text use-markup=\"true\"><label>\"<b><span size='"'x-large'"'>Gatotray</span> $VERSION</b>\"</label></text>
        <text use-markup=\"true\"><label>\"<b>$(gettext 'Tray System Monitor')</b>\"</label></text>
        <text><label>\"gatopeich (C) 2011-2020 CCA3\"</label></text>
        <hbox margin=\"5\" space-expand=\"false\" space-fill=\"true\" homogeneous=\"true\">
            <button tooltip-text=\" https://github.com/gatopeich/gatotray \">
                <label>\"$(gettext 'Source')\"</label>
                <action>defaulthtmlviewer https:\/\/github.com\/gatopeich\/gatotray &</action>
            </button>
        </hbox>
    </vbox>
</window>"
gtkdialog -p GATOTRAY_ABOUT
unset GATOTRAY_ABOUT
}
export -f gatotray_about

# define custom command
[ ! "`grep 'Custom command' $HOME/.config/gatotrayrc 2>/dev/null`" ] && echo "Custom command=lxtask" >> $HOME/.config/gatotrayrc
custom_cmd=$(grep 'Custom command' $HOME/.config/gatotrayrc 2>/dev/null | cut -d "=" -f2- | awk -F' ' '{print $NF}')
[ ! "`echo "$custom_cmd" | grep -E 'lxtask|top' 2>/dev/null`" ] && custom_cmd=lxtask

# define custom-command terminal window geometry (top, htop, btop)
[ "`grep '88x34' $HOME/.config/gatotrayrc 2>/dev/null`" ] && custom_cmd_size=88x34
[ "`grep '88x38' $HOME/.config/gatotrayrc 2>/dev/null`" ] && custom_cmd_size=88x38
[ "`grep '88x42' $HOME/.config/gatotrayrc 2>/dev/null`" ] && custom_cmd_size=88x42
[ "`grep '88x46' $HOME/.config/gatotrayrc 2>/dev/null`" ] && custom_cmd_size=88x46
[ "`grep '88x50' $HOME/.config/gatotrayrc 2>/dev/null`" ] && custom_cmd_size=88x50
[ ! "$custom_cmd_size" ] && custom_cmd_size=88x30

# define available custom-command applications (lxtask, top, htop, btop)
COMMAND=$custom_cmd
COMMAND_ARRAY=("lxtask" "top" "btop" "htop")
COMMAND_ITEMS="<item>$COMMAND</item>"
for i in "${COMMAND_ARRAY[@]}"
do
	if [ "$i" != "$COMMAND" ]; then
		if [ "`which $i`" != "" ]; then
			COMMAND_ITEMS=`echo "$COMMAND_ITEMS<item>$i</item>"`
		fi
	fi
done

# set custom command
set_custom_command(){
	gtkdialog-splash -timeout 4 -margin 10 -placement top -fontsize large -bg goldenrod -text " $(gettext 'Setting Gatotray command to '"$custom_cmd"' !') " &
	killall gatotray.bin64 2>/dev/null
	if [ "$custom_cmd" = "lxtask" ]; then
		custom_command="lxtask"
	elif [ "$custom_cmd" = "top" ]; then
		custom_command="urxvt -geometry $custom_cmd_size -e top"
	elif [ "$custom_cmd" = "htop" ]; then
		custom_command="urxvt -geometry $custom_cmd_size -e htop"
	elif [ "$custom_cmd" = "btop" ]; then
		custom_command="urxvt -geometry $custom_cmd_size -e btop"
	fi
	sed -i "s/^.*Custom command.*$/Custom command=${custom_command}/" $HOME/.config/gatotrayrc
	sleep 1
	/usr/bin/gatotray.bin64 &
}
export -f set_custom_command

# start gatotray
start_gatotray(){
	gtkdialog-splash -timeout 3 -margin 10 -placement top -fontsize large -bg goldenrod -text " $(gettext 'Gatotray started') " &
	exec /usr/bin/gatotray.bin64 &
}
export -f start_gatotray

# stop gatotray
stop_gatotray(){
	gtkdialog-splash -timeout 3 -margin 10 -placement top -fontsize large -bg goldenrod -text " $(gettext 'Gatotray stopped') " &
	killall gatotray.bin64 &
}
export -f stop_gatotray

# add gatotray autostart
add_autostart(){
	gtkdialog-splash -timeout 3 -margin 10 -placement top -fontsize large -bg goldenrod -text " $(gettext 'Adding autostart at boot') " &
	ln -sf /usr/bin/gatotray.bin64 $HOME/Startup/gatotray.bin64 &
}
export -f add_autostart

# remove gatotray autostart
remove_autostart(){
	gtkdialog-splash -timeout 3 -margin 10 -placement top -fontsize large -bg goldenrod -text " $(gettext 'Removing autostart at boot') " &
	rm -f $HOME/Startup/gatotray.bin64 &
}
export -f remove_autostart

MAIN_DIALOG='
<window title="Gatotray" icon-name="graph" resizable="false" window-position="1">
	<vbox margin="5" space-expand="false" space-fill="false">
		<vbox>
			<pixmap>
				<height>75</height>
				<width>75</width>
				<input file icon="graph"></input>
			</pixmap>
			<text use-markup="true" homogeneous="true" space-expand="false" space-fill="false"><label>"                              '"<b><span size='"'large'"'>$(gettext 'Tray System Monitor')</span></b>"'                              "</label></text>
			<hseparator space-expand="false" space-fill="false"></hseparator>
			<hbox homogeneous="true" space-expand="true" space-fill="true">
				<vbox space-expand="true" space-fill="true">
					<button tooltip-text=" '"$(gettext "Start Gatotray")"' ">
						<label>"'"$(gettext "Start")"'"</label>
						<action>start_gatotray &</action>
					</button>
				</vbox>
				<vbox space-expand="true" space-fill="true">
					<button tooltip-text=" '"$(gettext "Stop Gatotray")"' ">
						<label>"'"$(gettext "Stop")"'"</label>
						<action>stop_gatotray &</action>
					</button>
				</vbox>
			</hbox>

			<hbox homogeneous="true" space-expand="true" space-fill="true">
				<vbox space-expand="true" space-fill="true">
					<button tooltip-text=" '"$(gettext "Start Gatotray at boot up")"' ">
						<label>"'"$(gettext "Autostart  ON")"'"</label>
						<action>add_autostart &</action>
					</button>
				</vbox>
				<vbox space-expand="true" space-fill="true">
					<button tooltip-text=" '"$(gettext "Remove start at boot")"' ">
						<label>"'"$(gettext "Autostart  OFF")"'"</label>
						<action>remove_autostart &</action>
					</button>
				</vbox>
			</hbox>
		</vbox>

		<vbox margin="10" space-expand="true" space-fill="true">
		  <hbox>
		     <vbox space-expand="true" space-fill="true">
				<text space-expand="false" space-fill="false"><label>"'"$(gettext 'Command')"'"</label></text>
				<comboboxtext wrap="false" space-expand="false" space-fill="false" tooltip-text=" '"$(gettext "Custom left-click command")"' ">
					<variable>custom_cmd</variable>
					<default>'$custom_cmd'</default>
					'$COMMAND_ITEMS'
				</comboboxtext>
		     </vbox>
		     <vbox space-expand="true" space-fill="true">
				<text space-expand="false" space-fill="false"><label>"'"$(gettext 'Geometry')"'"</label></text>
				<comboboxtext wrap="false" space-expand="false" space-fill="false" tooltip-text=" '"$(gettext "Window dimensions of terminal-based 
 commands such as top, btop and htop.")"' ">
					<variable>custom_cmd_size</variable>
					<default>'$custom_cmd_size'</default>
					<item>88x30</item>
					<item>88x34</item>
					<item>88x38</item>
					<item>88x42</item>
					<item>88x46</item>
					<item>88x50</item>
				</comboboxtext>
		     </vbox>
		  </hbox>
		  <hbox homogeneous="true" space-expand="false" space-fill="true">
			<button tooltip-text=" '"$(gettext "Apply custom command")"' ">
				<label>'$(gettext 'Apply')'</label>
				<input file>/usr/share/pixmaps/puppy/apply.svg</input><height>22</height><width>22</width>
				<action>set_custom_command &</action>
			</button>
		  </hbox>
		</vbox>

		<hseparator space-expand="false" space-fill="false"></hseparator>

		<hbox homogeneous="true" space-expand="false" space-fill="true">
			<button>
				<label>'$(gettext 'About')'</label>
				<input file>/usr/share/pixmaps/puppy/about.svg</input><height>22</height><width>22</width>
				<action>gatotray_about &</action>
			</button>
			<button>
				<label>'$(gettext 'Quit')'</label>
				<input file>/usr/share/pixmaps/puppy/quit.svg</input><height>22</height><width>22</width>
				<action>exit:quit_now</action>
			</button>
		</hbox>
	</vbox>
</window>'

export MAIN_DIALOG

case $1 in
	-d | --dump) echo "$MAIN_DIALOG" ;;
	*) gtkdialog --program=MAIN_DIALOG ;;
esac
