/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.js.builtins.FinalizationRegistryCleanupIteratorPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.FinalizationRecord;
import com.oracle.truffle.js.runtime.builtins.JSFinalizationRegistry;
import com.oracle.truffle.js.runtime.objects.Undefined;

public final class FinalizationRegistryCleanupIteratorPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<FinalizationRegistryCleanupIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new FinalizationRegistryCleanupIteratorPrototypeBuiltins();

    protected FinalizationRegistryCleanupIteratorPrototypeBuiltins() {
        super("FinalizationRegistry Cleanup Iterator.prototype", FinalizationRegistryCleanupIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, FinalizationRegistryCleanupIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return FinalizationRegistryCleanupIteratorPrototypeBuiltinsFactory.CleanupNextNodeGen.create(context, builtin, FinalizationRegistryCleanupIteratorPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static abstract class CleanupNextNode
    extends JSBuiltinNode {
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private PropertyGetNode getFinalizationRegistryNode;
        private final BranchProfile errorBranch;

        public CleanupNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
            this.getFinalizationRegistryNode = PropertyGetNode.createGetHidden(JSRuntime.FINALIZATION_GROUP_CLEANUP_ITERATOR_ID, context);
            this.errorBranch = BranchProfile.create();
        }

        @Specialization
        public DynamicObject execute(VirtualFrame frame, Object target) {
            Object finalizationRegistry = this.getFinalizationRegistryNode.getValue(target);
            if (finalizationRegistry == Undefined.instance || !JSFinalizationRegistry.isJSFinalizationRegistry(finalizationRegistry)) {
                this.errorBranch.enter();
                throw Errors.createTypeError("FinalizationRegistry Cleanup iterator required");
            }
            FinalizationRecord record = JSFinalizationRegistry.removeCellEmptyTarget((DynamicObject)finalizationRegistry);
            if (record != null) {
                return this.createIterResultObjectNode.execute(frame, record.getHeldValue(), false);
            }
            return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
        }
    }

    public static enum FinalizationRegistryCleanupIteratorPrototype implements BuiltinEnum<FinalizationRegistryCleanupIteratorPrototype>
    {
        next(0);

        private final int length;

        private FinalizationRegistryCleanupIteratorPrototype(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }
}

