/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.home;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import org.graalvm.nativeimage.ImageInfo;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class HomeFinder {
    public abstract Path getHomeFolder();

    public abstract String getVersion();

    public abstract Map<String, Path> getLanguageHomes();

    public abstract Map<String, Path> getToolHomes();

    public static HomeFinder getInstance() {
        if (ImageInfo.inImageCode()) {
            return ImageSingletons.lookup(HomeFinder.class);
        }
        ServiceLoader<HomeFinder> serviceLoader = ServiceLoader.load(HomeFinder.class);
        Iterator<HomeFinder> iterator = serviceLoader.iterator();
        try {
            return iterator.next();
        }
        catch (NoSuchElementException e) {
            throw new IllegalStateException("No implementation of " + HomeFinder.class.getName() + " could be found");
        }
    }
}

