/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.nfa;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.regex.charset.CP16BitMatchers;
import com.oracle.truffle.regex.tregex.buffer.CompilationBuffer;
import com.oracle.truffle.regex.tregex.matchers.CharMatcher;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.TRegexExecutorNode;
import com.oracle.truffle.regex.tregex.nodes.nfa.TRegexBacktrackingNFAExecutorLocals;
import com.oracle.truffle.regex.tregex.parser.ast.LookAroundAssertion;

public class TRegexLiteralLookAroundExecutorNode
extends TRegexExecutorNode {
    private final boolean forward;
    private final boolean negated;
    @Node.Children
    private CharMatcher[] matchers;

    public TRegexLiteralLookAroundExecutorNode(LookAroundAssertion lookAround, CompilationBuffer compilationBuffer) {
        assert (lookAround.isLiteral());
        this.forward = lookAround.isLookAheadAssertion();
        this.negated = lookAround.isNegated();
        this.matchers = new CharMatcher[lookAround.getLiteralLength()];
        for (int i = 0; i < this.matchers.length; ++i) {
            CharMatcher matcher = CP16BitMatchers.createMatcher(lookAround.getGroup().getFirstAlternative().get(i).asCharacterClass().getCharSet(), compilationBuffer);
            this.matchers[this.forward ? i : this.matchers.length - (i + 1)] = (CharMatcher)this.insert(matcher);
        }
    }

    @Override
    public boolean writesCaptureGroups() {
        return false;
    }

    @Override
    public TRegexExecutorLocals createLocals(Object input, int fromIndex, int index, int maxIndex) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new UnsupportedOperationException();
    }

    @Override
    @ExplodeLoop
    public Object execute(TRegexExecutorLocals abstractLocals, boolean compactString) {
        TRegexBacktrackingNFAExecutorLocals locals = (TRegexBacktrackingNFAExecutorLocals)abstractLocals;
        int index = locals.getIndex();
        for (int i = 0; i < this.matchers.length; ++i) {
            int iChar;
            int n = iChar = this.forward ? index + i : index - i;
            if (this.inputBoundsCheck(iChar, 0, locals.getMaxIndex()) && this.matchers[i].execute(this.inputGetChar(locals, iChar), compactString)) continue;
            return this.negated;
        }
        return !this.negated;
    }

    private char inputGetChar(TRegexBacktrackingNFAExecutorLocals locals, int index) {
        return this.forward ? this.getCharAt(locals, index) : this.getCharAt(locals, index - 1);
    }

    private boolean inputBoundsCheck(int i, int min, int max) {
        return this.forward ? i < max : i > min;
    }
}

