/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.tregex.nodes.dfa;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.regex.tregex.nodes.dfa.DFAStateNode;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorLocals;
import com.oracle.truffle.regex.tregex.nodes.dfa.TRegexDFAExecutorNode;

public final class AllTransitionsInOneTreeMatcher {
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final char[] sortedRanges;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final short[] rangeTreeSuccessors;

    public AllTransitionsInOneTreeMatcher(char[] sortedRanges, short[] rangeTreeSuccessors) {
        assert (sortedRanges.length > 0) : "This class should never be used for trivial transitions, use a list of CharMatchers instead!";
        assert (rangeTreeSuccessors.length == sortedRanges.length + 1);
        this.sortedRanges = sortedRanges;
        this.rangeTreeSuccessors = rangeTreeSuccessors;
    }

    public int checkMatchTree(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, DFAStateNode stateNode, char c) {
        CompilerAsserts.partialEvaluationConstant((Object)this);
        CompilerAsserts.partialEvaluationConstant((Object)stateNode);
        return this.checkMatchTree(locals, executor, stateNode, 0, this.sortedRanges.length - 1, c);
    }

    private int checkMatchTree(TRegexDFAExecutorLocals locals, TRegexDFAExecutorNode executor, DFAStateNode stateNode, int fromIndex, int toIndex, char c) {
        CompilerAsserts.partialEvaluationConstant((Object)stateNode);
        CompilerAsserts.partialEvaluationConstant((int)fromIndex);
        CompilerAsserts.partialEvaluationConstant((int)toIndex);
        if (fromIndex > toIndex) {
            short successor = this.rangeTreeSuccessors[fromIndex];
            if (successor != -1) {
                stateNode.successorFound(locals, executor, successor);
            }
            return successor;
        }
        int mid = fromIndex + toIndex >>> 1;
        CompilerAsserts.partialEvaluationConstant((int)mid);
        if (c < this.sortedRanges[mid]) {
            return this.checkMatchTree(locals, executor, stateNode, fromIndex, mid - 1, c);
        }
        return this.checkMatchTree(locals, executor, stateNode, mid + 1, toIndex, c);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        StringBuilder sb = new StringBuilder("AllTransitionsInOneTreeMatcher: [");
        boolean first = true;
        for (char c : this.sortedRanges) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            if (c > '\u00ff') {
                sb.append(String.format("%04x", c));
                continue;
            }
            sb.append(String.format("%02x", c));
        }
        sb.append("]");
        return sb.toString();
    }
}

