/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.profiles;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.profiles.Profile;

public abstract class DoubleValueProfile
extends Profile {
    DoubleValueProfile() {
    }

    public abstract double profile(double var1);

    public static DoubleValueProfile createRawIdentityProfile() {
        if (Profile.isProfilingEnabled()) {
            return Enabled.create();
        }
        return Disabled.INSTANCE;
    }

    public static DoubleValueProfile getUncached() {
        return Disabled.INSTANCE;
    }

    static final class Disabled
    extends DoubleValueProfile {
        static final DoubleValueProfile INSTANCE = new Disabled();

        Disabled() {
        }

        @Override
        protected Object clone() {
            return INSTANCE;
        }

        @Override
        public double profile(double value) {
            return value;
        }

        public String toString() {
            return this.toStringDisabled(DoubleValueProfile.class);
        }
    }

    static final class Enabled
    extends DoubleValueProfile {
        private static final byte UNINITIALIZED = 0;
        private static final byte SPECIALIZED = 1;
        private static final byte GENERIC = 2;
        @CompilerDirectives.CompilationFinal
        private double cachedValue;
        @CompilerDirectives.CompilationFinal
        private long cachedRawValue;
        @CompilerDirectives.CompilationFinal
        private byte state = 0;

        Enabled() {
        }

        @Override
        public double profile(double value) {
            byte localState = this.state;
            if (localState != 2) {
                if (localState == 1 && this.cachedRawValue == Double.doubleToRawLongBits(value)) {
                    return this.cachedValue;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                if (localState == 0) {
                    this.cachedValue = value;
                    this.cachedRawValue = Double.doubleToRawLongBits(value);
                    this.state = 1;
                } else {
                    this.state = (byte)2;
                }
            }
            return value;
        }

        boolean isGeneric() {
            return this.state == 2;
        }

        boolean isUninitialized() {
            return this.state == 0;
        }

        double getCachedValue() {
            return this.cachedValue;
        }

        public String toString() {
            return this.toString(DoubleValueProfile.class, this.state == 0, this.state == 2, String.format("value == (double)%s (raw %h)", this.cachedValue, this.cachedRawValue));
        }

        static DoubleValueProfile create() {
            return new Enabled();
        }
    }
}

