/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.maven.plugin.surefire.report.ReportEntryType;
import org.apache.maven.plugin.surefire.report.TestMethodStats;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.Utf8RecodingDeferredFileOutputStream;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.plugin.surefire.runorder.StatisticsReporter;
import org.apache.maven.surefire.api.report.ReportEntry;
import org.apache.maven.surefire.api.report.TestOutputReportEntry;
import org.apache.maven.surefire.api.report.TestReportListener;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.extensions.ConsoleOutputReportEventListener;
import org.apache.maven.surefire.extensions.StatelessReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoConsoleReportEventListener;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoFileReportEventListener;

public class TestSetRunListener
implements TestReportListener<TestOutputReportEntry> {
    private final Queue<TestMethodStats> testMethodStats = new ConcurrentLinkedQueue<TestMethodStats>();
    private final TestSetStats detailsForThis;
    private final ConsoleOutputReportEventListener testOutputReceiver;
    private final boolean briefOrPlainFormat;
    private final StatelessReportEventListener<WrappedReportEntry, TestSetStats> simpleXMLReporter;
    private final StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> consoleReporter;
    private final StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> fileReporter;
    private final StatisticsReporter statisticsReporter;
    private final Object lock;
    private Utf8RecodingDeferredFileOutputStream testStdOut = TestSetRunListener.initDeferred("stdout");
    private Utf8RecodingDeferredFileOutputStream testStdErr = TestSetRunListener.initDeferred("stderr");

    public TestSetRunListener(StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> consoleReporter, StatelessTestsetInfoFileReportEventListener<WrappedReportEntry, TestSetStats> fileReporter, StatelessReportEventListener<WrappedReportEntry, TestSetStats> simpleXMLReporter, ConsoleOutputReportEventListener testOutputReceiver, StatisticsReporter statisticsReporter, boolean trimStackTrace, boolean isPlainFormat, boolean briefOrPlainFormat, Object lock) {
        this.consoleReporter = consoleReporter;
        this.fileReporter = fileReporter;
        this.statisticsReporter = statisticsReporter;
        this.simpleXMLReporter = simpleXMLReporter;
        this.testOutputReceiver = testOutputReceiver;
        this.briefOrPlainFormat = briefOrPlainFormat;
        this.detailsForThis = new TestSetStats(trimStackTrace, isPlainFormat);
        this.lock = lock;
    }

    public boolean isDebugEnabled() {
        return this.consoleReporter.getConsoleLogger().isDebugEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debug(String message) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleReporter.getConsoleLogger().debug(TestSetRunListener.trimTrailingNewLine(message));
        }
    }

    public boolean isInfoEnabled() {
        return this.consoleReporter.getConsoleLogger().isInfoEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void info(String message) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleReporter.getConsoleLogger().info(TestSetRunListener.trimTrailingNewLine(message));
        }
    }

    public boolean isWarnEnabled() {
        return this.consoleReporter.getConsoleLogger().isWarnEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warning(String message) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleReporter.getConsoleLogger().warning(TestSetRunListener.trimTrailingNewLine(message));
        }
    }

    public boolean isErrorEnabled() {
        return this.consoleReporter.getConsoleLogger().isErrorEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String message) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleReporter.getConsoleLogger().error(TestSetRunListener.trimTrailingNewLine(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(String message, Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleReporter.getConsoleLogger().error(TestSetRunListener.trimTrailingNewLine(message), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(Throwable t) {
        Object object = this.lock;
        synchronized (object) {
            this.consoleReporter.getConsoleLogger().error(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTestOutput(TestOutputReportEntry reportEntry) {
        try {
            Object object = this.lock;
            synchronized (object) {
                Utf8RecodingDeferredFileOutputStream stream = reportEntry.isStdOut() ? this.testStdOut : this.testStdErr;
                stream.write(reportEntry.getLog(), reportEntry.isNewLine());
                this.testOutputReceiver.writeTestOutput(reportEntry);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void testSetStarting(TestSetReportEntry report) {
        this.detailsForThis.testSetStart();
        this.consoleReporter.testSetStarting(report);
        this.testOutputReceiver.testSetStarting(report);
    }

    private void clearCapture() {
        this.testStdOut = TestSetRunListener.initDeferred("stdout");
        this.testStdErr = TestSetRunListener.initDeferred("stderr");
    }

    public void testSetCompleted(TestSetReportEntry report) {
        WrappedReportEntry wrap = this.wrapTestSet(report);
        List testResults = this.briefOrPlainFormat ? this.detailsForThis.getTestResults() : Collections.emptyList();
        this.fileReporter.testSetCompleted((TestSetReportEntry)wrap, (Object)this.detailsForThis, testResults);
        this.simpleXMLReporter.testSetCompleted((TestSetReportEntry)wrap, (Object)this.detailsForThis);
        this.statisticsReporter.testSetCompleted();
        this.consoleReporter.testSetCompleted((TestSetReportEntry)wrap, (Object)this.detailsForThis, testResults);
        this.testOutputReceiver.testSetCompleted((TestSetReportEntry)wrap);
        this.consoleReporter.reset();
        wrap.getStdout().free();
        wrap.getStdErr().free();
        this.addTestMethodStats();
        this.detailsForThis.reset();
        this.clearCapture();
    }

    public void testStarting(ReportEntry report) {
        this.detailsForThis.testStart();
    }

    public void testSucceeded(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.SUCCESS);
        this.detailsForThis.testSucceeded(wrapped);
        this.statisticsReporter.testSucceeded(reportEntry);
        this.clearCapture();
    }

    public void testError(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.ERROR);
        this.detailsForThis.testError(wrapped);
        this.statisticsReporter.testError(reportEntry);
        this.clearCapture();
    }

    public void testFailed(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.FAILURE);
        this.detailsForThis.testFailure(wrapped);
        this.statisticsReporter.testFailed(reportEntry);
        this.clearCapture();
    }

    public void testSkipped(ReportEntry reportEntry) {
        WrappedReportEntry wrapped = this.wrap(reportEntry, ReportEntryType.SKIPPED);
        this.detailsForThis.testSkipped(wrapped);
        this.statisticsReporter.testSkipped(reportEntry);
        this.clearCapture();
    }

    public void testExecutionSkippedByUser() {
    }

    public void testAssumptionFailure(ReportEntry report) {
        this.testSkipped(report);
    }

    private WrappedReportEntry wrap(ReportEntry other, ReportEntryType reportEntryType) {
        int estimatedElapsed = 0;
        if (reportEntryType != ReportEntryType.SKIPPED) {
            Integer etime = other.getElapsed();
            estimatedElapsed = etime == null ? this.detailsForThis.getElapsedSinceLastStart() : etime.intValue();
        }
        return new WrappedReportEntry(other, reportEntryType, estimatedElapsed, this.testStdOut, this.testStdErr);
    }

    private WrappedReportEntry wrapTestSet(TestSetReportEntry other) {
        return new WrappedReportEntry((ReportEntry)other, null, other.getElapsed() != null ? other.getElapsed().intValue() : this.detailsForThis.getElapsedSinceTestSetStart(), this.testStdOut, this.testStdErr, other.getSystemProperties());
    }

    public void close() {
        this.testOutputReceiver.close();
    }

    private void addTestMethodStats() {
        for (WrappedReportEntry reportEntry : this.detailsForThis.getReportEntries()) {
            TestMethodStats methodStats = new TestMethodStats(reportEntry.getClassMethodName(), reportEntry.getReportEntryType(), reportEntry.getStackTraceWriter());
            this.testMethodStats.add(methodStats);
        }
    }

    public Queue<TestMethodStats> getTestMethodStats() {
        return this.testMethodStats;
    }

    private static String trimTrailingNewLine(String message) {
        int e = message == null ? 0 : TestSetRunListener.lineBoundSymbolWidth(message);
        return message != null && e != 0 ? message.substring(0, message.length() - e) : message;
    }

    private static int lineBoundSymbolWidth(String message) {
        return message.endsWith("\r\n") ? 2 : (message.endsWith("\n") || message.endsWith("\r") ? 1 : 0);
    }

    private static Utf8RecodingDeferredFileOutputStream initDeferred(String channel) {
        return new Utf8RecodingDeferredFileOutputStream(channel);
    }
}

