/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.media.tags.internal;

import com.vladsch.flexmark.ext.media.tags.AudioLink;
import com.vladsch.flexmark.ext.media.tags.EmbedLink;
import com.vladsch.flexmark.ext.media.tags.PictureLink;
import com.vladsch.flexmark.ext.media.tags.VideoLink;
import com.vladsch.flexmark.ext.media.tags.internal.Utilities;
import com.vladsch.flexmark.html.CustomNodeRenderer;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.LinkType;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.html.renderer.ResolvedLink;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.options.DataHolder;
import java.util.HashSet;
import java.util.Set;

public class MediaTagsNodeRenderer
implements NodeRenderer {
    public MediaTagsNodeRenderer(DataHolder options) {
    }

    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        final MediaTagsNodeRenderer self = this;
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler(AudioLink.class, (CustomNodeRenderer)new CustomNodeRenderer<AudioLink>(){

            public void render(AudioLink node, NodeRendererContext context, HtmlWriter html) {
                self.renderAudioLink(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(EmbedLink.class, (CustomNodeRenderer)new CustomNodeRenderer<EmbedLink>(){

            public void render(EmbedLink node, NodeRendererContext context, HtmlWriter html) {
                self.renderEmbedLink(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(PictureLink.class, (CustomNodeRenderer)new CustomNodeRenderer<PictureLink>(){

            public void render(PictureLink node, NodeRendererContext context, HtmlWriter html) {
                self.renderPictureLink(node, context, html);
            }
        }));
        set.add(new NodeRenderingHandler(VideoLink.class, (CustomNodeRenderer)new CustomNodeRenderer<VideoLink>(){

            public void render(VideoLink node, NodeRendererContext context, HtmlWriter html) {
                self.renderVideoLink(node, context, html);
            }
        }));
        return set;
    }

    private void renderAudioLink(AudioLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), Boolean.valueOf(false));
            String[] sources = resolvedLink.getUrl().split("\\|");
            ((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"title", (CharSequence)node.getText())).attr((CharSequence)"controls", null)).withAttr().tag((CharSequence)"audio");
            for (String source : sources) {
                String encoded = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl((CharSequence)source) : source;
                String type = Utilities.resolveAudioType(source);
                html.attr((CharSequence)"src", (CharSequence)encoded);
                if (type != null) {
                    html.attr((CharSequence)"type", (CharSequence)type);
                }
                html.withAttr().tag((CharSequence)"source", true);
            }
            html.text((CharSequence)"Your browser does not support the audio element.");
            html.tag((CharSequence)"/audio");
        }
    }

    private void renderEmbedLink(EmbedLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), null);
            ((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"title", (CharSequence)node.getText())).attr((CharSequence)"src", (CharSequence)resolvedLink.getUrl())).withAttr().tag((CharSequence)"embed", true);
        }
    }

    private void renderPictureLink(PictureLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            String encoded;
            String source;
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), Boolean.valueOf(false));
            String[] sources = resolvedLink.getUrl().split("\\|");
            html.tag((CharSequence)"picture");
            for (int index = 0; index < sources.length - 1; ++index) {
                source = sources[index];
                encoded = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl((CharSequence)source) : source;
                ((HtmlWriter)html.attr((CharSequence)"srcset", (CharSequence)encoded)).withAttr().tag((CharSequence)"source", true);
            }
            int last = sources.length - 1;
            if (last >= 0) {
                source = sources[last];
                encoded = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl((CharSequence)source) : source;
                ((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"src", (CharSequence)encoded)).attr((CharSequence)"alt", (CharSequence)node.getText())).withAttr().tag((CharSequence)"img", true);
            }
            html.tag((CharSequence)"/picture");
        }
    }

    private void renderVideoLink(VideoLink node, NodeRendererContext context, HtmlWriter html) {
        if (context.isDoNotRenderLinks()) {
            context.renderChildren((Node)node);
        } else {
            ResolvedLink resolvedLink = context.resolveLink(LinkType.LINK, (CharSequence)node.getUrl().unescape(), Boolean.valueOf(false));
            String[] sources = resolvedLink.getUrl().split("\\|");
            ((HtmlWriter)((HtmlWriter)html.attr((CharSequence)"title", (CharSequence)node.getText())).attr((CharSequence)"controls", null)).withAttr().tag((CharSequence)"video");
            for (String source : sources) {
                String encoded = context.getHtmlOptions().percentEncodeUrls ? context.encodeUrl((CharSequence)source) : source;
                String type = Utilities.resolveVideoType(source);
                html.attr((CharSequence)"src", (CharSequence)encoded);
                if (type != null) {
                    html.attr((CharSequence)"type", (CharSequence)type);
                }
                html.withAttr().tag((CharSequence)"source", true);
            }
            html.text((CharSequence)"Your browser does not support the video element.");
            html.tag((CharSequence)"/video");
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        public NodeRenderer create(DataHolder options) {
            return new MediaTagsNodeRenderer(options);
        }
    }
}

