/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.builtins.FinalizationRegistryCleanupIteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.FinalizationRegistryPrototypeBuiltins;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.Symbol;
import com.oracle.truffle.js.runtime.builtins.FinalizationRecord;
import com.oracle.truffle.js.runtime.builtins.JSBuiltinObject;
import com.oracle.truffle.js.runtime.builtins.JSClass;
import com.oracle.truffle.js.runtime.builtins.JSConstructor;
import com.oracle.truffle.js.runtime.builtins.JSConstructorFactory;
import com.oracle.truffle.js.runtime.builtins.JSObjectFactory;
import com.oracle.truffle.js.runtime.builtins.JSUserObject;
import com.oracle.truffle.js.runtime.builtins.PrototypeSupplier;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Undefined;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;

public final class JSFinalizationRegistry
extends JSBuiltinObject
implements JSConstructorFactory.Default,
PrototypeSupplier {
    public static final JSFinalizationRegistry INSTANCE = new JSFinalizationRegistry();
    public static final String CLASS_NAME = "FinalizationRegistry";
    public static final String PROTOTYPE_NAME = "FinalizationRegistry.prototype";
    public static final String CLEANUP_ITERATOR_CLASS_NAME = "FinalizationRegistry Cleanup Iterator";
    public static final String CLEANUP_ITERATOR_PROTOTYPE_NAME = "FinalizationRegistry Cleanup Iterator.prototype";
    private static final HiddenKey REALM_ID = new HiddenKey("realm");
    private static final Property REALM_PROPERTY;
    private static final HiddenKey CLEANUP_CALLBACK_ID;
    private static final Property CLEANUP_CALLBACK_PROPERTY;
    private static final HiddenKey CELLS_ID;
    private static final Property CELLS_PROPERTY;
    private static final HiddenKey CLEANUP_JOB_ACTIVE_ID;
    private static final Property CLEANUP_JOB_ACTIVE_PROPERTY;
    private static final HiddenKey REFERENCE_QUEUE_ID;
    private static final Property REFERENCE_QUEUE_PROPERTY;
    public static final HiddenKey FINALIZATION_REGISTRY_ID;

    private JSFinalizationRegistry() {
    }

    public static DynamicObject create(JSContext context, TruffleObject cleanupCallback) {
        DynamicObject obj = JSObject.create(context, context.getFinalizationRegistryFactory(), context.getRealm(), cleanupCallback, new ArrayList(), false, new ReferenceQueue());
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        context.getRealm().getAgent().registerFinalizationRegistry(obj);
        return obj;
    }

    private static JSRealm getRealm(DynamicObject obj) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        return (JSRealm)REALM_PROPERTY.get(obj, JSFinalizationRegistry.isJSFinalizationRegistry(obj));
    }

    private static List<FinalizationRecord> getCells(DynamicObject obj) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        return (List)CELLS_PROPERTY.get(obj, JSFinalizationRegistry.isJSFinalizationRegistry(obj));
    }

    public static void setCleanupJobActive(DynamicObject obj, boolean value) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        CLEANUP_JOB_ACTIVE_PROPERTY.setSafe(obj, (Object)value, null);
    }

    public static boolean isCleanupJobActive(DynamicObject obj) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        return (Boolean)CLEANUP_JOB_ACTIVE_PROPERTY.get(obj, JSFinalizationRegistry.isJSFinalizationRegistry(obj));
    }

    public static void setCleanupCallback(DynamicObject obj, boolean value) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        CLEANUP_CALLBACK_PROPERTY.setSafe(obj, (Object)value, null);
    }

    public static DynamicObject getCleanupCallback(DynamicObject obj) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        return (DynamicObject)CLEANUP_CALLBACK_PROPERTY.get(obj, JSFinalizationRegistry.isJSFinalizationRegistry(obj));
    }

    public static ReferenceQueue<Object> getReferenceQueue(DynamicObject obj) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(obj));
        return (ReferenceQueue)REFERENCE_QUEUE_PROPERTY.get(obj, JSFinalizationRegistry.isJSFinalizationRegistry(obj));
    }

    @Override
    public DynamicObject createPrototype(JSRealm realm, DynamicObject ctor) {
        JSContext ctx = realm.getContext();
        DynamicObject prototype = JSObject.createInit(realm, realm.getObjectPrototype(), (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putConstructorProperty(ctx, prototype, ctor);
        JSObjectUtil.putFunctionsFromContainer(realm, prototype, FinalizationRegistryPrototypeBuiltins.BUILTINS);
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_TO_STRING_TAG, CLASS_NAME, JSAttributes.configurableNotEnumerableNotWritable());
        JSObjectUtil.putDataProperty(ctx, prototype, Symbol.SYMBOL_ITERATOR, prototype.get((Object)"entries"), JSAttributes.getDefaultNotEnumerable());
        return prototype;
    }

    @Override
    public Shape makeInitialShape(JSContext context, DynamicObject prototype) {
        Shape initialShape = JSObjectUtil.getProtoChildShape(prototype, INSTANCE, context);
        initialShape = initialShape.addProperty(REALM_PROPERTY);
        initialShape = initialShape.addProperty(CLEANUP_CALLBACK_PROPERTY);
        initialShape = initialShape.addProperty(CELLS_PROPERTY);
        initialShape = initialShape.addProperty(CLEANUP_JOB_ACTIVE_PROPERTY);
        initialShape = initialShape.addProperty(REFERENCE_QUEUE_PROPERTY);
        return initialShape;
    }

    public static JSConstructor createConstructor(JSRealm realm) {
        return INSTANCE.createConstructorAndPrototype(realm);
    }

    @Override
    public String getClassName() {
        return CLASS_NAME;
    }

    @Override
    public String getClassName(DynamicObject object) {
        return this.getClassName();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public String safeToString(DynamicObject obj, int depth, JSContext context) {
        return "[" + this.getClassName() + "]";
    }

    public static boolean isJSFinalizationRegistry(Object obj) {
        return JSObject.isDynamicObject(obj) && JSFinalizationRegistry.isJSFinalizationRegistry((DynamicObject)obj);
    }

    public static boolean isJSFinalizationRegistry(DynamicObject obj) {
        return JSFinalizationRegistry.isInstance(obj, (JSClass)INSTANCE);
    }

    @Override
    public DynamicObject getIntrinsicDefaultProto(JSRealm realm) {
        return realm.getFinalizationRegistryPrototype();
    }

    public static void appendToCells(DynamicObject finalizationRegistry, Object target, Object holdings, Object unregisterToken) {
        List<FinalizationRecord> cells = JSFinalizationRegistry.getCells(finalizationRegistry);
        ReferenceQueue<Object> queue = JSFinalizationRegistry.getReferenceQueue(finalizationRegistry);
        WeakReference<Object> weakTarget = new WeakReference<Object>(target, queue);
        cells.add(new FinalizationRecord(weakTarget, holdings, unregisterToken));
    }

    public static boolean removeFromCells(DynamicObject finalizationRegistry, Object unregisterToken) {
        List<FinalizationRecord> cells = JSFinalizationRegistry.getCells(finalizationRegistry);
        boolean removed = false;
        Iterator<FinalizationRecord> iterator = cells.iterator();
        while (iterator.hasNext()) {
            FinalizationRecord record = iterator.next();
            if (!JSRuntime.isSameValue(record.getUnregisterToken().get(), unregisterToken)) continue;
            iterator.remove();
            removed = true;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cleanupFinalizationRegistry(JSContext context, DynamicObject finalizationRegistry, Object callbackArg) {
        assert (callbackArg != null);
        if (!JSFinalizationRegistry.checkForEmptyCells(finalizationRegistry)) {
            return;
        }
        DynamicObject iterator = JSFinalizationRegistry.createFinalizationRegistryCleanupIterator(context, finalizationRegistry);
        Object callback = callbackArg == Undefined.instance ? JSFinalizationRegistry.getCleanupCallback(finalizationRegistry) : callbackArg;
        JSFinalizationRegistry.setCleanupJobActive(finalizationRegistry, true);
        try {
            JSRuntime.call(callback, Undefined.instance, new Object[]{iterator});
        }
        finally {
            JSFinalizationRegistry.setCleanupJobActive(finalizationRegistry, false);
            iterator.define((Object)JSRuntime.FINALIZATION_GROUP_CLEANUP_ITERATOR_ID, (Object)Undefined.instance);
        }
    }

    private static DynamicObject createFinalizationRegistryCleanupIterator(JSContext context, DynamicObject finalizationRegistry) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(finalizationRegistry));
        JSObjectFactory factory = context.getFinalizationRegistryCleanupIteratorFactory();
        DynamicObject iterator = JSObject.create(context, factory, finalizationRegistry);
        return iterator;
    }

    private static boolean checkForEmptyCells(DynamicObject finalizationRegistry) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(finalizationRegistry));
        List<FinalizationRecord> cells = JSFinalizationRegistry.getCells(finalizationRegistry);
        for (FinalizationRecord record : cells) {
            if (record.getWeakRefTarget().get() != null) continue;
            return true;
        }
        return false;
    }

    public static FinalizationRecord removeCellEmptyTarget(DynamicObject finalizationRegistry) {
        assert (JSFinalizationRegistry.isJSFinalizationRegistry(finalizationRegistry));
        List<FinalizationRecord> cells = JSFinalizationRegistry.getCells(finalizationRegistry);
        for (int i = 0; i < cells.size(); ++i) {
            FinalizationRecord record = cells.get(i);
            if (record.getWeakRefTarget().get() != null) continue;
            cells.remove(i);
            return record;
        }
        return null;
    }

    public static DynamicObject createCleanupIteratorPrototype(JSRealm realm) {
        DynamicObject iteratorPrototype = realm.getIteratorPrototype();
        DynamicObject cleanupIteratorPrototype = JSObject.createInit(realm, iteratorPrototype, (JSClass)JSUserObject.INSTANCE);
        JSObjectUtil.putFunctionsFromContainer(realm, cleanupIteratorPrototype, FinalizationRegistryCleanupIteratorPrototypeBuiltins.BUILTINS);
        return cleanupIteratorPrototype;
    }

    public static Shape makeInitialCleanupIteratorShape(JSContext context, DynamicObject cleanupIteratorPrototype) {
        Property finalizationRegistryProperty = JSObjectUtil.makeHiddenProperty(JSRuntime.FINALIZATION_GROUP_CLEANUP_ITERATOR_ID, JSShape.makeAllocator(JSObject.LAYOUT).locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        return JSObjectUtil.getProtoChildShape(cleanupIteratorPrototype, JSUserObject.INSTANCE, context).addProperty(finalizationRegistryProperty);
    }

    public static void hostCleanupFinalizationRegistry(DynamicObject finalizationRegistry) {
        ReferenceQueue<Object> queue = JSFinalizationRegistry.getReferenceQueue(finalizationRegistry);
        while (queue.poll() != null) {
            JSFinalizationRegistry.cleanupFinalizationRegistry(JSFinalizationRegistry.getRealm(finalizationRegistry).getContext(), finalizationRegistry, Undefined.instance);
        }
    }

    static {
        CLEANUP_CALLBACK_ID = new HiddenKey("cleanup_callback");
        CELLS_ID = new HiddenKey("cells");
        CLEANUP_JOB_ACTIVE_ID = new HiddenKey("cleanup_job_active");
        REFERENCE_QUEUE_ID = new HiddenKey("reference_queue");
        FINALIZATION_REGISTRY_ID = new HiddenKey(CLASS_NAME);
        Shape.Allocator allocator = JSShape.makeAllocator(JSObject.LAYOUT);
        REALM_PROPERTY = JSObjectUtil.makeHiddenProperty(REALM_ID, allocator.locationForType(JSRealm.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        CLEANUP_CALLBACK_PROPERTY = JSObjectUtil.makeHiddenProperty(CLEANUP_CALLBACK_ID, allocator.locationForType(DynamicObject.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        CELLS_PROPERTY = JSObjectUtil.makeHiddenProperty(CELLS_ID, allocator.locationForType(List.class, EnumSet.of(LocationModifier.Final, LocationModifier.NonNull)));
        CLEANUP_JOB_ACTIVE_PROPERTY = JSObjectUtil.makeHiddenProperty(CLEANUP_JOB_ACTIVE_ID, allocator.locationForType(Boolean.TYPE, EnumSet.of(LocationModifier.NonNull)));
        REFERENCE_QUEUE_PROPERTY = JSObjectUtil.makeHiddenProperty(REFERENCE_QUEUE_ID, allocator.locationForType(ReferenceQueue.class, EnumSet.of(LocationModifier.NonNull)));
    }
}

