/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.builtins;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.object.LocationModifier;
import com.oracle.truffle.api.object.ObjectType;
import com.oracle.truffle.api.object.Property;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.array.ScriptArray;
import com.oracle.truffle.js.runtime.builtins.JSAbstractArray;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.builtins.JSSlowArgumentsObject;
import com.oracle.truffle.js.runtime.objects.JSAttributes;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.JSObjectUtil;
import com.oracle.truffle.js.runtime.objects.JSShape;
import com.oracle.truffle.js.runtime.objects.Null;
import com.oracle.truffle.js.runtime.objects.PropertyDescriptor;
import com.oracle.truffle.js.runtime.util.DefinePropertyUtil;
import java.util.EnumSet;
import java.util.HashMap;

public abstract class JSAbstractArgumentsObject
extends JSAbstractArray {
    protected static final String CALLEE = "callee";
    protected static final String CALLER = "caller";
    private static final String CLASS_NAME = "Arguments";
    private static final HiddenKey CONNECTED_ARGUMENT_COUNT_ID = new HiddenKey("connectedArgumentCount");
    private static final HiddenKey DISCONNECTED_INDICES_ID = new HiddenKey("disconnectedIndices");
    protected static final Property CONNECTED_ARGUMENT_COUNT_PROPERTY;

    @Override
    @CompilerDirectives.TruffleBoundary
    public long getLength(DynamicObject thisObj) {
        return JSRuntime.toInteger(JSRuntime.toNumber(this.get(thisObj, "length")));
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, long index, boolean isStrict) {
        this.makeSlowArray(thisObj);
        return JSObject.delete(thisObj, index, isStrict);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean delete(DynamicObject thisObj, Object key, boolean isStrict) {
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (index >= 0L && JSRuntime.isArrayIndex(index)) {
            return this.delete(thisObj, index, isStrict);
        }
        return super.delete(thisObj, key, isStrict);
    }

    @Override
    public String getClassName(DynamicObject object) {
        return CLASS_NAME;
    }

    @Override
    protected DynamicObject makeSlowArray(DynamicObject thisObj) {
        CompilerAsserts.neverPartOfCompilation((String)"do not convert to slow array from compiled code");
        assert (JSArgumentsObject.isJSFastArgumentsObject(thisObj));
        Shape oldShape = thisObj.getShape();
        thisObj.setShapeAndGrow(oldShape, oldShape.changeType((ObjectType)JSSlowArgumentsObject.INSTANCE));
        thisObj.define((Object)DISCONNECTED_INDICES_ID, new HashMap(), 0);
        JSObject.getJSContext(thisObj).getFastArgumentsObjectAssumption().invalidate("create slow ArgumentsObject");
        return thisObj;
    }

    public static int getConnectedArgumentCount(DynamicObject argumentsArray) {
        assert (JSArgumentsObject.isJSArgumentsObject(argumentsArray));
        return (Integer)CONNECTED_ARGUMENT_COUNT_PROPERTY.get(argumentsArray, JSArgumentsObject.isJSArgumentsObject(argumentsArray));
    }

    @CompilerDirectives.TruffleBoundary
    private static HashMap<Long, Object> getDisconnectedIndices(DynamicObject argumentsArray) {
        assert (JSAbstractArgumentsObject.hasDisconnectedIndices(argumentsArray));
        return (HashMap)argumentsArray.get((Object)DISCONNECTED_INDICES_ID, null);
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean wasIndexDisconnected(DynamicObject argumentsArray, long index) {
        assert (JSAbstractArgumentsObject.hasDisconnectedIndices(argumentsArray));
        return JSAbstractArgumentsObject.getDisconnectedIndices(argumentsArray).containsKey(index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getDisconnectedIndexValue(DynamicObject argumentsArray, long index) {
        assert (JSAbstractArgumentsObject.hasDisconnectedIndices(argumentsArray));
        assert (JSAbstractArgumentsObject.wasIndexDisconnected(argumentsArray, index));
        return JSAbstractArgumentsObject.getDisconnectedIndices(argumentsArray).get(index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object setDisconnectedIndexValue(DynamicObject argumentsArray, long index, Object value) {
        assert (JSAbstractArgumentsObject.hasDisconnectedIndices(argumentsArray));
        assert (JSAbstractArgumentsObject.wasIndexDisconnected(argumentsArray, index));
        JSAbstractArgumentsObject.getDisconnectedIndices(argumentsArray).put(index, value);
        return value;
    }

    @CompilerDirectives.TruffleBoundary
    public static void disconnectIndex(DynamicObject argumentsArray, long index, Object oldValue) {
        if (!JSAbstractArgumentsObject.hasDisconnectedIndices(argumentsArray)) {
            JSArgumentsObject.INSTANCE.makeSlowArray(argumentsArray);
        }
        JSAbstractArgumentsObject.getDisconnectedIndices(argumentsArray).put(index, oldValue);
    }

    public static boolean hasDisconnectedIndices(DynamicObject argumentsArray) {
        return JSSlowArgumentsObject.isJSSlowArgumentsObject(argumentsArray);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean defineOwnProperty(DynamicObject thisObj, Object key, PropertyDescriptor descriptor, boolean doThrow) {
        boolean allowed;
        this.makeSlowArray(thisObj);
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        Object oldValue = null;
        boolean isMapped = false;
        if (index >= 0L) {
            oldValue = super.get(thisObj, index);
            isMapped = !JSAbstractArgumentsObject.wasIndexDisconnected(thisObj, index);
            ScriptArray arrayType = JSAbstractArgumentsObject.arrayGetArrayType(thisObj, JSArgumentsObject.isJSArgumentsObject(thisObj));
            if (arrayType.hasElement(thisObj, index)) {
                JSContext context = JSObject.getJSContext(thisObj);
                JSObjectUtil.putDataProperty(context, thisObj, key, this.get(thisObj, index), JSAttributes.getDefault());
                if (arrayType.canDeleteElement(thisObj, index, false)) {
                    JSAbstractArgumentsObject.arraySetArrayType(thisObj, arrayType.deleteElement(thisObj, index, false));
                }
            }
        }
        if (!(allowed = DefinePropertyUtil.ordinaryDefineOwnProperty(thisObj, key, descriptor, doThrow))) {
            return DefinePropertyUtil.reject(doThrow, "not allowed to defineProperty on an arguments object");
        }
        if (isMapped && key instanceof String) {
            JSAbstractArgumentsObject.definePropertyMapped(thisObj, (String)key, descriptor, index, oldValue, thisObj);
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    private static void definePropertyMapped(DynamicObject thisObj, String name, PropertyDescriptor descriptor, long index, Object oldValueParam, DynamicObject obj) {
        if (descriptor.isAccessorDescriptor()) {
            JSAbstractArgumentsObject.disconnectIndex(thisObj, index, oldValueParam);
        } else {
            Object value;
            Object oldValue = oldValueParam;
            if (descriptor.hasValue()) {
                value = descriptor.getValue();
                JSObject.set(obj, name, value);
                oldValue = value;
            }
            if (descriptor.hasWritable() && Boolean.FALSE.equals(value = Boolean.valueOf(descriptor.getWritable()))) {
                JSAbstractArgumentsObject.disconnectIndex(thisObj, index, oldValue);
            }
        }
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public PropertyDescriptor getOwnProperty(DynamicObject thisObj, Object key) {
        assert (JSRuntime.isPropertyKey(key));
        PropertyDescriptor desc = JSAbstractArgumentsObject.ordinaryGetOwnPropertyArray(thisObj, key);
        if (desc == null) {
            return null;
        }
        long index = JSRuntime.propertyKeyToArrayIndex(key);
        if (index >= 0L) {
            boolean isMapped;
            boolean bl = isMapped = JSArgumentsObject.isJSFastArgumentsObject(thisObj) || !JSAbstractArgumentsObject.wasIndexDisconnected(thisObj, index);
            if (isMapped) {
                desc.setValue(super.get(thisObj, index));
            }
        }
        if (desc.isDataDescriptor() && CALLER.equals(key) && JSFunction.isJSFunction(desc.getValue()) && JSFunction.isStrict((DynamicObject)desc.getValue())) {
            throw Errors.createTypeError("caller not allowed in strict mode");
        }
        return desc;
    }

    static {
        Shape.Allocator allocator = JSAbstractArgumentsObject.addArrayProperties(JSShape.makeStaticRoot(JSObject.LAYOUT, Null.NULL_CLASS, 0)).allocator();
        CONNECTED_ARGUMENT_COUNT_PROPERTY = JSObjectUtil.makeHiddenProperty(CONNECTED_ARGUMENT_COUNT_ID, allocator.locationForType(Integer.TYPE, EnumSet.of(LocationModifier.Final)));
    }
}

