/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.project.install.internal;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.artifact.ProjectArtifact;
import org.apache.maven.project.artifact.ProjectArtifactMetadata;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstaller;
import org.apache.maven.shared.transfer.artifact.install.ArtifactInstallerException;
import org.apache.maven.shared.transfer.project.NoFileAssignedException;
import org.apache.maven.shared.transfer.project.install.ProjectInstaller;
import org.apache.maven.shared.transfer.project.install.ProjectInstallerRequest;
import org.apache.maven.shared.transfer.repository.RepositoryManager;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=ProjectInstaller.class)
class DefaultProjectInstaller
implements ProjectInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultProjectInstaller.class);
    @Requirement
    private ArtifactInstaller installer;
    @Requirement
    private RepositoryManager repositoryManager;

    DefaultProjectInstaller() {
    }

    @Override
    public void install(ProjectBuildingRequest buildingRequest, ProjectInstallerRequest installerRequest) throws IOException, ArtifactInstallerException, NoFileAssignedException, IllegalArgumentException {
        this.validateParameters(buildingRequest, installerRequest);
        MavenProject project = installerRequest.getProject();
        Artifact artifact = project.getArtifact();
        String packaging = project.getPackaging();
        File pomFile = project.getFile();
        List attachedArtifacts = project.getAttachedArtifacts();
        boolean isPomArtifact = "pom".equals(packaging);
        LinkedHashSet<File> metadataFiles = new LinkedHashSet<File>();
        if (isPomArtifact) {
            if (pomFile != null) {
                this.installer.install(buildingRequest, Collections.singletonList(new ProjectArtifact(project)));
                this.addMetaDataFilesForArtifact(buildingRequest, artifact, metadataFiles);
            }
        } else {
            File file;
            if (pomFile != null) {
                ProjectArtifactMetadata metadata = new ProjectArtifactMetadata(artifact, pomFile);
                artifact.addMetadata((ArtifactMetadata)metadata);
            }
            if ((file = artifact.getFile()) != null && file.isFile()) {
                this.installer.install(buildingRequest, Collections.singletonList(artifact));
                this.addMetaDataFilesForArtifact(buildingRequest, artifact, metadataFiles);
            } else {
                if (!attachedArtifacts.isEmpty()) {
                    throw new NoFileAssignedException("The packaging plugin for this project did not assign a main file to the project but it has attachments. Change packaging to 'pom'.");
                }
                throw new NoFileAssignedException("The packaging for this project did not assign a file to the build artifact");
            }
        }
        for (Artifact attached : attachedArtifacts) {
            LOGGER.debug("Installing artifact: ", (Object)attached.getId());
            this.installer.install(buildingRequest, Collections.singletonList(attached));
            this.addMetaDataFilesForArtifact(buildingRequest, attached, metadataFiles);
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, ProjectInstallerRequest installerRequest) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
        if (installerRequest == null) {
            throw new IllegalArgumentException("The parameter installerRequest is not allowed to be null.");
        }
    }

    private void addMetaDataFilesForArtifact(ProjectBuildingRequest buildingRequest, Artifact artifact, Collection<File> targetMetadataFiles) {
        Collection metadatas = artifact.getMetadataList();
        if (metadatas != null) {
            for (ArtifactMetadata metadata : metadatas) {
                File metadataFile = this.getLocalRepoFile(buildingRequest, metadata);
                targetMetadataFiles.add(metadataFile);
            }
        }
    }

    private File getLocalRepoFile(ProjectBuildingRequest buildingRequest, ArtifactMetadata metadata) {
        String path = this.repositoryManager.getPathForLocalMetadata(buildingRequest, metadata);
        return new File(this.repositoryManager.getLocalRepositoryBasedir(buildingRequest), path);
    }
}

