/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.access;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Executed;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.StandardTags;
import com.oracle.truffle.api.instrumentation.Tag;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.js.nodes.JavaScriptNode;
import com.oracle.truffle.js.nodes.access.JSGuardDisconnectedArgumentWriteNodeGen;
import com.oracle.truffle.js.nodes.access.WriteElementNode;
import com.oracle.truffle.js.nodes.access.WriteNode;
import com.oracle.truffle.js.nodes.instrumentation.JSTags;
import com.oracle.truffle.js.nodes.instrumentation.NodeObjectDescriptor;
import com.oracle.truffle.js.runtime.builtins.JSArgumentsObject;
import java.util.Set;

public abstract class JSGuardDisconnectedArgumentWrite
extends JavaScriptNode
implements WriteNode {
    private final int index;
    @Node.Child
    @Executed
    JavaScriptNode argumentsArrayNode;
    @Node.Child
    @Executed
    JavaScriptNode rhsNode;
    @Node.Child
    private WriteElementNode writeArgumentsElementNode;
    private final FrameSlot slot;

    JSGuardDisconnectedArgumentWrite(int index, WriteElementNode argumentsArrayAccess, JavaScriptNode argumentsArray, JavaScriptNode rhs, FrameSlot slot) {
        this.index = index;
        this.argumentsArrayNode = argumentsArray;
        this.rhsNode = rhs;
        this.writeArgumentsElementNode = argumentsArrayAccess;
        this.slot = slot;
    }

    public static JSGuardDisconnectedArgumentWrite create(int index, WriteElementNode argumentsArrayAccess, JavaScriptNode argumentsArray, JavaScriptNode rhs, FrameSlot slot) {
        return JSGuardDisconnectedArgumentWriteNodeGen.create(index, argumentsArrayAccess, argumentsArray, rhs, slot);
    }

    @Override
    public boolean hasTag(Class<? extends Tag> tag) {
        if (tag == JSTags.WriteVariableTag.class || tag == StandardTags.WriteVariableTag.class) {
            return true;
        }
        return super.hasTag(tag);
    }

    public Object getNodeObject() {
        NodeObjectDescriptor descriptor = JSTags.createNodeObjectDescriptor("name", this.slot.getIdentifier());
        descriptor.addProperty("writeVariableName", this.slot.getIdentifier());
        return descriptor;
    }

    @Specialization(guards={"!isArgumentsDisconnected(argumentsArray)"})
    public Object doObject(DynamicObject argumentsArray, Object value, @Cached(value="createBinaryProfile()") @Cached.Shared(value="unconnected") ConditionProfile unconnected) {
        assert (JSArgumentsObject.isJSArgumentsObject(argumentsArray));
        if (unconnected.profile(this.index >= JSArgumentsObject.getConnectedArgumentCount(argumentsArray))) {
            JSArgumentsObject.disconnectIndex(argumentsArray, this.index, value);
        } else {
            this.writeArgumentsElementNode.executeWithTargetAndIndexAndValue((Object)argumentsArray, this.index, value);
        }
        return value;
    }

    @Specialization(guards={"isArgumentsDisconnected(argumentsArray)"})
    public Object doObjectDisconnected(DynamicObject argumentsArray, Object value, @Cached(value="createBinaryProfile()") ConditionProfile wasDisconnected, @Cached(value="createBinaryProfile()") @Cached.Shared(value="unconnected") ConditionProfile unconnected) {
        assert (JSArgumentsObject.isJSArgumentsObject(argumentsArray));
        if (wasDisconnected.profile(JSArgumentsObject.wasIndexDisconnected(argumentsArray, this.index))) {
            JSArgumentsObject.setDisconnectedIndexValue(argumentsArray, this.index, value);
        } else if (unconnected.profile(this.index >= JSArgumentsObject.getConnectedArgumentCount(argumentsArray))) {
            JSArgumentsObject.disconnectIndex(argumentsArray, this.index, value);
        } else {
            this.writeArgumentsElementNode.executeWithTargetAndIndexAndValue((Object)argumentsArray, this.index, value);
        }
        return value;
    }

    @Override
    public final Object executeWrite(VirtualFrame frame, Object value) {
        return this.executeWrite(frame, this.argumentsArrayNode.execute(frame), value);
    }

    protected abstract Object executeWrite(VirtualFrame var1, Object var2, Object var3);

    @Override
    public JavaScriptNode getRhs() {
        return this.rhsNode;
    }

    @Override
    protected JavaScriptNode copyUninitialized(Set<Class<? extends Tag>> materializedTags) {
        return JSGuardDisconnectedArgumentWriteNodeGen.create(this.index, JSGuardDisconnectedArgumentWrite.cloneUninitialized(this.writeArgumentsElementNode, materializedTags), JSGuardDisconnectedArgumentWrite.cloneUninitialized(this.argumentsArrayNode, materializedTags), JSGuardDisconnectedArgumentWrite.cloneUninitialized(this.rhsNode, materializedTags), this.slot);
    }
}

